/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestIncrement {
    @Test
    public void test() {
        long expected = 13L;
        Increment inc = new Increment(new byte[]{114});
        int total = 0;
        for (int i = 0; i < 2; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            inc.addColumn(bytes, bytes, 13L);
            ++total;
        }
        Map familyMapOfLongs = inc.getFamilyMapOfLongs();
        int found = 0;
        for (Map.Entry entry : familyMapOfLongs.entrySet()) {
            for (Map.Entry e : ((NavigableMap)entry.getValue()).entrySet()) {
                Assert.assertEquals((long)13L, (long)((Long)e.getValue()));
                ++found;
            }
        }
        Assert.assertEquals((long)total, (long)found);
    }
}

