/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.util.Progressable;

public class ProgressableResettableBufferedFileInputStream
extends InputStream {
    protected File file;
    protected Progressable progressable;
    private BufferedInputStream inputStream;
    private long mark = 0L;
    private long pos = 0L;

    public ProgressableResettableBufferedFileInputStream(File file, Progressable progressable) throws IOException {
        this.file = file;
        this.progressable = progressable;
        this.inputStream = new BufferedInputStream(new FileInputStream(file));
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.progressable != null) {
            this.progressable.progress();
        }
        this.mark = this.pos;
    }

    @Override
    public boolean markSupported() {
        if (this.progressable != null) {
            this.progressable.progress();
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        int read;
        if (this.progressable != null) {
            this.progressable.progress();
        }
        if ((read = this.inputStream.read()) != -1) {
            ++this.pos;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        if (this.progressable != null) {
            this.progressable.progress();
        }
        if ((read = this.inputStream.read(b, off, len)) != -1) {
            this.pos += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read;
        if (this.progressable != null) {
            this.progressable.progress();
        }
        if ((read = this.inputStream.read(b)) != -1) {
            this.pos += (long)read;
        }
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.progressable != null) {
            this.progressable.progress();
        }
        this.inputStream.close();
        this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
        this.pos = this.inputStream.skip(this.mark);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.progressable != null) {
            this.progressable.progress();
        }
        long skipped = this.inputStream.skip(n);
        this.pos += skipped;
        return skipped;
    }
}

