/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.hadoop.fs.s3native.PartialListing;
import org.apache.hadoop.util.Progressable;

interface NativeFileSystemStore {
    public void initialize(URI var1, Configuration var2) throws IOException;

    public void storeFile(String var1, File var2, byte[] var3, Progressable var4) throws IOException;

    public void storeFile(String var1, File var2, byte[] var3) throws IOException;

    public void storeEmptyFile(String var1) throws IOException;

    public FileMetadata retrieveMetadata(String var1) throws IOException;

    public InputStream retrieve(String var1) throws IOException;

    public InputStream retrieve(String var1, long var2) throws IOException;

    public InputStreamPair retrievePair(String var1) throws IOException;

    public InputStreamPair retrievePair(String var1, long var2) throws IOException;

    public PartialListing list(String var1, int var2) throws IOException;

    public PartialListing list(String var1, int var2, String var3, boolean var4) throws IOException;

    public void delete(String var1) throws IOException;

    public void copy(String var1, String var2) throws IOException;

    public void purge(String var1) throws IOException;

    public void dump() throws IOException;

    public static class InputStreamPair {
        public S3ObjectInputStream in;
        public long contentLength;
        public String key;

        public InputStreamPair(S3ObjectInputStream inputStream, String key, int contentLength) {
            this.in = inputStream;
            this.contentLength = contentLength;
            this.key = key;
        }

        public InputStreamPair() {
        }
    }
}

