/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;

public class FileStatusCache {
    private TreeMap<String, FileStatus> cache = new TreeMap();
    private String listedKey;
    public static final Log log = LogFactory.getLog((String)"org.apache.hadoop.fs.s3native.FileStatusCache");

    public synchronized void buildCache(TreeMap<String, FileStatus> cache, String listedKey) {
        if (cache != null) {
            this.cache = cache;
        } else {
            this.clearCache();
        }
        this.listedKey = listedKey;
    }

    public synchronized void clearCache() {
        this.cache.clear();
    }

    public synchronized boolean isCached(String key) {
        if (!this.cache.isEmpty() && key.compareTo(this.cache.lastKey()) <= 0) {
            if (key.startsWith(this.listedKey)) {
                return true;
            }
            return key.compareTo(this.cache.firstKey()) >= 0;
        }
        return false;
    }

    public synchronized FileStatus getFileStatus(String key, NativeS3FileSystem parent) {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        String keyFolder = key + "_$folder$";
        if (this.cache.containsKey(keyFolder)) {
            return this.cache.get(keyFolder);
        }
        String dirKey = key + "/";
        if (this.cache.ceilingKey(dirKey) != null && this.cache.ceilingKey(dirKey).startsWith(dirKey)) {
            return parent.newDirectory(new Path("/" + key).makeQualified((FileSystem)parent));
        }
        return null;
    }

    public synchronized List<FileStatus> listStatus(String key) {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        if (this.cache.containsKey(key)) {
            if (!this.cache.get(key).isDir()) {
                result.add(this.cache.get(key));
                return result;
            }
            if (!this.cache.lastKey().startsWith(key)) {
                key = key + "/";
                SortedMap<String, FileStatus> elements = this.cache.tailMap(key);
                for (String element : elements.keySet()) {
                    if (element.startsWith(key)) {
                        if (!this.isImmediateMember(element, key)) continue;
                        result.add((FileStatus)elements.get(element));
                        continue;
                    }
                    if (result.size() > 0) {
                        return result;
                    }
                    return null;
                }
                return result;
            }
        }
        return null;
    }

    private void dumpCache() {
        log.info((Object)"Dumping cache");
        for (String key : this.cache.keySet()) {
            log.info((Object)key);
        }
        log.info((Object)"Finished dumpint cache");
    }

    private boolean isImmediateMember(String element, String key) {
        return !element.substring(key.length()).contains("/");
    }
}

