/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;

public class DirectFileOutputCommitter
extends FileOutputCommitter {
    private static final Log LOG = LogFactory.getLog(DirectFileOutputCommitter.class);
    private Path outputPath = null;
    private final boolean directWrite;

    public DirectFileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        if (outputPath != null && context != null) {
            this.outputPath = outputPath;
            this.directWrite = DirectFileOutputCommitter.isDirectWrite(context.getConfiguration(), outputPath.getFileSystem(context.getConfiguration()));
        } else {
            this.directWrite = false;
        }
    }

    public void setupJob(JobContext context) throws IOException {
        if (this.directWrite) {
            LOG.info((Object)"Nothing to setup since the outputs are written directly.");
        } else {
            super.setupJob(context);
        }
    }

    public void cleanupJob(JobContext context) throws IOException {
        if (this.directWrite) {
            LOG.info((Object)"Nothing to clean up since no temporary files were written.");
        } else {
            super.cleanupJob(context);
        }
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        if (!this.directWrite) {
            super.setupTask(context);
        }
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        if (this.directWrite) {
            LOG.info((Object)"Commit should not be called since this task doesnt have any commitable files. Also needsTaskCommit returns false");
        } else {
            super.commitTask(context);
        }
    }

    public void abortTask(TaskAttemptContext context) {
        if (this.directWrite) {
            LOG.info((Object)"Nothing to clean up on abort since there are no temporary files written");
        } else {
            super.abortTask(context);
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        if (this.directWrite) {
            return false;
        }
        return super.needsTaskCommit(context);
    }

    public Path getWorkPath() throws IOException {
        if (this.directWrite) {
            return this.outputPath;
        }
        return super.getWorkPath();
    }

    private static boolean isDirectWrite(Configuration c, FileSystem fs) {
        return c.getBoolean("mapred.output.direct." + fs.getClass().getSimpleName(), false);
    }
}

