/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.TaskAttemptContext;

public class DirectFileOutputCommitter
extends FileOutputCommitter {
    private static final Log LOG = LogFactory.getLog(DirectFileOutputCommitter.class);

    public void setupJob(JobContext context) throws IOException {
        if (this.isDirectWrite(context)) {
            LOG.info((Object)"Nothing to setup since the outputs are written directly.");
        } else {
            super.setupJob(context);
        }
    }

    public void cleanupJob(JobContext context) throws IOException {
        if (this.isDirectWrite(context)) {
            LOG.info((Object)"Nothing to clean up since no temporary files were written.");
        } else {
            super.cleanupJob(context);
        }
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        if (!this.isDirectWrite(context)) {
            super.setupTask(context);
        }
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        if (this.isDirectWrite(context)) {
            LOG.info((Object)"Commit should not be called since this task doesnt have any commitable files. Also needsTaskCommit returns false");
        } else {
            super.commitTask(context);
        }
    }

    public void abortTask(TaskAttemptContext context) throws IOException {
        if (this.isDirectWrite(context)) {
            LOG.info((Object)"Nothing to clean up on abort since there are no temporary files written");
        } else {
            super.abortTask(context);
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        if (this.isDirectWrite(context)) {
            return false;
        }
        return super.needsTaskCommit(context);
    }

    public Path getWorkPath(TaskAttemptContext taskContext, Path basePath) throws IOException {
        if (this.isDirectWrite(taskContext)) {
            return FileOutputFormat.getOutputPath((JobConf)taskContext.getJobConf());
        }
        return super.getWorkPath(taskContext, basePath);
    }

    private boolean isDirectWrite(TaskAttemptContext c) throws IOException {
        return this.isDirectWrite(c.getJobConf(), c.getConfiguration());
    }

    private boolean isDirectWrite(JobContext jc) throws IOException {
        return this.isDirectWrite(jc.getJobConf(), jc.getConfiguration());
    }

    private boolean isDirectWrite(JobConf conf, Configuration config) throws IOException {
        Path p = FileOutputFormat.getOutputPath((JobConf)conf);
        if (p == null) {
            return false;
        }
        FileSystem fs = p.getFileSystem((Configuration)conf);
        return config.getBoolean("mapred.output.direct." + fs.getClass().getSimpleName(), false);
    }
}

