/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpServletRequestWrapper;
import org.apache.hadoop.yarn.server.webproxy.amfilter.TestAmFilter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAmFilter {
    private String proxyHost = "localhost";
    private String proxyUri = "http://bogus";
    private String doFilterRequest;
    private AmIpServletRequestWrapper servletWrapper;

    @Test(timeout=5000L)
    public void filterNullCookies() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getCookies()).thenReturn(null);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)this.proxyHost);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        AtomicBoolean invoked = new AtomicBoolean();
        1 chain = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PROXY_HOST", this.proxyHost);
        params.put("PROXY_URI_BASE", this.proxyUri);
        DummyFilterConfig conf = new DummyFilterConfig(params);
        TestAmIpFilter filter = new TestAmIpFilter(this, null);
        filter.init((FilterConfig)conf);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((boolean)invoked.get());
        filter.destroy();
    }

    @Test(timeout=1000L)
    public void testFilter() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PROXY_HOST", this.proxyHost);
        params.put("PROXY_URI_BASE", this.proxyUri);
        DummyFilterConfig config = new DummyFilterConfig(params);
        2 chain = new /* Unavailable Anonymous Inner Class!! */;
        AmIpFilter testFilter = new AmIpFilter();
        testFilter.init((FilterConfig)config);
        HttpServletResponseForTest response = new HttpServletResponseForTest(this, null);
        ServletRequest failRequest = (ServletRequest)Mockito.mock(ServletRequest.class);
        try {
            testFilter.doFilter(failRequest, (ServletResponse)response, (FilterChain)chain);
            Assert.fail();
        }
        catch (ServletException e) {
            Assert.assertEquals((Object)"This filter only works for HTTP/HTTPS", (Object)e.getMessage());
        }
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"redirect");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/redirect");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)302L, (long)response.status);
        String redirect = response.getHeader("Location");
        Assert.assertEquals((Object)"http://bogus/redirect", (Object)redirect);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((boolean)this.doFilterRequest.contains("javax.servlet.http.HttpServletRequest"));
        Cookie[] cookies = new Cookie[]{new Cookie("proxy-user", "user")};
        Mockito.when((Object)request.getCookies()).thenReturn((Object)cookies);
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((Object)"org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpServletRequestWrapper", (Object)this.doFilterRequest);
        Assert.assertEquals((Object)"user", (Object)this.servletWrapper.getUserPrincipal().getName());
        Assert.assertEquals((Object)"user", (Object)this.servletWrapper.getRemoteUser());
        Assert.assertFalse((boolean)this.servletWrapper.isUserInRole(""));
    }

    static /* synthetic */ String access$000(TestAmFilter x0) {
        return x0.proxyHost;
    }

    static /* synthetic */ String access$202(TestAmFilter x0, String x1) {
        x0.doFilterRequest = x1;
        return x0.doFilterRequest;
    }

    static /* synthetic */ AmIpServletRequestWrapper access$302(TestAmFilter x0, AmIpServletRequestWrapper x1) {
        x0.servletWrapper = x1;
        return x0.servletWrapper;
    }
}

