/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestProxyUriUtils {
    @Test
    public void testGetPathApplicationId() {
        Assert.assertEquals((Object)"/proxy/application_100_0001", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)100L, (int)1)));
        Assert.assertEquals((Object)"/proxy/application_6384623_0005", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPathApplicationIdBad() {
        ProxyUriUtils.getPath(null);
    }

    @Test
    public void testGetPathApplicationIdString() {
        Assert.assertEquals((Object)"/proxy/application_6384623_0005", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), null));
        Assert.assertEquals((Object)"/proxy/application_6384623_0005/static/app", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"/static/app"));
        Assert.assertEquals((Object)"/proxy/application_6384623_0005/", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"/"));
        Assert.assertEquals((Object)"/proxy/application_6384623_0005/some/path", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"some/path"));
    }

    @Test
    public void testGetPathAndQuery() {
        Assert.assertEquals((Object)"/proxy/application_6384623_0005/static/app?foo=bar", (Object)ProxyUriUtils.getPathAndQuery((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"/static/app", (String)"?foo=bar", (boolean)false));
        Assert.assertEquals((Object)"/proxy/application_6384623_0005/static/app?foo=bar&bad=good&proxyapproved=true", (Object)ProxyUriUtils.getPathAndQuery((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"/static/app", (String)"foo=bar&bad=good", (boolean)true));
    }

    @Test
    public void testGetProxyUri() throws Exception {
        URI originalUri = new URI("http://host.com/static/foo?bar=bar");
        URI proxyUri = new URI("http://proxy.net:8080/");
        ApplicationId id = BuilderUtils.newApplicationId((long)6384623L, (int)5);
        URI expected = new URI("http://proxy.net:8080/proxy/application_6384623_0005/static/foo?bar=bar");
        URI result = ProxyUriUtils.getProxyUri((URI)originalUri, (URI)proxyUri, (ApplicationId)id);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testGetProxyUriNull() throws Exception {
        URI originalUri = null;
        URI proxyUri = new URI("http://proxy.net:8080/");
        ApplicationId id = BuilderUtils.newApplicationId((long)6384623L, (int)5);
        URI expected = new URI("http://proxy.net:8080/proxy/application_6384623_0005/");
        URI result = ProxyUriUtils.getProxyUri(originalUri, (URI)proxyUri, (ApplicationId)id);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testGetProxyUriFromPluginsReturnsNullIfNoPlugins() throws URISyntaxException {
        ApplicationId id = BuilderUtils.newApplicationId((long)6384623L, (int)5);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)0);
        Assert.assertNull((Object)ProxyUriUtils.getUriFromTrackingPlugins((ApplicationId)id, (List)list));
    }

    @Test
    public void testGetProxyUriFromPluginsReturnsValidUriWhenAble() throws URISyntaxException {
        ApplicationId id = BuilderUtils.newApplicationId((long)6384623L, (int)5);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)2);
        list.add(new /* Unavailable Anonymous Inner Class!! */);
        list.add(new /* Unavailable Anonymous Inner Class!! */);
        URI result = ProxyUriUtils.getUriFromTrackingPlugins((ApplicationId)id, (List)list);
        Assert.assertNotNull((Object)result);
    }
}

