/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;

public class MiniYARNCluster
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(MiniYARNCluster.class);
    private NodeManager[] nodeManagers;
    private ResourceManager resourceManager;
    private ResourceManagerWrapper resourceManagerWrapper;
    private File testWorkDir;
    private int numLocalDirs;
    private int numLogDirs;

    public MiniYARNCluster(String testName, int noOfNodeManagers, int numLocalDirs, int numLogDirs) {
        super(testName.replace("$", ""));
        this.numLocalDirs = numLocalDirs;
        this.numLogDirs = numLogDirs;
        String testSubDir = testName.replace("$", "");
        File targetWorkDir = new File("target", testSubDir);
        try {
            FileContext.getLocalFSFileContext().delete(new Path(targetWorkDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            LOG.warn((Object)"COULD NOT CLEANUP", (Throwable)e);
            throw new YarnRuntimeException("could not cleanup test dir: " + e, (Throwable)e);
        }
        if (Shell.WINDOWS) {
            String targetPath = targetWorkDir.getAbsolutePath();
            File link = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()));
            String linkPath = link.getAbsolutePath();
            try {
                FileContext.getLocalFSFileContext().delete(new Path(linkPath), true);
            }
            catch (IOException e) {
                throw new YarnRuntimeException("could not cleanup symlink: " + linkPath, (Throwable)e);
            }
            targetWorkDir.mkdirs();
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(Shell.getSymlinkCommand((String)targetPath, (String)linkPath));
            try {
                shexec.execute();
            }
            catch (IOException e) {
                throw new YarnRuntimeException(String.format("failed to create symlink from %s to %s, shell output: %s", linkPath, targetPath, shexec.getOutput()), (Throwable)e);
            }
            this.testWorkDir = link;
        } else {
            this.testWorkDir = targetWorkDir;
        }
        this.resourceManagerWrapper = new ResourceManagerWrapper(this);
        this.addService((Service)this.resourceManagerWrapper);
        this.nodeManagers = new CustomNodeManager[noOfNodeManagers];
        for (int index = 0; index < noOfNodeManagers; ++index) {
            this.addService((Service)new NodeManagerWrapper(this, index));
            this.nodeManagers[index] = new CustomNodeManager(this, null);
        }
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
    }

    public File getTestWorkDir() {
        return this.testWorkDir;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public NodeManager getNodeManager(int i) {
        return this.nodeManagers[i];
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    static /* synthetic */ ResourceManager access$102(MiniYARNCluster x0, ResourceManager x1) {
        x0.resourceManager = x1;
        return x0.resourceManager;
    }

    static /* synthetic */ ResourceManager access$100(MiniYARNCluster x0) {
        return x0.resourceManager;
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }

    static /* synthetic */ File access$300(MiniYARNCluster x0) {
        return x0.testWorkDir;
    }

    static /* synthetic */ int access$400(MiniYARNCluster x0) {
        return x0.numLocalDirs;
    }

    static /* synthetic */ int access$500(MiniYARNCluster x0) {
        return x0.numLogDirs;
    }

    static /* synthetic */ NodeManager[] access$600(MiniYARNCluster x0) {
        return x0.nodeManagers;
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }
}

