/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerUtils {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final String RELEASED_CONTAINER = "Container released by application";
    public static final String LOST_CONTAINER = "Container released on a *lost* node";
    public static final String PREEMPTED_CONTAINER = "Container preempted by scheduler";
    public static final String COMPLETED_APPLICATION = "Container of a completed application";
    public static final String EXPIRED_CONTAINER = "Container expired since it was unused";
    public static final String UNRESERVED_CONTAINER = "Container reservation no longer required.";

    public static ContainerStatus createAbnormalContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -100, diagnostics);
    }

    public static ContainerStatus createPreemptedContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -102, diagnostics);
    }

    private static ContainerStatus createAbnormalContainerStatus(ContainerId containerId, int exitStatus, String diagnostics) {
        ContainerStatus containerStatus = (ContainerStatus)recordFactory.newRecordInstance(ContainerStatus.class);
        containerStatus.setContainerId(containerId);
        containerStatus.setDiagnostics(diagnostics);
        containerStatus.setExitStatus(exitStatus);
        containerStatus.setState(ContainerState.COMPLETE);
        return containerStatus;
    }

    public static void normalizeRequests(List<ResourceRequest> asks, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource, Resource maximumResource) {
        for (ResourceRequest ask : asks) {
            SchedulerUtils.normalizeRequest(ask, resourceCalculator, clusterResource, minimumResource, maximumResource, minimumResource);
        }
    }

    public static void normalizeRequest(ResourceRequest ask, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource, Resource maximumResource) {
        Resource normalized = Resources.normalize((ResourceCalculator)resourceCalculator, (Resource)ask.getCapability(), (Resource)minimumResource, (Resource)maximumResource, (Resource)minimumResource);
        ask.setCapability(normalized);
    }

    public static void normalizeRequests(List<ResourceRequest> asks, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource, Resource maximumResource, Resource incrementResource) {
        for (ResourceRequest ask : asks) {
            SchedulerUtils.normalizeRequest(ask, resourceCalculator, clusterResource, minimumResource, maximumResource, incrementResource);
        }
    }

    public static void normalizeRequest(ResourceRequest ask, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource, Resource maximumResource, Resource incrementResource) {
        Resource normalized = Resources.normalize((ResourceCalculator)resourceCalculator, (Resource)ask.getCapability(), (Resource)minimumResource, (Resource)maximumResource, (Resource)incrementResource);
        ask.setCapability(normalized);
    }

    private static void normalizeNodeLabelExpressionInRequest(ResourceRequest resReq, QueueInfo queueInfo) {
        String labelExp = resReq.getNodeLabelExpression();
        if (labelExp == null && queueInfo != null && "*".equals(resReq.getResourceName())) {
            labelExp = queueInfo.getDefaultNodeLabelExpression();
        }
        if (labelExp == null) {
            labelExp = "";
        }
        resReq.setNodeLabelExpression(labelExp);
    }

    public static void normalizeAndValidateRequest(ResourceRequest resReq, Resource maximumResource, String queueName, YarnScheduler scheduler, boolean isRecovery) throws InvalidResourceRequestException {
        QueueInfo queueInfo = null;
        try {
            queueInfo = scheduler.getQueueInfo(queueName, false, false);
        }
        catch (IOException e) {
            // empty catch block
        }
        SchedulerUtils.normalizeNodeLabelExpressionInRequest(resReq, queueInfo);
        if (!isRecovery) {
            SchedulerUtils.validateResourceRequest(resReq, maximumResource, queueInfo);
        }
    }

    public static void normalizeAndvalidateRequest(ResourceRequest resReq, Resource maximumResource, String queueName, YarnScheduler scheduler) throws InvalidResourceRequestException {
        SchedulerUtils.normalizeAndValidateRequest(resReq, maximumResource, queueName, scheduler, false);
    }

    public static void validateResourceRequest(ResourceRequest resReq, Resource maximumResource, QueueInfo queueInfo) throws InvalidResourceRequestException {
        if (resReq.getCapability().getMemory() < 0 || resReq.getCapability().getMemory() > maximumResource.getMemory()) {
            throw new InvalidResourceRequestException("Invalid resource request, requested memory < 0, or requested memory > max configured, requestedMemory=" + resReq.getCapability().getMemory() + ", maxMemory=" + maximumResource.getMemory());
        }
        if (resReq.getCapability().getVirtualCores() < 0 || resReq.getCapability().getVirtualCores() > maximumResource.getVirtualCores()) {
            throw new InvalidResourceRequestException("Invalid resource request, requested virtual cores < 0, or requested virtual cores > max configured, requestedVirtualCores=" + resReq.getCapability().getVirtualCores() + ", maxVirtualCores=" + maximumResource.getVirtualCores());
        }
        if (resReq.getCapability().getDisks() < 0.0 || resReq.getCapability().getDisks() > maximumResource.getDisks()) {
            throw new InvalidResourceRequestException("Invalid resource request, requested disks < 0, or requested disks > max configured, requestedDisks=" + resReq.getCapability().getDisks() + ", maxDisks=" + maximumResource.getDisks());
        }
        String labelExp = resReq.getNodeLabelExpression();
        if (!"*".equals(resReq.getResourceName()) && labelExp != null && !labelExp.trim().isEmpty()) {
            throw new InvalidResourceRequestException("Invailid resource request, queue=" + queueInfo.getQueueName() + " specified node label expression in a " + "resource request has resource name = " + resReq.getResourceName());
        }
        if (labelExp != null && labelExp.contains("&&")) {
            throw new InvalidResourceRequestException("Invailid resource request, queue=" + queueInfo.getQueueName() + " specified more than one node label " + "in a node label expression, node label expression = " + labelExp);
        }
        if (labelExp != null && !labelExp.trim().isEmpty() && queueInfo != null && !SchedulerUtils.checkQueueLabelExpression(queueInfo.getAccessibleNodeLabels(), labelExp)) {
            throw new InvalidResourceRequestException("Invalid resource request, queue=" + queueInfo.getQueueName() + " doesn't have permission to access all labels " + "in resource request. labelExpression of resource request=" + labelExp + ". Queue labels=" + (queueInfo.getAccessibleNodeLabels() == null ? "" : StringUtils.join(queueInfo.getAccessibleNodeLabels().iterator(), (char)',')));
        }
    }

    public static boolean checkQueueAccessToNode(Set<String> queueLabels, Set<String> nodeLabels) {
        if (queueLabels != null && queueLabels.contains("*")) {
            return true;
        }
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            return true;
        }
        return queueLabels != null && Sets.intersection(queueLabels, nodeLabels).size() > 0;
    }

    public static void checkIfLabelInClusterNodeLabels(RMNodeLabelsManager mgr, Set<String> labels) throws IOException {
        if (mgr == null) {
            if (labels != null && !labels.isEmpty()) {
                throw new IOException("NodeLabelManager is null, please check");
            }
            return;
        }
        if (labels != null) {
            for (String label : labels) {
                if (label.equals("*") || mgr.containsNodeLabel(label)) continue;
                throw new IOException("NodeLabelManager doesn't include label = " + label + ", please check.");
            }
        }
    }

    public static boolean checkNodeLabelExpression(Set<String> nodeLabels, String labelExpression) {
        if ((labelExpression == null || labelExpression.trim().isEmpty()) && !nodeLabels.isEmpty()) {
            return false;
        }
        if (labelExpression != null) {
            for (String str : labelExpression.split("&&")) {
                if (str.trim().isEmpty() || nodeLabels != null && nodeLabels.contains(str.trim())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkQueueLabelExpression(Set<String> queueLabels, String labelExpression) {
        if (queueLabels != null && queueLabels.contains("*")) {
            return true;
        }
        if (labelExpression == null) {
            return true;
        }
        for (String str : labelExpression.split("&&")) {
            if (str.trim().isEmpty() || queueLabels != null && queueLabels.contains(str.trim())) continue;
            return false;
        }
        return true;
    }

    public static AccessType toAccessType(QueueACL acl) {
        switch (acl) {
            case ADMINISTER_QUEUE: {
                return AccessType.ADMINISTER_QUEUE;
            }
            case SUBMIT_APPLICATIONS: {
                return AccessType.SUBMIT_APP;
            }
        }
        return null;
    }
}

