/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueueParsing {
    private static final Log LOG = LogFactory.getLog(TestQueueParsing.class);
    private static final double DELTA = 1.0E-6;
    private RMNodeLabelsManager nodeLabelManager;

    @Before
    public void setup() {
        this.nodeLabelManager = new NullRMNodeLabelsManager();
        this.nodeLabelManager.init((Configuration)new YarnConfiguration());
        this.nodeLabelManager.start();
    }

    @Test
    public void testQueueParsing() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        capacityScheduler.setConf((Configuration)conf);
        capacityScheduler.setRMContext(TestUtils.getMockRMContext());
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        capacityScheduler.reinitialize((Configuration)conf, TestUtils.getMockRMContext());
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue b1 = capacityScheduler.getQueue("b1");
        Assert.assertEquals((double)0.1, (double)b1.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((String)"Parent B has no MAX_CAP", (double)0.85, (double)b1.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue c12 = capacityScheduler.getQueue("c12");
        Assert.assertEquals((double)0.1575, (double)c12.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.26949999999999996, (double)c12.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        ServiceOperations.stopQuietly((Service)capacityScheduler);
    }

    private void setupQueueConfigurationWithSpacesShouldBeTrimmed(CapacitySchedulerConfiguration conf) {
        conf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)"root") + "queues", " a ,b, c");
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
    }

    private void setupNestedQueueConfigurationWithSpacesShouldBeTrimmed(CapacitySchedulerConfiguration conf) {
        conf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)"root") + "queues", " a ,b, c");
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
        conf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)"root.a") + "queues", "a1, a2 ");
        String A1 = "root.a.a1";
        conf.setCapacity("root.a.a1", 60.0f);
        String A2 = "root.a.a2";
        conf.setCapacity("root.a.a2", 40.0f);
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b", "c"});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
        LOG.info((Object)"Setup top-level queues");
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 45.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setMaximumCapacity("root.b.b1", 85.0f);
        conf.setCapacity("root.b.b2", 30.0f);
        conf.setMaximumCapacity("root.b.b2", 35.0f);
        conf.setCapacity("root.b.b3", 20.0f);
        conf.setMaximumCapacity("root.b.b3", 35.0f);
        String C1 = "root.c.c1";
        String C2 = "root.c.c2";
        String C3 = "root.c.c3";
        String C4 = "root.c.c4";
        conf.setQueues("root.c", new String[]{"c1", "c2", "c3", "c4"});
        conf.setCapacity("root.c.c1", 50.0f);
        conf.setMaximumCapacity("root.c.c1", 55.0f);
        conf.setCapacity("root.c.c2", 10.0f);
        conf.setMaximumCapacity("root.c.c2", 25.0f);
        conf.setCapacity("root.c.c3", 35.0f);
        conf.setMaximumCapacity("root.c.c3", 38.0f);
        conf.setCapacity("root.c.c4", 5.0f);
        conf.setMaximumCapacity("root.c.c4", 5.0f);
        LOG.info((Object)"Setup 2nd-level queues");
        String C11 = "root.c.c1.c11";
        String C12 = "root.c.c1.c12";
        String C13 = "root.c.c1.c13";
        conf.setQueues("root.c.c1", new String[]{"c11", "c12", "c13"});
        conf.setCapacity("root.c.c1.c11", 15.0f);
        conf.setMaximumCapacity("root.c.c1.c11", 30.0f);
        conf.setCapacity("root.c.c1.c12", 45.0f);
        conf.setMaximumCapacity("root.c.c1.c12", 70.0f);
        conf.setCapacity("root.c.c1.c13", 40.0f);
        conf.setMaximumCapacity("root.c.c1.c13", 40.0f);
        LOG.info((Object)"Setup 3rd-level queues");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRootQueueParsing() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setCapacity("root", 90.0f);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        capacityScheduler.setConf((Configuration)new YarnConfiguration());
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        capacityScheduler.reinitialize((Configuration)conf, null);
        ServiceOperations.stopQuietly((Service)capacityScheduler);
    }

    public void testMaxCapacity() throws Exception {
        CapacityScheduler capacityScheduler;
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setQueues("root", new String[]{"a", "b", "c"});
        String A = "root.a";
        conf.setCapacity("root.a", 50.0f);
        conf.setMaximumCapacity("root.a", 60.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 50.0f);
        conf.setMaximumCapacity("root.b", 45.0f);
        boolean fail = false;
        try {
            capacityScheduler = new CapacityScheduler();
            capacityScheduler.setConf((Configuration)new YarnConfiguration());
            capacityScheduler.init((Configuration)conf);
            capacityScheduler.start();
            capacityScheduler.reinitialize((Configuration)conf, null);
        }
        catch (IllegalArgumentException iae) {
            fail = true;
        }
        Assert.assertTrue((String)"Didn't throw IllegalArgumentException for wrong maxCap", (boolean)fail);
        conf.setMaximumCapacity("root.b", 60.0f);
        capacityScheduler = new CapacityScheduler();
        capacityScheduler.setConf((Configuration)new YarnConfiguration());
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        capacityScheduler.reinitialize((Configuration)conf, null);
        fail = false;
        try {
            LeafQueue a = (LeafQueue)capacityScheduler.getQueue("root.a");
            a.setMaxCapacity(45.0f);
        }
        catch (IllegalArgumentException iae) {
            fail = true;
        }
        Assert.assertTrue((String)"Didn't throw IllegalArgumentException for wrong setMaxCap", (boolean)fail);
        capacityScheduler.stop();
    }

    private void setupQueueConfigurationWithoutLabels(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        LOG.info((Object)"Setup top-level queues");
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 45.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setMaximumCapacity("root.b.b1", 85.0f);
        conf.setCapacity("root.b.b2", 30.0f);
        conf.setMaximumCapacity("root.b.b2", 35.0f);
        conf.setCapacity("root.b.b3", 20.0f);
        conf.setMaximumCapacity("root.b.b3", 35.0f);
    }

    private void setupQueueConfigurationWithLabels(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacityByLabel("root", "red", 100.0f);
        conf.setCapacityByLabel("root", "blue", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        LOG.info((Object)"Setup top-level queues");
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.a", "red", 50.0f);
        conf.setMaximumCapacityByLabel("root.a", "red", 50.0f);
        conf.setCapacityByLabel("root.a", "blue", 50.0f);
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 45.0f);
        conf.setCapacityByLabel("root.a.a1", "red", 50.0f);
        conf.setCapacityByLabel("root.a.a1", "blue", 100.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        conf.setAccessibleNodeLabels("root.a.a2", (Set)ImmutableSet.of((Object)"red"));
        conf.setCapacityByLabel("root.a.a2", "red", 50.0f);
        conf.setMaximumCapacityByLabel("root.a.a2", "red", 60.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setAccessibleNodeLabels("root.b", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.b", "red", 50.0f);
        conf.setCapacityByLabel("root.b", "blue", 50.0f);
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setMaximumCapacity("root.b.b1", 85.0f);
        conf.setCapacityByLabel("root.b.b1", "red", 50.0f);
        conf.setCapacityByLabel("root.b.b1", "blue", 50.0f);
        conf.setCapacity("root.b.b2", 30.0f);
        conf.setMaximumCapacity("root.b.b2", 35.0f);
        conf.setCapacityByLabel("root.b.b2", "red", 25.0f);
        conf.setCapacityByLabel("root.b.b2", "blue", 25.0f);
        conf.setCapacity("root.b.b3", 20.0f);
        conf.setMaximumCapacity("root.b.b3", 35.0f);
        conf.setCapacityByLabel("root.b.b3", "red", 25.0f);
        conf.setCapacityByLabel("root.b.b3", "blue", 25.0f);
    }

    private void setupQueueConfigurationWithLabelsInherit(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacityByLabel("root", "red", 100.0f);
        conf.setCapacityByLabel("root", "blue", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.a", "red", 100.0f);
        conf.setCapacityByLabel("root.a", "blue", 100.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        conf.setAccessibleNodeLabels("root.b", CommonNodeLabelsManager.EMPTY_STRING_SET);
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 45.0f);
        conf.setCapacityByLabel("root.a.a1", "red", 50.0f);
        conf.setCapacityByLabel("root.a.a1", "blue", 100.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        conf.setAccessibleNodeLabels("root.a.a2", (Set)ImmutableSet.of((Object)"red"));
        conf.setCapacityByLabel("root.a.a2", "red", 50.0f);
    }

    private void setupQueueConfigurationWithSingleLevel(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.a", "red", 90.0f);
        conf.setCapacityByLabel("root.a", "blue", 90.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        conf.setAccessibleNodeLabels("root.b", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.b", "red", 10.0f);
        conf.setCapacityByLabel("root.b", "blue", 10.0f);
    }

    @Test
    public void testQueueParsingReinitializeWithLabels() throws IOException {
        this.nodeLabelManager.addToCluserNodeLabels((Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithoutLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null);
        rmContext.setNodeLabelManager(this.nodeLabelManager);
        capacityScheduler.setConf((Configuration)conf);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabels(csConf);
        conf = new YarnConfiguration((Configuration)csConf);
        capacityScheduler.reinitialize((Configuration)conf, (RMContext)rmContext);
        this.checkQueueLabels(capacityScheduler);
        ServiceOperations.stopQuietly((Service)capacityScheduler);
    }

    private void checkQueueLabels(CapacityScheduler capacityScheduler) {
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a1").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertEquals((long)1L, (long)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().size());
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().contains("red"));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b2").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        CSQueue qA2 = capacityScheduler.getQueue("a2");
        Assert.assertEquals((double)0.7, (double)qA2.getCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.5, (double)qA2.getQueueCapacities().getCapacity("red"), (double)1.0E-6);
        Assert.assertEquals((double)0.07, (double)qA2.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.25, (double)qA2.getQueueCapacities().getAbsoluteCapacity("red"), (double)1.0E-6);
        Assert.assertEquals((double)0.1275, (double)qA2.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.3, (double)qA2.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)1.0E-6);
        CSQueue qB3 = capacityScheduler.getQueue("b3");
        Assert.assertEquals((double)0.18, (double)qB3.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.125, (double)qB3.getQueueCapacities().getAbsoluteCapacity("red"), (double)1.0E-6);
        Assert.assertEquals((double)0.35, (double)qB3.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)qB3.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)1.0E-6);
    }

    private void checkQueueLabelsInheritConfig(CapacityScheduler capacityScheduler) {
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a1").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertEquals((long)1L, (long)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().size());
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().contains("red"));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b").getAccessibleNodeLabels().isEmpty());
    }

    @Test
    public void testQueueParsingWithLabels() throws IOException {
        this.nodeLabelManager.addToCluserNodeLabels((Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf);
        this.setupQueueConfigurationWithLabels(csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null);
        rmContext.setNodeLabelManager(this.nodeLabelManager);
        capacityScheduler.setConf((Configuration)csConf);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)csConf);
        capacityScheduler.start();
        this.checkQueueLabels(capacityScheduler);
        ServiceOperations.stopQuietly((Service)capacityScheduler);
    }

    @Test
    public void testQueueParsingWithLabelsInherit() throws IOException {
        this.nodeLabelManager.addToCluserNodeLabels((Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf);
        this.setupQueueConfigurationWithLabelsInherit(csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null);
        rmContext.setNodeLabelManager(this.nodeLabelManager);
        capacityScheduler.setConf((Configuration)csConf);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)csConf);
        capacityScheduler.start();
        this.checkQueueLabelsInheritConfig(capacityScheduler);
        ServiceOperations.stopQuietly((Service)capacityScheduler);
    }

    @Test(expected=Exception.class)
    public void testQueueParsingWhenLabelsNotExistedInNodeLabelManager() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf);
        this.setupQueueConfigurationWithLabels(csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null);
        NullRMNodeLabelsManager nodeLabelsManager = new NullRMNodeLabelsManager();
        nodeLabelsManager.init((Configuration)conf);
        nodeLabelsManager.start();
        rmContext.setNodeLabelManager((RMNodeLabelsManager)nodeLabelsManager);
        capacityScheduler.setConf((Configuration)csConf);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)csConf);
        capacityScheduler.start();
        ServiceOperations.stopQuietly((Service)capacityScheduler);
        ServiceOperations.stopQuietly((Service)nodeLabelsManager);
    }

    @Test(expected=Exception.class)
    public void testQueueParsingWhenLabelsInheritedNotExistedInNodeLabelManager() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf);
        this.setupQueueConfigurationWithLabelsInherit(csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null);
        NullRMNodeLabelsManager nodeLabelsManager = new NullRMNodeLabelsManager();
        nodeLabelsManager.init((Configuration)conf);
        nodeLabelsManager.start();
        rmContext.setNodeLabelManager((RMNodeLabelsManager)nodeLabelsManager);
        capacityScheduler.setConf((Configuration)csConf);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)csConf);
        capacityScheduler.start();
        ServiceOperations.stopQuietly((Service)capacityScheduler);
        ServiceOperations.stopQuietly((Service)nodeLabelsManager);
    }

    @Test(expected=Exception.class)
    public void testSingleLevelQueueParsingWhenLabelsNotExistedInNodeLabelManager() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf);
        this.setupQueueConfigurationWithSingleLevel(csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null);
        NullRMNodeLabelsManager nodeLabelsManager = new NullRMNodeLabelsManager();
        nodeLabelsManager.init((Configuration)conf);
        nodeLabelsManager.start();
        rmContext.setNodeLabelManager((RMNodeLabelsManager)nodeLabelsManager);
        capacityScheduler.setConf((Configuration)csConf);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)csConf);
        capacityScheduler.start();
        ServiceOperations.stopQuietly((Service)capacityScheduler);
        ServiceOperations.stopQuietly((Service)nodeLabelsManager);
    }

    @Test(expected=Exception.class)
    public void testQueueParsingWhenLabelsNotExist() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf);
        this.setupQueueConfigurationWithLabels(csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null);
        NullRMNodeLabelsManager nodeLabelsManager = new NullRMNodeLabelsManager();
        nodeLabelsManager.init((Configuration)conf);
        nodeLabelsManager.start();
        rmContext.setNodeLabelManager((RMNodeLabelsManager)nodeLabelsManager);
        capacityScheduler.setConf((Configuration)csConf);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)csConf);
        capacityScheduler.start();
        ServiceOperations.stopQuietly((Service)capacityScheduler);
        ServiceOperations.stopQuietly((Service)nodeLabelsManager);
    }

    @Test
    public void testQueueParsingWithUnusedLabels() throws IOException {
        ImmutableSet labels = ImmutableSet.of((Object)"red", (Object)"blue");
        this.nodeLabelManager.addToCluserNodeLabels((Set)labels);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        csConf.setAccessibleNodeLabels("root", (Set)labels);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        capacityScheduler.setConf((Configuration)conf);
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null);
        rmContext.setNodeLabelManager(this.nodeLabelManager);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        capacityScheduler.reinitialize((Configuration)conf, (RMContext)rmContext);
        CSQueue root = capacityScheduler.getQueue("root");
        Assert.assertEquals((double)0.0, (double)root.getQueueCapacities().getCapacity("red"), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)root.getQueueCapacities().getCapacity("blue"), (double)1.0E-6);
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue b1 = capacityScheduler.getQueue("b1");
        Assert.assertEquals((double)0.1, (double)b1.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((String)"Parent B has no MAX_CAP", (double)0.85, (double)b1.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue c12 = capacityScheduler.getQueue("c12");
        Assert.assertEquals((double)0.1575, (double)c12.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.26949999999999996, (double)c12.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        capacityScheduler.stop();
    }

    @Test
    public void testQueueParsingShouldTrimSpaces() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithSpacesShouldBeTrimmed(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        capacityScheduler.setConf((Configuration)conf);
        capacityScheduler.setRMContext(TestUtils.getMockRMContext());
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        capacityScheduler.reinitialize((Configuration)conf, TestUtils.getMockRMContext());
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue c = capacityScheduler.getQueue("c");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteMaximumCapacity(), (double)1.0E-6);
    }

    @Test
    public void testNestedQueueParsingShouldTrimSpaces() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupNestedQueueConfigurationWithSpacesShouldBeTrimmed(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        capacityScheduler.setConf((Configuration)conf);
        capacityScheduler.setRMContext(TestUtils.getMockRMContext());
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        capacityScheduler.reinitialize((Configuration)conf, TestUtils.getMockRMContext());
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue c = capacityScheduler.getQueue("c");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue a1 = capacityScheduler.getQueue("a1");
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((double)0.06, (double)a1.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.15, (double)a1.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue a2 = capacityScheduler.getQueue("a2");
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((double)0.04000000000000001, (double)a2.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.15, (double)a2.getAbsoluteMaximumCapacity(), (double)1.0E-6);
    }

    @Test(expected=IOException.class)
    public void testQueueParsingWithMoveQueue() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf);
        csConf.setQueues("root", new String[]{"a"});
        csConf.setQueues("root.a", new String[]{"x", "y"});
        csConf.setCapacity("root.a", 100.0f);
        csConf.setCapacity("root.a.x", 50.0f);
        csConf.setCapacity("root.a.y", 50.0f);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null);
        rmContext.setNodeLabelManager(this.nodeLabelManager);
        capacityScheduler.setConf((Configuration)csConf);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)csConf);
        capacityScheduler.start();
        csConf.setQueues("root", new String[]{"a", "x"});
        csConf.setQueues("root.a", new String[]{"y"});
        csConf.setCapacity("root.x", 50.0f);
        csConf.setCapacity("root.a", 50.0f);
        csConf.setCapacity("root.a.y", 100.0f);
        capacityScheduler.reinitialize((Configuration)csConf, (RMContext)rmContext);
    }
}

