/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestChildQueueOrder {
    private static final Log LOG = LogFactory.getLog(TestChildQueueOrder.class);
    RMContext rmContext;
    YarnConfiguration conf;
    CapacitySchedulerConfiguration csConf;
    CapacitySchedulerContext csContext;
    static final int GB = 1024;
    static final String DEFAULT_RACK = "/default";
    private final ResourceCalculator resourceComparator = new DefaultResourceCalculator();
    static final float DELTA = 1.0E-4f;
    private static final String A = "a";
    private static final String B = "b";
    private static final String C = "c";
    private static final String D = "d";

    @Before
    public void setUp() throws Exception {
        this.rmContext = TestUtils.getMockRMContext();
        this.conf = new YarnConfiguration();
        this.csConf = new CapacitySchedulerConfiguration();
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)this.csConf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)3200));
        Mockito.when((Object)this.csContext.getApplicationComparator()).thenReturn((Object)CapacityScheduler.applicationComparator);
        Mockito.when((Object)this.csContext.getQueueComparator()).thenReturn((Object)CapacityScheduler.queueComparator);
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)this.resourceComparator);
        Mockito.when((Object)this.csContext.getRMContext()).thenReturn((Object)this.rmContext);
    }

    private FiCaSchedulerApp getMockApplication(int appId, String user) {
        FiCaSchedulerApp application = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ((FiCaSchedulerApp)Mockito.doReturn((Object)user).when((Object)application)).getUser();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)Resources.createResource((int)0, (int)0)).when((Object)application)).getHeadroom();
        return application;
    }

    private void stubQueueAllocation(CSQueue queue, Resource clusterResource, FiCaSchedulerNode node, int allocation) {
        this.stubQueueAllocation(queue, clusterResource, node, allocation, NodeType.NODE_LOCAL);
    }

    private void stubQueueAllocation(final CSQueue queue, final Resource clusterResource, final FiCaSchedulerNode node, final int allocation, final NodeType type) {
        ((CSQueue)Mockito.doAnswer((Answer)new Answer<CSAssignment>(){

            public CSAssignment answer(InvocationOnMock invocation) throws Throwable {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    LOG.info((Object)("FOOBAR q.assignContainers q=" + queue.getQueueName() + " alloc=" + allocation + " node=" + node.getNodeName()));
                    Resource allocatedResource = Resources.createResource((int)allocation);
                    if (queue instanceof ParentQueue) {
                        ((ParentQueue)queue).allocateResource(clusterResource, allocatedResource, null);
                    } else {
                        FiCaSchedulerApp app1 = TestChildQueueOrder.this.getMockApplication(0, "");
                        ((LeafQueue)queue).allocateResource(clusterResource, (SchedulerApplicationAttempt)app1, allocatedResource, null);
                    }
                    if (allocation > 0) {
                        ((CSQueue)Mockito.doReturn((Object)new CSAssignment(Resources.none(), type)).when((Object)queue)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.eq((Object)node), Matchers.anyBoolean(), (ResourceLimits)Matchers.any(ResourceLimits.class));
                        Resource available = node.getAvailableResource();
                        ((FiCaSchedulerNode)Mockito.doReturn((Object)Resources.subtractFrom((Resource)available, (Resource)allocatedResource)).when((Object)node)).getAvailableResource();
                    }
                    return new CSAssignment(allocatedResource, type);
                }
            }
        }).when((Object)queue)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.eq((Object)node), Matchers.anyBoolean(), (ResourceLimits)Matchers.any(ResourceLimits.class));
        ((FiCaSchedulerNode)Mockito.doNothing().when((Object)node)).releaseContainer((Container)Matchers.any(Container.class));
    }

    private float computeQueueAbsoluteUsedCapacity(CSQueue queue, int expectedMemory, Resource clusterResource) {
        return (float)expectedMemory / (float)clusterResource.getMemory();
    }

    private float computeQueueUsedCapacity(CSQueue queue, int expectedMemory, Resource clusterResource) {
        return (float)expectedMemory / ((float)clusterResource.getMemory() * queue.getAbsoluteCapacity());
    }

    private void verifyQueueMetrics(CSQueue queue, int expectedMemory, Resource clusterResource) {
        Assert.assertEquals((float)this.computeQueueAbsoluteUsedCapacity(queue, expectedMemory, clusterResource), (float)queue.getAbsoluteUsedCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)this.computeQueueUsedCapacity(queue, expectedMemory, clusterResource), (float)queue.getUsedCapacity(), (float)1.0E-4f);
    }

    private void setupSortedQueues(CapacitySchedulerConfiguration conf) {
        this.csConf.setQueues("root", new String[]{A, B, C, D});
        String Q_A = "root.a";
        conf.setCapacity("root.a", 25.0f);
        String Q_B = "root.b";
        conf.setCapacity("root.b", 25.0f);
        String Q_C = "root.c";
        conf.setCapacity("root.c", 25.0f);
        String Q_D = "root.d";
        conf.setCapacity("root.d", 25.0f);
    }

    @Test
    public void testSortedQueues() throws Exception {
        int i;
        this.setupSortedQueues(this.csConf);
        HashMap queues = new HashMap();
        CSQueue root = CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 16;
        boolean numNodes = true;
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 10240);
        ((FiCaSchedulerNode)Mockito.doNothing().when((Object)node_0)).releaseContainer((Container)Matchers.any(Container.class));
        Resource clusterResource = Resources.createResource((int)10240, (int)16);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        CSQueue a = (CSQueue)queues.get(A);
        CSQueue b = (CSQueue)queues.get(B);
        CSQueue c = (CSQueue)queues.get(C);
        CSQueue d = (CSQueue)queues.get(D);
        String user_0 = "user_0";
        FiCaSchedulerApp app_0 = this.getMockApplication(0, "user_0");
        ((FiCaSchedulerApp)Mockito.doReturn((Object)true).when((Object)app_0)).containerCompleted((RMContainer)Matchers.any(RMContainer.class), (ContainerStatus)Matchers.any(ContainerStatus.class), (RMContainerEventType)Matchers.any(RMContainerEventType.class));
        Priority priority2 = TestUtils.createMockPriority(1);
        ContainerAllocationExpirer expirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        DrainDispatcher drainDispatcher = new DrainDispatcher();
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getContainerAllocationExpirer()).thenReturn((Object)expirer);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)drainDispatcher);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)app_0.getApplicationId(), (int)1);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        Container container = TestUtils.getMockContainer(containerId, node_0.getNodeID(), Resources.createResource((int)1024), priority2);
        RMContainerImpl rmContainer = new RMContainerImpl(container, appAttemptId, node_0.getNodeID(), "user", rmContext);
        this.stubQueueAllocation(a, clusterResource, node_0, 1024);
        this.stubQueueAllocation(b, clusterResource, node_0, 0);
        this.stubQueueAllocation(c, clusterResource, node_0, 0);
        this.stubQueueAllocation(d, clusterResource, node_0, 0);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        for (i = 0; i < 2; ++i) {
            this.stubQueueAllocation(a, clusterResource, node_0, 0);
            this.stubQueueAllocation(b, clusterResource, node_0, 1024);
            this.stubQueueAllocation(c, clusterResource, node_0, 0);
            this.stubQueueAllocation(d, clusterResource, node_0, 0);
            root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        }
        for (i = 0; i < 3; ++i) {
            this.stubQueueAllocation(a, clusterResource, node_0, 0);
            this.stubQueueAllocation(b, clusterResource, node_0, 0);
            this.stubQueueAllocation(c, clusterResource, node_0, 1024);
            this.stubQueueAllocation(d, clusterResource, node_0, 0);
            root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        }
        for (i = 0; i < 4; ++i) {
            this.stubQueueAllocation(a, clusterResource, node_0, 0);
            this.stubQueueAllocation(b, clusterResource, node_0, 0);
            this.stubQueueAllocation(c, clusterResource, node_0, 0);
            this.stubQueueAllocation(d, clusterResource, node_0, 1024);
            root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        }
        this.verifyQueueMetrics(a, 1024, clusterResource);
        this.verifyQueueMetrics(b, 2048, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        this.verifyQueueMetrics(d, 4096, clusterResource);
        LOG.info((Object)("status child-queues: " + ((ParentQueue)root).getChildQueuesToPrint()));
        for (i = 0; i < 3; ++i) {
            d.completedContainer(clusterResource, app_0, node_0, (RMContainer)rmContainer, null, RMContainerEventType.KILL, null, true);
        }
        this.verifyQueueMetrics(a, 1024, clusterResource);
        this.verifyQueueMetrics(b, 2048, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        this.verifyQueueMetrics(d, 1024, clusterResource);
        node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 3072);
        LOG.info((Object)("status child-queues: " + ((ParentQueue)root).getChildQueuesToPrint()));
        for (i = 0; i < 2; ++i) {
            this.stubQueueAllocation(a, clusterResource, node_0, 1024);
            this.stubQueueAllocation(b, clusterResource, node_0, 0);
            this.stubQueueAllocation(c, clusterResource, node_0, 0);
            this.stubQueueAllocation(d, clusterResource, node_0, 0);
            root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        }
        this.verifyQueueMetrics(a, 3072, clusterResource);
        this.verifyQueueMetrics(b, 2048, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        this.verifyQueueMetrics(d, 1024, clusterResource);
        LOG.info((Object)("status child-queues: " + ((ParentQueue)root).getChildQueuesToPrint()));
        a.completedContainer(clusterResource, app_0, node_0, (RMContainer)rmContainer, null, RMContainerEventType.KILL, null, true);
        this.verifyQueueMetrics(a, 2048, clusterResource);
        this.verifyQueueMetrics(b, 2048, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        this.verifyQueueMetrics(d, 1024, clusterResource);
        node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 2048);
        LOG.info((Object)("status child-queues: " + ((ParentQueue)root).getChildQueuesToPrint()));
        this.stubQueueAllocation(a, clusterResource, node_0, 0);
        this.stubQueueAllocation(b, clusterResource, node_0, 1024);
        this.stubQueueAllocation(c, clusterResource, node_0, 0);
        this.stubQueueAllocation(d, clusterResource, node_0, 0);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        this.verifyQueueMetrics(a, 2048, clusterResource);
        this.verifyQueueMetrics(b, 3072, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        this.verifyQueueMetrics(d, 1024, clusterResource);
        LOG.info((Object)("status child-queues: " + ((ParentQueue)root).getChildQueuesToPrint()));
        b.completedContainer(clusterResource, app_0, node_0, (RMContainer)rmContainer, null, RMContainerEventType.KILL, null, true);
        this.verifyQueueMetrics(a, 2048, clusterResource);
        this.verifyQueueMetrics(b, 2048, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        this.verifyQueueMetrics(d, 1024, clusterResource);
        node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 2048);
        LOG.info((Object)("status child-queues: " + ((ParentQueue)root).getChildQueuesToPrint()));
        this.stubQueueAllocation(a, clusterResource, node_0, 1024);
        this.stubQueueAllocation(b, clusterResource, node_0, 0);
        this.stubQueueAllocation(c, clusterResource, node_0, 0);
        this.stubQueueAllocation(d, clusterResource, node_0, 0);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        this.verifyQueueMetrics(a, 3072, clusterResource);
        this.verifyQueueMetrics(b, 2048, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        this.verifyQueueMetrics(d, 1024, clusterResource);
        LOG.info((Object)("status child-queues: " + ((ParentQueue)root).getChildQueuesToPrint()));
        this.stubQueueAllocation(a, clusterResource, node_0, 0);
        this.stubQueueAllocation(b, clusterResource, node_0, 1024);
        this.stubQueueAllocation(c, clusterResource, node_0, 0);
        this.stubQueueAllocation(d, clusterResource, node_0, 1024);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        InOrder allocationOrder = Mockito.inOrder((Object[])new Object[]{d, b});
        ((CSQueue)allocationOrder.verify((Object)d)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), (ResourceLimits)Matchers.any(ResourceLimits.class));
        ((CSQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), (ResourceLimits)Matchers.any(ResourceLimits.class));
        this.verifyQueueMetrics(a, 3072, clusterResource);
        this.verifyQueueMetrics(b, 2048, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        this.verifyQueueMetrics(d, 2048, clusterResource);
        LOG.info((Object)("status child-queues: " + ((ParentQueue)root).getChildQueuesToPrint()));
    }

    @After
    public void tearDown() throws Exception {
    }
}

