/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestResourceUsage {
    private static final Log LOG = LogFactory.getLog(TestResourceUsage.class);
    private String suffix;

    @Parameterized.Parameters
    public static Collection<String[]> getParameters() {
        return Arrays.asList({"Pending"}, {"Used"}, {"Reserved"}, {"AMUsed"});
    }

    public TestResourceUsage(String suffix) {
        this.suffix = suffix;
    }

    private static void dec(ResourceUsage obj, String suffix, Resource res, String label) throws Exception {
        TestResourceUsage.executeByName(obj, "dec" + suffix, res, label);
    }

    private static void inc(ResourceUsage obj, String suffix, Resource res, String label) throws Exception {
        TestResourceUsage.executeByName(obj, "inc" + suffix, res, label);
    }

    private static void set(ResourceUsage obj, String suffix, Resource res, String label) throws Exception {
        TestResourceUsage.executeByName(obj, "set" + suffix, res, label);
    }

    private static Resource get(ResourceUsage obj, String suffix, String label) throws Exception {
        return TestResourceUsage.executeByName(obj, "get" + suffix, null, label);
    }

    private static Resource executeByName(ResourceUsage obj, String methodName, Resource arg, String label) throws Exception {
        if (methodName.startsWith("get")) {
            Resource result;
            if (label == null) {
                Method method = ResourceUsage.class.getDeclaredMethod(methodName, new Class[0]);
                result = (Resource)method.invoke((Object)obj, new Object[0]);
            } else {
                Method method = ResourceUsage.class.getDeclaredMethod(methodName, String.class);
                result = (Resource)method.invoke((Object)obj, label);
            }
            return result;
        }
        if (label == null) {
            Method method = ResourceUsage.class.getDeclaredMethod(methodName, Resource.class);
            method.invoke((Object)obj, arg);
        } else {
            Method method = ResourceUsage.class.getDeclaredMethod(methodName, String.class, Resource.class);
            method.invoke((Object)obj, label, arg);
        }
        return null;
    }

    private void internalTestModifyAndRead(String label) throws Exception {
        ResourceUsage usage = new ResourceUsage();
        Resource res = TestResourceUsage.get(usage, this.suffix, label);
        this.check(0, 0, res);
        TestResourceUsage.inc(usage, this.suffix, Resource.newInstance((int)1, (int)1), label);
        this.check(1, 1, TestResourceUsage.get(usage, this.suffix, label));
        TestResourceUsage.set(usage, this.suffix, Resource.newInstance((int)2, (int)2), label);
        this.check(2, 2, TestResourceUsage.get(usage, this.suffix, label));
        TestResourceUsage.dec(usage, this.suffix, Resource.newInstance((int)2, (int)2), label);
        this.check(0, 0, TestResourceUsage.get(usage, this.suffix, label));
    }

    void check(int mem, int cpu, Resource res) {
        Assert.assertEquals((long)mem, (long)res.getMemory());
        Assert.assertEquals((long)cpu, (long)res.getVirtualCores());
    }

    @Test
    public void testModifyAndRead() throws Exception {
        LOG.info((Object)("Test - " + this.suffix));
        this.internalTestModifyAndRead(null);
        this.internalTestModifyAndRead("label");
    }
}

