/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAbstractYarnScheduler
extends ParameterizedSchedulerTestBase {
    public TestAbstractYarnScheduler(ParameterizedSchedulerTestBase.SchedulerType type) {
        super(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaximimumAllocationMemory() throws Exception {
        int node1MaxMemory = 15360;
        int node2MaxMemory = 5120;
        int node3MaxMemory = 6144;
        int configuredMaxMemory = 10240;
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 1000000L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationMemoryHelper((AbstractYarnScheduler)rm.getResourceScheduler(), 15360, 5120, 6144, 10240, 10240, 10240, 10240, 10240, 10240);
        }
        finally {
            rm.stop();
        }
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationMemoryHelper((AbstractYarnScheduler)rm.getResourceScheduler(), 15360, 5120, 6144, 10240, 10240, 10240, 5120, 6144, 5120);
        }
        finally {
            rm.stop();
        }
    }

    private void testMaximumAllocationMemoryHelper(AbstractYarnScheduler scheduler, int node1MaxMemory, int node2MaxMemory, int node3MaxMemory, int ... expectedMaxMemory) throws Exception {
        Assert.assertEquals((long)6L, (long)expectedMaxMemory.length);
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        int maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[0], (long)maxMemory);
        RMNode node1 = MockNodes.newNodeInfo(0, Resources.createResource((int)node1MaxMemory), 1, "127.0.0.2");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node1));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[1], (long)maxMemory);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node1));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[2], (long)maxMemory);
        RMNode node2 = MockNodes.newNodeInfo(0, Resources.createResource((int)node2MaxMemory), 2, "127.0.0.3");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node2));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[3], (long)maxMemory);
        RMNode node3 = MockNodes.newNodeInfo(0, Resources.createResource((int)node3MaxMemory), 3, "127.0.0.4");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node3));
        Assert.assertEquals((long)2L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[4], (long)maxMemory);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node3));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[5], (long)maxMemory);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node2));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaximimumAllocationVCores() throws Exception {
        int node1MaxVCores = 15;
        int node2MaxVCores = 5;
        int node3MaxVCores = 6;
        int configuredMaxVCores = 10;
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 10);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 1000000L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationVCoresHelper((AbstractYarnScheduler)rm.getResourceScheduler(), 15, 5, 6, 10, 10, 10, 10, 10, 10);
        }
        finally {
            rm.stop();
        }
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationVCoresHelper((AbstractYarnScheduler)rm.getResourceScheduler(), 15, 5, 6, 10, 10, 10, 5, 6, 5);
        }
        finally {
            rm.stop();
        }
    }

    private void testMaximumAllocationVCoresHelper(AbstractYarnScheduler scheduler, int node1MaxVCores, int node2MaxVCores, int node3MaxVCores, int ... expectedMaxVCores) throws Exception {
        Assert.assertEquals((long)6L, (long)expectedMaxVCores.length);
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        int maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[0], (long)maxVCores);
        RMNode node1 = MockNodes.newNodeInfo(0, Resources.createResource((int)1024, (int)node1MaxVCores), 1, "127.0.0.2");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node1));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[1], (long)maxVCores);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node1));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[2], (long)maxVCores);
        RMNode node2 = MockNodes.newNodeInfo(0, Resources.createResource((int)1024, (int)node2MaxVCores), 2, "127.0.0.3");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node2));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[3], (long)maxVCores);
        RMNode node3 = MockNodes.newNodeInfo(0, Resources.createResource((int)1024, (int)node3MaxVCores), 3, "127.0.0.4");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node3));
        Assert.assertEquals((long)2L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[4], (long)maxVCores);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node3));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[5], (long)maxVCores);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node2));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateMaxAllocationUsesTotal() throws IOException {
        int configuredMaxVCores = 20;
        int configuredMaxMemory = 10240;
        Resource configuredMaximumResource = Resource.newInstance((int)10240, (int)20);
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 20);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
            Resource emptyResource = Resource.newInstance((int)0, (int)0);
            Resource fullResource1 = Resource.newInstance((int)1024, (int)5);
            Resource fullResource2 = Resource.newInstance((int)2048, (int)10);
            SchedulerNode mockNode1 = (SchedulerNode)Mockito.mock(SchedulerNode.class);
            Mockito.when((Object)mockNode1.getNodeID()).thenReturn((Object)NodeId.newInstance((String)"foo", (int)8080));
            Mockito.when((Object)mockNode1.getAvailableResource()).thenReturn((Object)emptyResource);
            Mockito.when((Object)mockNode1.getTotalResource()).thenReturn((Object)fullResource1);
            SchedulerNode mockNode2 = (SchedulerNode)Mockito.mock(SchedulerNode.class);
            Mockito.when((Object)mockNode1.getNodeID()).thenReturn((Object)NodeId.newInstance((String)"bar", (int)8081));
            Mockito.when((Object)mockNode2.getAvailableResource()).thenReturn((Object)emptyResource);
            Mockito.when((Object)mockNode2.getTotalResource()).thenReturn((Object)fullResource2);
            this.verifyMaximumResourceCapability(configuredMaximumResource, scheduler);
            scheduler.nodes = new HashMap();
            scheduler.nodes.put(mockNode1.getNodeID(), mockNode1);
            scheduler.updateMaximumAllocation(mockNode1, true);
            this.verifyMaximumResourceCapability(fullResource1, scheduler);
            scheduler.nodes.put(mockNode2.getNodeID(), mockNode2);
            scheduler.updateMaximumAllocation(mockNode2, true);
            this.verifyMaximumResourceCapability(fullResource2, scheduler);
            scheduler.nodes.remove(mockNode2.getNodeID());
            scheduler.updateMaximumAllocation(mockNode2, false);
            this.verifyMaximumResourceCapability(fullResource1, scheduler);
            scheduler.nodes.remove(mockNode1.getNodeID());
            scheduler.updateMaximumAllocation(mockNode1, false);
            this.verifyMaximumResourceCapability(configuredMaximumResource, scheduler);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxAllocationAfterUpdateNodeResource() throws IOException {
        int configuredMaxVCores = 20;
        int configuredMaxMemory = 10240;
        Resource configuredMaximumResource = Resource.newInstance((int)10240, (int)20);
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 20);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
            this.verifyMaximumResourceCapability(configuredMaximumResource, scheduler);
            Resource resource1 = Resource.newInstance((int)2048, (int)5);
            Resource resource2 = Resource.newInstance((int)4096, (int)10);
            Resource resource3 = Resource.newInstance((int)512, (int)1);
            Resource resource4 = Resource.newInstance((int)1024, (int)2);
            RMNode node1 = MockNodes.newNodeInfo(0, resource1, 1, "127.0.0.2");
            scheduler.handle((Event)new NodeAddedSchedulerEvent(node1));
            RMNode node2 = MockNodes.newNodeInfo(0, resource3, 2, "127.0.0.3");
            scheduler.handle((Event)new NodeAddedSchedulerEvent(node2));
            this.verifyMaximumResourceCapability(resource1, scheduler);
            scheduler.updateNodeResource(node1, ResourceOption.newInstance((Resource)resource2, (int)0));
            this.verifyMaximumResourceCapability(resource2, scheduler);
            scheduler.updateNodeResource(node1, ResourceOption.newInstance((Resource)resource1, (int)0));
            this.verifyMaximumResourceCapability(resource1, scheduler);
            scheduler.updateNodeResource(node2, ResourceOption.newInstance((Resource)resource4, (int)0));
            this.verifyMaximumResourceCapability(resource1, scheduler);
            scheduler.updateNodeResource(node2, ResourceOption.newInstance((Resource)resource3, (int)0));
            this.verifyMaximumResourceCapability(resource1, scheduler);
        }
        finally {
            rm.stop();
        }
    }

    private void verifyMaximumResourceCapability(Resource expectedMaximumResource, AbstractYarnScheduler scheduler) {
        Resource schedulerMaximumResourceCapability = scheduler.getMaximumResourceCapability();
        Assert.assertEquals((long)expectedMaximumResource.getMemory(), (long)schedulerMaximumResourceCapability.getMemory());
        Assert.assertEquals((long)expectedMaximumResource.getVirtualCores(), (long)schedulerMaximumResourceCapability.getVirtualCores());
    }
}

