/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestZKRMStateStore
extends RMStateStoreTestBase {
    public static final Log LOG = LogFactory.getLog(TestZKRMStateStore.class);
    private static final int ZK_TIMEOUT_MS = 1000;

    @Test(timeout=60000L)
    public void testZKRMStateStoreRealZK() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        this.testRMAppStateStore(zkTester);
        this.testRMDTSecretManagerStateStore(zkTester);
        this.testCheckVersion(zkTester);
        this.testEpoch(zkTester);
        this.testAppDeletion(zkTester);
        this.testDeleteStore(zkTester);
        this.testAMRMTokenSecretManagerStateStore(zkTester);
    }

    @Test(timeout=60000L)
    public void testCheckMajorVersionChange() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester(){
            Version VERSION_INFO = Version.newInstance((int)Integer.MAX_VALUE, (int)0);

            @Override
            public Version getCurrentVersion() throws Exception {
                return this.VERSION_INFO;
            }

            @Override
            public RMStateStore getRMStateStore() throws Exception {
                YarnConfiguration conf = new YarnConfiguration();
                this.workingZnode = "/jira/issue/3077/rmstore";
                conf.set("yarn.resourcemanager.zk-address", TestZKRMStateStore.this.hostPort);
                conf.set("yarn.resourcemanager.zk-state-store.parent-path", this.workingZnode);
                this.client = TestZKRMStateStore.this.createClient();
                this.store = new TestZKRMStateStoreTester.TestZKRMStateStoreInternal((Configuration)conf, this.workingZnode){
                    Version storedVersion;
                    {
                        this.storedVersion = null;
                    }

                    @Override
                    public Version getCurrentVersion() {
                        return VERSION_INFO;
                    }

                    protected synchronized Version loadVersion() throws Exception {
                        return this.storedVersion;
                    }

                    protected synchronized void storeVersion() throws Exception {
                        this.storedVersion = VERSION_INFO;
                    }
                };
                return this.store;
            }
        };
        RMStateStore store = zkTester.getRMStateStore();
        Version defaultVersion = zkTester.getCurrentVersion();
        store.checkVersion();
        Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
    }

    private Configuration createHARMConf(String rmIds, String rmId, int adminPort) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", rmIds);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", ZKRMStateStore.class.getName());
        conf.set("yarn.resourcemanager.zk-address", this.hostPort);
        conf.setInt("yarn.resourcemanager.zk-timeout-ms", 1000);
        conf.set("yarn.resourcemanager.ha.id", rmId);
        conf.set("yarn.resourcemanager.webapp.address", "localhost:0");
        for (String rpcAddress : YarnConfiguration.getServiceAddressConfKeys((Configuration)conf)) {
            for (String id : HAUtil.getRMHAIds((Configuration)conf)) {
                conf.set(HAUtil.addSuffix((String)rpcAddress, (String)id), "localhost:0");
            }
        }
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.admin.address", (String)rmId), "localhost:" + adminPort);
        return conf;
    }

    @Test
    public void testFencing() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Configuration conf1 = this.createHARMConf("rm1,rm2", "rm1", 1234);
        conf1.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        ResourceManager rm1 = new ResourceManager();
        rm1.init(conf1);
        rm1.start();
        rm1.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm1.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Configuration conf2 = this.createHARMConf("rm1,rm2", "rm2", 5678);
        conf2.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        ResourceManager rm2 = new ResourceManager();
        rm2.init(conf2);
        rm2.start();
        rm2.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm2.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        for (int i = 0; i < 20; ++i) {
            if (HAServiceProtocol.HAServiceState.ACTIVE != rm1.getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"RM should have been fenced", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
    }

    @Test
    public void testFencedState() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        RMStateStore store = zkTester.getRMStateStore();
        store.updateFencedState();
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        long submitTime = System.currentTimeMillis();
        long startTime = submitTime + 1000L;
        RMApp mockApp = (RMApp)Mockito.mock(RMApp.class);
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        Mockito.when((Object)mockApp.getSubmitTime()).thenReturn((Object)submitTime);
        Mockito.when((Object)mockApp.getStartTime()).thenReturn((Object)startTime);
        Mockito.when((Object)mockApp.getApplicationSubmissionContext()).thenReturn((Object)context);
        Mockito.when((Object)mockApp.getUser()).thenReturn((Object)"test");
        store.storeNewApplication(mockApp);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        ClientToAMTokenSecretManagerInRM clientToAMTokenMgr = new ClientToAMTokenSecretManagerInRM();
        ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)"appattempt_1234567894321_0001_000001");
        SecretKey clientTokenMasterKey = clientToAMTokenMgr.createMasterKey(attemptId);
        RMAppAttemptMetrics mockRmAppAttemptMetrics = (RMAppAttemptMetrics)Mockito.mock(RMAppAttemptMetrics.class);
        ContainerPBImpl container = new ContainerPBImpl();
        container.setId(ConverterUtils.toContainerId((String)"container_1234567891234_0001_01_000001"));
        RMAppAttempt mockAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)mockAttempt.getAppAttemptId()).thenReturn((Object)attemptId);
        Mockito.when((Object)mockAttempt.getMasterContainer()).thenReturn((Object)container);
        Mockito.when((Object)mockAttempt.getClientTokenMasterKey()).thenReturn((Object)clientTokenMasterKey);
        Mockito.when((Object)mockAttempt.getRMAppAttemptMetrics()).thenReturn((Object)mockRmAppAttemptMetrics);
        Mockito.when((Object)mockRmAppAttemptMetrics.getAggregateAppResourceUsage()).thenReturn((Object)new AggregateAppResourceUsage(0L, 0L));
        store.storeNewApplicationAttempt(mockAttempt);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        long finishTime = submitTime + 1000L;
        ApplicationAttemptStateData newAttemptState = ApplicationAttemptStateData.newInstance((ApplicationAttemptId)attemptId, (Container)container, (Credentials)store.getCredentialsFromAppAttempt(mockAttempt), (long)startTime, (RMAppAttemptState)RMAppAttemptState.FINISHED, (String)"testUrl", (String)"test", (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (int)100, (long)finishTime, (long)0L, (long)0L);
        store.updateApplicationAttemptState(newAttemptState);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        ApplicationStateData appState = ApplicationStateData.newInstance((long)submitTime, (long)startTime, (ApplicationSubmissionContext)context, (String)"test");
        store.updateApplicationState(appState);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.removeApplication(mockApp);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner1"), new Text("renewer1"), new Text("realuser1"));
        Long renewDate1 = new Long(System.currentTimeMillis());
        dtId1.setSequenceNumber(1111);
        store.storeRMDelegationToken(dtId1, renewDate1);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.updateRMDelegationToken(dtId1, renewDate1);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.removeRMDelegationToken(dtId1);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        DelegationKey key = new DelegationKey(1234, 4321L, "keyBytes".getBytes());
        store.storeRMDTMasterKey(key);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.removeRMDTMasterKey(key);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.storeOrUpdateAMRMTokenSecretManager(null, false);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.close();
    }

    @Test
    public void testDuplicateRMAppDeletion() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        long submitTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis() + 1234L;
        RMStateStore store = zkTester.getRMStateStore();
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        ApplicationAttemptId attemptIdRemoved = ConverterUtils.toApplicationAttemptId((String)"appattempt_1352994193343_0002_000001");
        ApplicationId appIdRemoved = attemptIdRemoved.getApplicationId();
        this.storeApp(store, appIdRemoved, submitTime, startTime);
        this.storeAttempt(store, attemptIdRemoved, "container_1352994193343_0002_01_000001", null, null, dispatcher);
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appIdRemoved);
        ApplicationStateData appStateRemoved = ApplicationStateData.newInstance((long)submitTime, (long)startTime, (ApplicationSubmissionContext)context, (String)"user1");
        appStateRemoved.attempts.put(attemptIdRemoved, null);
        store.removeApplicationStateInternal(appStateRemoved);
        try {
            store.removeApplicationStateInternal(appStateRemoved);
        }
        catch (KeeperException.NoNodeException nne) {
            Assert.fail((String)"NoNodeException should not happen.");
        }
        store.close();
    }

    class TestZKRMStateStoreTester
    implements RMStateStoreTestBase.RMStateStoreHelper {
        ZooKeeper client;
        TestZKRMStateStoreInternal store;
        String workingZnode;

        TestZKRMStateStoreTester() {
        }

        @Override
        public RMStateStore getRMStateStore() throws Exception {
            YarnConfiguration conf = new YarnConfiguration();
            this.workingZnode = "/jira/issue/3077/rmstore";
            conf.set("yarn.resourcemanager.zk-address", TestZKRMStateStore.this.hostPort);
            conf.set("yarn.resourcemanager.zk-state-store.parent-path", this.workingZnode);
            this.client = TestZKRMStateStore.this.createClient();
            this.store = new TestZKRMStateStoreInternal((Configuration)conf, this.workingZnode);
            return this.store;
        }

        @Override
        public boolean isFinalStateValid() throws Exception {
            List nodes = this.client.getChildren(this.store.znodeWorkingPath, false);
            return nodes.size() == 1;
        }

        @Override
        public void writeVersion(Version version) throws Exception {
            this.client.setData(this.store.getVersionNode(), ((VersionPBImpl)version).getProto().toByteArray(), -1);
        }

        @Override
        public Version getCurrentVersion() throws Exception {
            return this.store.getCurrentVersion();
        }

        @Override
        public boolean appExists(RMApp app) throws Exception {
            Stat node = this.client.exists(this.store.getAppNode(app.getApplicationId().toString()), false);
            return node != null;
        }

        class TestZKRMStateStoreInternal
        extends ZKRMStateStore {
            public TestZKRMStateStoreInternal(Configuration conf, String workingZnode) throws Exception {
                this.init(conf);
                this.start();
                Assert.assertTrue((boolean)this.znodeWorkingPath.equals(workingZnode));
            }

            public ZooKeeper getNewZooKeeper() throws IOException {
                return TestZKRMStateStoreTester.this.client;
            }

            public String getVersionNode() {
                return this.znodeWorkingPath + "/" + "ZKRMStateRoot" + "/" + "RMVersionNode";
            }

            public Version getCurrentVersion() {
                return CURRENT_VERSION_INFO;
            }

            public String getAppNode(String appId) {
                return TestZKRMStateStoreTester.this.workingZnode + "/" + "ZKRMStateRoot" + "/" + "RMAppRoot" + "/" + appId;
            }
        }
    }
}

