/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.labelmanager;

import java.io.IOException;
import java.util.Set;
import net.java.dev.eval.Expression;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManagementService;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLabelManager {
    static Configuration conf;
    static FileSystem fs;
    static LabelManagementService lbS;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = new Configuration();
        conf.set("node.labels.file", "/tmp/labelFile");
        conf.setLong("node.labels.monitor.interval", 5000L);
        conf.set("fs.file.impl", "org.apache.hadoop.fs.LocalFileSystem");
        conf.set("fs.default.name", "file:///");
        fs = FileSystem.getLocal((Configuration)conf);
        FSDataOutputStream fsout = fs.create(new Path("/tmp/labelFile"));
        fsout.writeBytes("/perfnode200.*/ big, \"Production Machines\"");
        fsout.writeBytes("\n");
        fsout.writeBytes("/perfnode203.*/ big, 'Development Machines'");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode15* good");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode201* slow");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode204* good, big");
        fsout.writeBytes("\n");
        fsout.writeBytes("/node-.+lab/     Fast");
        fsout.writeBytes("\n");
        fsout.writeBytes("node-2*      Slow");
        fsout.writeBytes("\n");
        fsout.close();
        lbS = new LabelManagementService();
        lbS.init(conf);
        lbS.start();
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        lbS.stop();
        Assert.assertFalse((lbS.getServiceState() != Service.STATE.STOPPED ? 1 : 0) != 0);
        fs.delete(new Path("/tmp/labelFile"), false);
    }

    @Before
    public void setUp() throws Exception {
        FSDataOutputStream fsout = fs.create(new Path("/tmp/labelFile"));
        fsout.writeBytes("/perfnode200.*/ big, \"Production Machines\"");
        fsout.writeBytes("\n");
        fsout.writeBytes("/perfnode203.*/ big, 'Development Machines'");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode15* good");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode1* right, good, fantastic");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode201* slow");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode204* good, big");
        fsout.writeBytes("\n");
        fsout.writeBytes("/node-.+lab/     Fast");
        fsout.writeBytes("\n");
        fsout.writeBytes("node-2*      Slow");
        fsout.writeBytes("\n");
        fsout.close();
        Thread.sleep(6000L);
    }

    @After
    public void tearDown() throws Exception {
        fs.delete(new Path("/tmp/labelFile"), false);
    }

    @Test(timeout=10000L)
    public void testLabelManager() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)"/tmp/labelFile".equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Set labels = lb.getLabelsForNode("perfnode151.perf.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)3L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        Assert.assertTrue((boolean)labels.contains("right"));
        Assert.assertTrue((boolean)labels.contains("fantastic"));
        labels = lb.getLabelsForNode("perfnode200.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Production Machines"));
        labels = lb.getLabelsForNode("perfnode203.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Development Machines"));
        labels = lb.getLabelsForNode("node-33.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)1L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("node-28.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Slow"));
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("node-28.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Slow"));
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("perfnode01.lab");
        Assert.assertNull((Object)labels);
        labels = lb.getLabelsForNode("perfnode01.lab");
        Assert.assertNull((Object)labels);
        labels = lb.getLabelsForNode("perfnode10.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)3L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        Assert.assertTrue((boolean)labels.contains("right"));
        Assert.assertTrue((boolean)labels.contains("fantastic"));
        labels = lb.getLabelsForNode("perfnode10.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)3L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        Assert.assertTrue((boolean)labels.contains("right"));
        Assert.assertTrue((boolean)labels.contains("fantastic"));
    }

    @Test
    public void testlabelExpressioncreation() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)"/tmp/labelFile".equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Expression expr = lb.getEffectiveLabelExpr("good && big");
        Assert.assertEquals((Object)"(good&&big)", (Object)expr.toString());
    }

    @Test
    public void testAllLabelQueuePolicyExpression() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)"/tmp/labelFile".equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Queue.QueueLabelPolicy policy = Queue.QueueLabelPolicy.AND;
        Expression queueLabelExpression = lb.getEffectiveLabelExpr("good && big");
        Expression appLabelExpression = lb.getEffectiveLabelExpr("good");
        Expression finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"((good&&big)&&good)", (Object)finalExpr.toString());
        policy = Queue.QueueLabelPolicy.OR;
        finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"((good&&big)||good)", (Object)finalExpr.toString());
        policy = Queue.QueueLabelPolicy.PREFER_APP;
        finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"(good)", (Object)finalExpr.toString());
        policy = Queue.QueueLabelPolicy.PREFER_QUEUE;
        finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"(good&&big)", (Object)finalExpr.toString());
    }

    @Test
    public void testLabelExpressionEvauation() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)"/tmp/labelFile".equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Queue.QueueLabelPolicy policy = Queue.QueueLabelPolicy.AND;
        Expression queueLabelExpression = lb.getEffectiveLabelExpr("good && big");
        Expression appLabelExpression = lb.getEffectiveLabelExpr("good");
        Expression finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"((good&&big)&&good)", (Object)finalExpr.toString());
        LabelManager.LabelApplicabilityStatus result = lb.isNodeApplicableForApp("perfnode204.qa.lab", finalExpr);
        Assert.assertTrue((result == LabelManager.LabelApplicabilityStatus.NODE_HAS_LABEL ? 1 : 0) != 0);
        result = lb.isNodeApplicableForApp("perfnode203.qa.lab", finalExpr);
        Assert.assertTrue((result == LabelManager.LabelApplicabilityStatus.NODE_DOES_NOT_HAVE_LABEL ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testLabelRefresh() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)"/tmp/labelFile".equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Set labels = lb.getLabelsForNode("perfnode151.perf.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)3L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        Assert.assertTrue((boolean)labels.contains("right"));
        Assert.assertTrue((boolean)labels.contains("fantastic"));
        labels = lb.getLabelsForNode("perfnode200.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Production Machines"));
        labels = lb.getLabelsForNode("perfnode203.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Development Machines"));
        labels = lb.getLabelsForNode("node-33.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)1L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("node-28.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Slow"));
        Assert.assertTrue((boolean)labels.contains("Fast"));
        fs.delete(new Path("/tmp/labelFile"), false);
        FSDataOutputStream fsout = fs.create(new Path("/tmp/labelFile"));
        fsout.writeBytes("/perfnode200.*/ big, \"Prod Machines\"");
        fsout.writeBytes("\n");
        fsout.writeBytes("/perfnode203.*/ small, 'Dev Machines'");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode15* good");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode201* slow");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode204* good, big");
        fsout.writeBytes("\n");
        fsout.writeBytes("/node-.+lab/     Fast");
        fsout.writeBytes("\n");
        fsout.writeBytes("node-2*      Slow");
        fsout.writeBytes("\n");
        fsout.close();
        Thread.sleep(6000L);
        labels = lb.getLabelsForNode("perfnode200.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Prod Machines"));
        labels = lb.getLabelsForNode("perfnode203.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("small"));
        Assert.assertTrue((boolean)labels.contains("Dev Machines"));
        labels = lb.getLabelsForNode("perfnode151.perf.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)1L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        labels = lb.getLabelsForNode("node-33.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)1L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("node-28.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Slow"));
        Assert.assertTrue((boolean)labels.contains("Fast"));
    }

    @Test
    public void testBadLabels() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Queue.QueueLabelPolicy policy = Queue.QueueLabelPolicy.AND;
        Expression queueLabelExpression = lb.getEffectiveLabelExpr("good && big");
        Expression appLabelExpression = lb.getEffectiveLabelExpr("badlabel");
        Expression finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"((good&&big)&&badlabel)", (Object)finalExpr.toString());
        try {
            lb.isNodeApplicableForApp("perfnode204.qa.lab", finalExpr);
            Assert.fail((String)("Evaluation should fail for: " + finalExpr.toString()));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void testPerformance() throws Exception {
        String resourceName;
        int i;
        fs.delete(new Path("/tmp/labelFile"), false);
        FSDataOutputStream fsout = fs.create(new Path("/tmp/labelFile"));
        for (int i2 = 0; i2 < 1000; ++i2) {
            String node = "node-2." + i2 + ".lab";
            if (i2 % 3 == 0) {
                fsout.writeBytes(node + "      Slow");
            } else if (i2 % 5 == 0) {
                fsout.writeBytes(node + "      good");
            } else if (i2 % 7 == 0) {
                fsout.writeBytes(node + "      Fast");
            } else {
                fsout.writeBytes(node + "      Slow, good, small");
            }
            fsout.writeBytes("\n");
        }
        fsout.close();
        Thread.sleep(6000L);
        LabelManager lb = LabelManager.getInstance();
        Expression finalExp = lb.constructAppLabel(Queue.QueueLabelPolicy.OR, new Expression("Slow || Fast"), new Expression("Slow"));
        Expression appExp = new Expression("Slow || Fast");
        Expression qExp = new Expression("Slow");
        long startTime = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            String resourceName2 = "node-2." + i % 1000 + ".lab";
            lb.isNodeApplicableForApp(resourceName2, finalExp);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time taken: " + (endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            resourceName = "node-2." + i % 1000 + ".lab";
            lb.isNodeApplicableForApp(resourceName, finalExp);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Time taken2: " + (endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        for (i = 0; i < 3000000; ++i) {
            resourceName = "/defaultrack";
            lb.isNodeApplicableForApp(resourceName, finalExp);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Time taken3: " + (endTime - startTime) + " ms");
    }
}

