/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmcontainer;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRunningOnNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerAllocatedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class RMContainerImpl
implements RMContainer {
    private static final Log LOG = LogFactory.getLog(RMContainerImpl.class);
    private static final StateMachineFactory<RMContainerImpl, RMContainerState, RMContainerEventType, RMContainerEvent> stateMachineFactory = new StateMachineFactory((Enum)RMContainerState.NEW).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition()).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition()).addTransition((Enum)RMContainerState.NEW, EnumSet.of(RMContainerState.RUNNING, RMContainerState.COMPLETED), (Enum)RMContainerEventType.RECOVER, (MultipleArcTransition)new ContainerRecoveredTransition()).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition()).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition()).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.ACQUIRED, (Enum)RMContainerEventType.ACQUIRED, (SingleArcTransition)new AcquiredTransition()).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.LAUNCHED, (SingleArcTransition)new LaunchedTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new ContainerFinishedAtAcquiredState()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.EXPIRE).addTransition((Enum)RMContainerState.COMPLETED, (Enum)RMContainerState.COMPLETED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.EXPIRED, (Enum)RMContainerState.EXPIRED, EnumSet.of(RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.RELEASED, (Enum)RMContainerState.RELEASED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).addTransition((Enum)RMContainerState.KILLED, (Enum)RMContainerState.KILLED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).installTopology();
    private final StateMachine<RMContainerState, RMContainerEventType, RMContainerEvent> stateMachine = stateMachineFactory.make((Object)this);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ContainerId containerId;
    private final ApplicationAttemptId appAttemptId;
    private final NodeId nodeId;
    private final Container container;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final ContainerAllocationExpirer containerAllocationExpirer;
    private final String user;
    private Resource reservedResource;
    private NodeId reservedNode;
    private Priority reservedPriority;
    private long creationTime;
    private long finishTime;
    private ContainerStatus finishedStatus;
    private boolean isAMContainer;
    private List<ResourceRequest> resourceRequests;

    public RMContainerImpl(Container container, ApplicationAttemptId appAttemptId, NodeId nodeId, String user, RMContext rmContext) {
        this(container, appAttemptId, nodeId, user, rmContext, System.currentTimeMillis());
    }

    public RMContainerImpl(Container container, ApplicationAttemptId appAttemptId, NodeId nodeId, String user, RMContext rmContext, long creationTime) {
        this.containerId = container.getId();
        this.nodeId = nodeId;
        this.container = container;
        this.appAttemptId = appAttemptId;
        this.user = user;
        this.creationTime = creationTime;
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.containerAllocationExpirer = rmContext.getContainerAllocationExpirer();
        this.isAMContainer = false;
        this.resourceRequests = null;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        rmContext.getRMApplicationHistoryWriter().containerStarted(this);
        rmContext.getSystemMetricsPublisher().containerCreated(this, this.creationTime);
    }

    @Override
    public ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMContainerState getState() {
        this.readLock.lock();
        try {
            RMContainerState rMContainerState = (RMContainerState)this.stateMachine.getCurrentState();
            return rMContainerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Resource getReservedResource() {
        return this.reservedResource;
    }

    @Override
    public NodeId getReservedNode() {
        return this.reservedNode;
    }

    @Override
    public Priority getReservedPriority() {
        return this.reservedPriority;
    }

    @Override
    public Resource getAllocatedResource() {
        return this.container.getResource();
    }

    @Override
    public NodeId getAllocatedNode() {
        return this.container.getNodeId();
    }

    @Override
    public Priority getAllocatedPriority() {
        return this.container.getPriority();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFinishTime() {
        try {
            this.readLock.lock();
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiagnosticsInfo() {
        try {
            this.readLock.lock();
            if (this.getFinishedStatus() != null) {
                String string = this.getFinishedStatus().getDiagnostics();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLogURL() {
        try {
            this.readLock.lock();
            StringBuilder logURL = new StringBuilder();
            logURL.append(WebAppUtils.getHttpSchemePrefix((Configuration)this.rmContext.getYarnConfiguration()));
            logURL.append(WebAppUtils.getRunningLogURL((String)this.container.getNodeHttpAddress(), (String)ConverterUtils.toString((ContainerId)this.containerId), (String)this.user));
            String string = logURL.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getContainerExitStatus() {
        try {
            this.readLock.lock();
            if (this.getFinishedStatus() != null) {
                int n = this.getFinishedStatus().getExitStatus();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerState getContainerState() {
        try {
            this.readLock.lock();
            if (this.getFinishedStatus() != null) {
                ContainerState containerState = this.getFinishedStatus().getState();
                return containerState;
            }
            ContainerState containerState = ContainerState.RUNNING;
            return containerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResourceRequest> getResourceRequests() {
        try {
            this.readLock.lock();
            List<ResourceRequest> list = this.resourceRequests;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceRequests(List<ResourceRequest> requests) {
        try {
            this.writeLock.lock();
            this.resourceRequests = requests;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.containerId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAMContainer() {
        try {
            this.readLock.lock();
            boolean bl = this.isAMContainer;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAMContainer(boolean isAMContainer) {
        try {
            this.writeLock.lock();
            this.isAMContainer = isAMContainer;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMContainerEvent event) {
        LOG.debug((Object)("Processing " + event.getContainerId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            RMContainerState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on container " + this.containerId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(event.getContainerId() + " Container Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ContainerStatus getFinishedStatus() {
        return this.finishedStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerReport createContainerReport() {
        this.readLock.lock();
        ContainerReport containerReport = null;
        try {
            containerReport = ContainerReport.newInstance((ContainerId)this.getContainerId(), (Resource)this.getAllocatedResource(), (NodeId)this.getAllocatedNode(), (Priority)this.getAllocatedPriority(), (long)this.getCreationTime(), (long)this.getFinishTime(), (String)this.getDiagnosticsInfo(), (String)this.getLogURL(), (int)this.getContainerExitStatus(), (ContainerState)this.getContainerState(), (String)this.getNodeHttpAddress());
        }
        finally {
            this.readLock.unlock();
        }
        return containerReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeHttpAddress() {
        try {
            this.readLock.lock();
            if (this.container.getNodeHttpAddress() != null) {
                StringBuilder httpAddress = new StringBuilder();
                httpAddress.append(WebAppUtils.getHttpSchemePrefix((Configuration)this.rmContext.getYarnConfiguration()));
                httpAddress.append(this.container.getNodeHttpAddress());
                String string = httpAddress.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static final class KillTransition
    extends FinishedTransition {
        private KillTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(container.getContainerId());
            container.eventHandler.handle((Event)new RMNodeCleanContainerEvent(container.nodeId, container.containerId));
            super.transition(container, event);
        }
    }

    private static final class ContainerFinishedAtAcquiredState
    extends FinishedTransition {
        private ContainerFinishedAtAcquiredState() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(container.getContainerId());
            super.transition(container, event);
        }
    }

    private static class FinishedTransition
    extends BaseTransition {
        private FinishedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            RMContainerFinishedEvent finishedEvent = (RMContainerFinishedEvent)event;
            container.finishTime = System.currentTimeMillis();
            container.finishedStatus = finishedEvent.getRemoteContainerStatus();
            FinishedTransition.updateAttemptMetrics(container);
            container.eventHandler.handle((Event)new RMAppAttemptContainerFinishedEvent(container.appAttemptId, finishedEvent.getRemoteContainerStatus(), container.getAllocatedNode()));
            container.rmContext.getRMApplicationHistoryWriter().containerFinished(container);
            container.rmContext.getSystemMetricsPublisher().containerFinished(container, container.finishTime);
        }

        private static void updateAttemptMetrics(RMContainerImpl container) {
            Resource resource = container.getContainer().getResource();
            RMAppAttempt rmAttempt = ((RMApp)container.rmContext.getRMApps().get(container.getApplicationAttemptId().getApplicationId())).getCurrentAppAttempt();
            if (-102 == container.finishedStatus.getExitStatus()) {
                rmAttempt.getRMAppAttemptMetrics().updatePreemptionInfo(resource, container);
            }
            if (rmAttempt != null) {
                long usedMillis = container.finishTime - container.creationTime;
                long memorySeconds = (long)resource.getMemory() * usedMillis / 1000L;
                long vcoreSeconds = (long)resource.getVirtualCores() * usedMillis / 1000L;
                rmAttempt.getRMAppAttemptMetrics().updateAggregateAppResourceUsage(memorySeconds, vcoreSeconds);
            }
        }
    }

    private static final class LaunchedTransition
    extends BaseTransition {
        private LaunchedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(container.getContainerId());
        }
    }

    private static final class AcquiredTransition
    extends BaseTransition {
        private AcquiredTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.setResourceRequests(null);
            container.containerAllocationExpirer.register(container.getContainerId());
            container.eventHandler.handle((Event)new RMAppRunningOnNodeEvent(container.getApplicationAttemptId().getApplicationId(), container.nodeId));
        }
    }

    private static final class ContainerStartedTransition
    extends BaseTransition {
        private ContainerStartedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.eventHandler.handle((Event)new RMAppAttemptContainerAllocatedEvent(container.appAttemptId));
        }
    }

    private static final class ContainerReservedTransition
    extends BaseTransition {
        private ContainerReservedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            RMContainerReservedEvent e = (RMContainerReservedEvent)event;
            container.reservedResource = e.getReservedResource();
            container.reservedNode = e.getReservedNode();
            container.reservedPriority = e.getReservedPriority();
        }
    }

    private static final class ContainerRecoveredTransition
    implements MultipleArcTransition<RMContainerImpl, RMContainerEvent, RMContainerState> {
        private ContainerRecoveredTransition() {
        }

        public RMContainerState transition(RMContainerImpl container, RMContainerEvent event) {
            NMContainerStatus report = ((RMContainerRecoverEvent)event).getContainerReport();
            if (report.getContainerState().equals((Object)ContainerState.COMPLETE)) {
                ContainerStatus status = ContainerStatus.newInstance((ContainerId)report.getContainerId(), (ContainerState)report.getContainerState(), (String)report.getDiagnostics(), (int)report.getContainerExitStatus());
                new FinishedTransition().transition(container, new RMContainerFinishedEvent(container.containerId, status, RMContainerEventType.FINISHED));
                return RMContainerState.COMPLETED;
            }
            if (report.getContainerState().equals((Object)ContainerState.RUNNING)) {
                container.eventHandler.handle((Event)new RMAppRunningOnNodeEvent(container.getApplicationAttemptId().getApplicationId(), container.nodeId));
                return RMContainerState.RUNNING;
            }
            LOG.warn((Object)("RMContainer received unexpected recover event with container state " + report.getContainerState() + " while recovering."));
            return RMContainerState.RUNNING;
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<RMContainerImpl, RMContainerEvent> {
        private BaseTransition() {
        }

        public void transition(RMContainerImpl cont, RMContainerEvent event) {
        }
    }
}

