/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementRule;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestAllocationFileLoaderService {
    static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    static final String ALLOC_FILE = new File(TEST_DIR, "test-queues").getAbsolutePath();

    @Test
    public void testGetAllocationFileFromClasspath() {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", "test-fair-scheduler.xml");
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        File allocationFile = allocLoader.getAllocationFile(conf);
        Assert.assertEquals((Object)"test-fair-scheduler.xml", (Object)allocationFile.getName());
        Assert.assertTrue((boolean)allocationFile.exists());
    }

    @Test(timeout=10000L)
    public void testReload() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueA\">");
        out.println("    <maxRunningApps>1</maxRunningApps>");
        out.println("  </queue>");
        out.println("  <queue name=\"queueB\" />");
        out.println("  <queuePlacementPolicy>");
        out.println("    <rule name='default' />");
        out.println("  </queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        MockClock clock = new MockClock();
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService((Clock)clock);
        allocLoader.reloadIntervalMs = 5L;
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        QueuePlacementPolicy policy = allocConf.getPlacementPolicy();
        List rules = policy.getRules();
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals(QueuePlacementRule.Default.class, ((QueuePlacementRule)rules.get(0)).getClass());
        Assert.assertEquals((long)1L, (long)allocConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)2L, (long)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertTrue((boolean)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueA"));
        Assert.assertTrue((boolean)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueB"));
        confHolder.allocConf = null;
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueB\">");
        out.println("    <maxRunningApps>3</maxRunningApps>");
        out.println("  </queue>");
        out.println("  <queuePlacementPolicy>");
        out.println("    <rule name='specified' />");
        out.println("    <rule name='nestedUserQueue' >");
        out.println("         <rule name='primaryGroup' />");
        out.println("    </rule>");
        out.println("    <rule name='default' />");
        out.println("  </queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        clock.tick(System.currentTimeMillis() + 5000L + 10000L);
        allocLoader.start();
        while (confHolder.allocConf == null) {
            Thread.sleep(20L);
        }
        allocConf = confHolder.allocConf;
        policy = allocConf.getPlacementPolicy();
        rules = policy.getRules();
        Assert.assertEquals((long)3L, (long)rules.size());
        Assert.assertEquals(QueuePlacementRule.Specified.class, ((QueuePlacementRule)rules.get(0)).getClass());
        Assert.assertEquals(QueuePlacementRule.NestedUserQueue.class, ((QueuePlacementRule)rules.get(1)).getClass());
        Assert.assertEquals(QueuePlacementRule.PrimaryGroup.class, ((QueuePlacementRule.NestedUserQueue)rules.get((int)1)).nestedRule.getClass());
        Assert.assertEquals(QueuePlacementRule.Default.class, ((QueuePlacementRule)rules.get(2)).getClass());
        Assert.assertEquals((long)3L, (long)allocConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)1L, (long)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertTrue((boolean)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueB"));
    }

    @Test
    public void testAllocationFileParsing() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<aclAdministerApps>alice,bob admins</aclAdministerApps>");
        out.println("<schedulingPolicy>fair</schedulingPolicy>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<aclSubmitApps>alice,bob admins</aclSubmitApps>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<maxRunningApps>3</maxRunningApps>");
        out.println("<maxAMShare>0.4</maxAMShare>");
        out.println("</queue>");
        out.println("<queue name=\"queueE\">");
        out.println("<minSharePreemptionTimeout>60</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queue name=\"queueF\" type=\"parent\" >");
        out.println("</queue>");
        out.println("<queue name=\"queueG\">");
        out.println("<fairSharePreemptionTimeout>120</fairSharePreemptionTimeout>");
        out.println("<minSharePreemptionTimeout>50</minSharePreemptionTimeout>");
        out.println("<fairSharePreemptionThreshold>0.6</fairSharePreemptionThreshold>");
        out.println("   <queue name=\"queueH\">");
        out.println("   <fairSharePreemptionTimeout>180</fairSharePreemptionTimeout>");
        out.println("   <minSharePreemptionTimeout>40</minSharePreemptionTimeout>");
        out.println("   <fairSharePreemptionThreshold>0.7</fairSharePreemptionThreshold>");
        out.println("   </queue>");
        out.println("</queue>");
        out.println("<queueMaxAppsDefault>15</queueMaxAppsDefault>");
        out.println("<userMaxAppsDefault>5</userMaxAppsDefault>");
        out.println("<queueMaxAMShareDefault>0.5f</queueMaxAMShareDefault>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>10</maxRunningApps>");
        out.println("</user>");
        out.println("<defaultMinSharePreemptionTimeout>120</defaultMinSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionTimeout>300</defaultFairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>0.4</defaultFairSharePreemptionThreshold>");
        out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertEquals((long)6L, (long)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueConf.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueConf.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueE"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueConf.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueConf.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueConf.getUserMaxApps("user2"));
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.default"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueA"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueB"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueC"), (double)0.01);
        Assert.assertEquals((double)0.4f, (double)queueConf.getQueueMaxAMShare("root.queueD"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueE"), (double)0.01);
        Assert.assertEquals((Object)"*", (Object)queueConf.getQueueAcl("root", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)"*", (Object)queueConf.getQueueAcl("root", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((Object)" ", (Object)queueConf.getQueueAcl("root.queueA", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)" ", (Object)queueConf.getQueueAcl("root.queueA", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((Object)"alice,bob admins", (Object)queueConf.getQueueAcl("root.queueB", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)"alice,bob admins", (Object)queueConf.getQueueAcl("root.queueC", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)60000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueF"));
        Assert.assertEquals((long)50000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueG"));
        Assert.assertEquals((long)40000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueG.queueH"));
        Assert.assertEquals((long)300000L, (long)queueConf.getFairSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueF"));
        Assert.assertEquals((long)120000L, (long)queueConf.getFairSharePreemptionTimeout("root.queueG"));
        Assert.assertEquals((long)180000L, (long)queueConf.getFairSharePreemptionTimeout("root.queueG.queueH"));
        Assert.assertEquals((double)0.4f, (double)queueConf.getFairSharePreemptionThreshold("root"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.default"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueA"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueB"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueC"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueD"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueE"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueF"), (double)0.01);
        Assert.assertEquals((double)0.6f, (double)queueConf.getFairSharePreemptionThreshold("root.queueG"), (double)0.01);
        Assert.assertEquals((double)0.7f, (double)queueConf.getFairSharePreemptionThreshold("root.queueG.queueH"), (double)0.01);
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.PARENT)).contains("root.queueF"));
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.PARENT)).contains("root.queueG"));
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueG.queueH"));
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root").getName());
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root.queueA").getName());
        Assert.assertEquals((Object)"fair", (Object)queueConf.getSchedulingPolicy("root.queueB").getName());
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root.newqueue").getName());
    }

    @Test
    public void testBackwardsCompatibleAllocationFileParsing() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<pool name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</pool>");
        out.println("<pool name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<aclAdministerApps>alice,bob admins</aclAdministerApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueC\">");
        out.println("<aclSubmitApps>alice,bob admins</aclSubmitApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueD\">");
        out.println("<maxRunningApps>3</maxRunningApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueE\">");
        out.println("<minSharePreemptionTimeout>60</minSharePreemptionTimeout>");
        out.println("<fairSharePreemptionThreshold>0.3</fairSharePreemptionThreshold>");
        out.println("</pool>");
        out.println("<queueMaxAppsDefault>15</queueMaxAppsDefault>");
        out.println("<userMaxAppsDefault>5</userMaxAppsDefault>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>10</maxRunningApps>");
        out.println("</user>");
        out.println("<defaultMinSharePreemptionTimeout>120</defaultMinSharePreemptionTimeout>");
        out.println("<fairSharePreemptionTimeout>300</fairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>0.6</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertEquals((long)5L, (long)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueConf.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueConf.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueE"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueConf.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueConf.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueConf.getUserMaxApps("user2"));
        Assert.assertEquals((Object)" ", (Object)queueConf.getQueueAcl("root.queueA", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)" ", (Object)queueConf.getQueueAcl("root.queueA", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((Object)"alice,bob admins", (Object)queueConf.getQueueAcl("root.queueB", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)"alice,bob admins", (Object)queueConf.getQueueAcl("root.queueC", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)60000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)300000L, (long)queueConf.getFairSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((double)0.6f, (double)queueConf.getFairSharePreemptionThreshold("root"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.default"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueA"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueB"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueC"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueD"), (double)0.01);
        Assert.assertEquals((double)0.3f, (double)queueConf.getFairSharePreemptionThreshold("root.queueE"), (double)0.01);
    }

    @Test
    public void testSimplePlacementPolicyFromConf() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        conf.setBoolean("yarn.scheduler.fair.user-as-default-queue", false);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        QueuePlacementPolicy placementPolicy = allocConf.getPlacementPolicy();
        List rules = placementPolicy.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        Assert.assertEquals(QueuePlacementRule.Specified.class, ((QueuePlacementRule)rules.get(0)).getClass());
        Assert.assertEquals((Object)false, (Object)((QueuePlacementRule)rules.get((int)0)).create);
        Assert.assertEquals(QueuePlacementRule.Default.class, ((QueuePlacementRule)rules.get(1)).getClass());
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueAlongsideRoot() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("</queue>");
        out.println("<queue name=\"other\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueNameContainingPeriods() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"parent1.child1\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test
    public void testReservableQueue() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"reservable\">");
        out.println("<reservation>");
        out.println("</reservation>");
        out.println("</queue>");
        out.println("<queue name=\"other\">");
        out.println("</queue>");
        out.println("<reservation-agent>DummyAgentName</reservation-agent>");
        out.println("<reservation-policy>AnyAdmissionPolicy</reservation-policy>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        String reservableQueueName = "root.reservable";
        String nonreservableQueueName = "root.other";
        Assert.assertFalse((boolean)allocConf.isReservable(nonreservableQueueName));
        Assert.assertTrue((boolean)allocConf.isReservable(reservableQueueName));
        Assert.assertTrue((boolean)allocConf.getMoveOnExpiry(reservableQueueName));
        Assert.assertEquals((long)86400000L, (long)allocConf.getReservationWindow(reservableQueueName));
        Assert.assertEquals((double)100.0, (double)allocConf.getInstantaneousMaxCapacity(reservableQueueName), (double)1.0E-4);
        Assert.assertEquals((Object)"DummyAgentName", (Object)allocConf.getReservationAgent(reservableQueueName));
        Assert.assertEquals((double)100.0, (double)allocConf.getAverageCapacity(reservableQueueName), (double)0.001);
        Assert.assertFalse((boolean)allocConf.getShowReservationAsQueues(reservableQueueName));
        Assert.assertEquals((Object)"AnyAdmissionPolicy", (Object)allocConf.getReservationAdmissionPolicy(reservableQueueName));
        Assert.assertEquals((Object)"org.apache.hadoop.yarn.server.resourcemanager.reservation.SimpleCapacityReplanner", (Object)allocConf.getReplanner(reservableQueueName));
        Assert.assertEquals((long)3600000L, (long)allocConf.getEnforcementWindow(reservableQueueName));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testReservableCannotBeCombinedWithDynamicUserQueue() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"notboth\" type=\"parent\" >");
        out.println("<reservation>");
        out.println("</reservation>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    private class ReloadListener
    implements AllocationFileLoaderService.Listener {
        public AllocationConfiguration allocConf;

        private ReloadListener() {
        }

        public void onReload(AllocationConfiguration info) {
            this.allocConf = info;
        }
    }

    private class MockClock
    implements Clock {
        private long time = 0L;

        private MockClock() {
        }

        public long getTime() {
            return this.time;
        }

        public void tick(long ms) {
            this.time += ms;
        }
    }
}

