/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestQueueMappings {
    private static final Log LOG = LogFactory.getLog(TestQueueMappings.class);
    private static final String Q1 = "q1";
    private static final String Q2 = "q2";
    private static final String Q1_PATH = "root.q1";
    private static final String Q2_PATH = "root.q2";
    private MockRM resourceManager;

    @After
    public void tearDown() throws Exception {
        if (this.resourceManager != null) {
            LOG.info((Object)"Stopping the resource manager");
            this.resourceManager.stop();
        }
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{Q1, Q2});
        conf.setCapacity(Q1_PATH, 10.0f);
        conf.setCapacity(Q2_PATH, 90.0f);
        LOG.info((Object)"Setup top-level queues q1 and q2");
    }

    @Test(timeout=60000L)
    public void testQueueMapping() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        CapacityScheduler cs = new CapacityScheduler();
        RMContext rmContext = TestUtils.getMockRMContext();
        cs.setConf((Configuration)conf);
        cs.setRMContext(rmContext);
        cs.init((Configuration)conf);
        cs.start();
        conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        conf.set("yarn.scheduler.capacity.queue-mappings-override.enable", "true");
        this.checkInvalidQMapping(conf, cs, "x:a:b", "invalid specifier");
        this.checkInvalidQMapping(conf, cs, "u:a", "no queue specified");
        this.checkInvalidQMapping(conf, cs, "g:a", "no queue specified");
        this.checkInvalidQMapping(conf, cs, "u:a:b,g:a", "multiple mappings with invalid mapping");
        this.checkInvalidQMapping(conf, cs, "u:a:b,g:a:d:e", "too many path segments");
        this.checkInvalidQMapping(conf, cs, "u::", "empty source and queue");
        this.checkInvalidQMapping(conf, cs, "u:", "missing source missing queue");
        this.checkInvalidQMapping(conf, cs, "u:a:", "empty source missing q");
        conf.set("yarn.scheduler.capacity.queue-mappings", "u:a:q1");
        cs.reinitialize((Configuration)conf, null);
        this.checkQMapping("a", Q1, cs);
        conf.set("yarn.scheduler.capacity.queue-mappings", "g:agroup:q1");
        cs.reinitialize((Configuration)conf, null);
        this.checkQMapping("a", Q1, cs);
        conf.set("yarn.scheduler.capacity.queue-mappings", "u:%user:q2");
        cs.reinitialize((Configuration)conf, null);
        this.checkQMapping("a", Q2, cs);
        conf.set("yarn.scheduler.capacity.queue-mappings", "u:%user:%user");
        cs.reinitialize((Configuration)conf, null);
        this.checkQMapping("a", "a", cs);
        conf.set("yarn.scheduler.capacity.queue-mappings", "u:%user:%primary_group");
        cs.reinitialize((Configuration)conf, null);
        this.checkQMapping("a", "agroup", cs);
        conf.set("yarn.scheduler.capacity.queue-mappings", "g:asubgroup1:q1");
        cs.reinitialize((Configuration)conf, null);
        this.checkQMapping("a", Q1, cs);
        conf.set("yarn.scheduler.capacity.queue-mappings", "    u : a : q1");
        cs.reinitialize((Configuration)conf, null);
        this.checkQMapping("a", Q1, cs);
        csConf = new CapacitySchedulerConfiguration();
        csConf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        this.setupQueueConfiguration(csConf);
        conf = new YarnConfiguration((Configuration)csConf);
        this.resourceManager = new MockRM((Configuration)csConf);
        this.resourceManager.start();
        conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        conf.set("yarn.scheduler.capacity.queue-mappings-override.enable", "true");
        conf.set("yarn.scheduler.capacity.queue-mappings", "u:user:q1");
        this.resourceManager.getResourceScheduler().reinitialize((Configuration)conf, null);
        this.checkAppQueue(this.resourceManager, "user", Q2, Q1);
        conf.setBoolean("yarn.scheduler.capacity.queue-mappings-override.enable", false);
        conf.set("yarn.scheduler.capacity.queue-mappings", "u:user:q1");
        this.setupQueueConfiguration(csConf);
        this.resourceManager.getResourceScheduler().reinitialize((Configuration)conf, null);
        this.checkAppQueue(this.resourceManager, "user", Q2, Q2);
        this.checkAppQueue(this.resourceManager, "user", null, Q1);
        conf.set("yarn.scheduler.capacity.queue-mappings", "g:usergroup:q2");
        this.setupQueueConfiguration(csConf);
        this.resourceManager.getResourceScheduler().reinitialize((Configuration)conf, null);
        this.checkAppQueue(this.resourceManager, "user", null, Q2);
        conf.set("yarn.scheduler.capacity.queue-mappings", "u:user:non_existent_queue");
        this.setupQueueConfiguration(csConf);
        boolean fail = false;
        try {
            this.resourceManager.getResourceScheduler().reinitialize((Configuration)conf, null);
        }
        catch (IOException ioex) {
            fail = true;
        }
        Assert.assertTrue((String)"queue initialization failed for non-existent q", (boolean)fail);
        this.resourceManager.stop();
    }

    private void checkAppQueue(MockRM resourceManager, String user, String submissionQueue, String expected) throws Exception {
        RMApp app = resourceManager.submitApp(200, "name", user, new HashMap<ApplicationAccessType, String>(), false, submissionQueue, -1, null, "MAPREDUCE", false);
        RMAppState expectedState = expected.isEmpty() ? RMAppState.FAILED : RMAppState.ACCEPTED;
        resourceManager.waitForState(app.getApplicationId(), expectedState);
        CapacityScheduler cs = (CapacityScheduler)resourceManager.getResourceScheduler();
        SchedulerApplication schedulerApp = (SchedulerApplication)cs.getSchedulerApplications().get(app.getApplicationId());
        String queue = "";
        if (schedulerApp != null) {
            queue = schedulerApp.getQueue().getQueueName();
        }
        Assert.assertTrue((String)("expected " + expected + " actual " + queue), (boolean)expected.equals(queue));
        Assert.assertEquals((Object)expected, (Object)app.getQueue());
    }

    private void checkInvalidQMapping(YarnConfiguration conf, CapacityScheduler cs, String mapping, String reason) throws IOException {
        boolean fail = false;
        try {
            conf.set("yarn.scheduler.capacity.queue-mappings", mapping);
            cs.reinitialize((Configuration)conf, null);
        }
        catch (IOException ex) {
            fail = true;
        }
        Assert.assertTrue((String)("invalid mapping did not throw exception for " + reason), (boolean)fail);
    }

    private void checkQMapping(String user, String expected, CapacityScheduler cs) throws IOException {
        String actual = cs.getMappedQueueForTest(user);
        Assert.assertTrue((String)("expected " + expected + " actual " + actual), (boolean)expected.equals(actual));
    }
}

