/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.TestFifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestContainerAllocation {
    private static final Log LOG = LogFactory.getLog(TestFifoScheduler.class);
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;
    private volatile int numRetries = 0;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    @Test(timeout=3000000L)
    public void testExcessReservationThanNodeManagerCapacity() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 2048, 4);
        MockNM nm2 = rm.registerNode("127.0.0.1:2234", 3072, 4);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        int waitCount = 20;
        int size = rm.getRMContext().getRMNodes().size();
        while ((size = rm.getRMContext().getRMNodes().size()) != 2 && waitCount-- > 0) {
            LOG.info((Object)("Waiting for node managers to register : " + size));
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)2L, (long)rm.getRMContext().getRMNodes().size());
        RMApp app1 = rm.submitApp(128);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        LOG.info((Object)"sending container requests ");
        am1.addRequests(new String[]{"*"}, 2048, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        int waitCounter = 20;
        LOG.info((Object)"heartbeating nm1");
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info((Object)("received container : " + alloc1Response.getAllocatedContainers().size()));
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 0 ? 1 : 0) != 0);
        LOG.info((Object)"heartbeating nm2");
        waitCounter = 20;
        nm2.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info((Object)("received container : " + alloc1Response.getAllocatedContainers().size()));
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 1 ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testContainerTokenGeneratedOnPullRequest() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        RMApp app1 = rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        RMContainer container = rm1.getResourceScheduler().getRMContainer(containerId2);
        Assert.assertEquals((Object)containerId2, (Object)container.getContainerId());
        Assert.assertNull((Object)container.getContainer().getContainerToken());
        List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((Object)containerId2, (Object)((Container)containers.get(0)).getId());
        Assert.assertNotNull((Object)((Container)containers.get(0)).getContainerToken());
        rm1.stop();
    }

    @Test
    public void testNormalContainerAllocationWhenDNSUnavailable() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        RMApp app1 = rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((long)0L, (long)containers.size());
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test
    public void testLogAggregationContextPassedIntoContainerToken() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        MockNM nm2 = rm1.registerNode("127.0.0.1:2345", 8000);
        Assert.assertNull((Object)this.getLogAggregationContextFromContainerToken(rm1, nm1, null));
        LogAggregationContext logAggregationContext = LogAggregationContext.newInstance((String)"includePattern", (String)"excludePattern", (String)"rolledLogsIncludePattern", (String)"rolledLogsExcludePattern");
        LogAggregationContext returned = this.getLogAggregationContextFromContainerToken(rm1, nm2, logAggregationContext);
        Assert.assertEquals((Object)"includePattern", (Object)returned.getIncludePattern());
        Assert.assertEquals((Object)"excludePattern", (Object)returned.getExcludePattern());
        Assert.assertEquals((Object)"rolledLogsIncludePattern", (Object)returned.getRolledLogsIncludePattern());
        Assert.assertEquals((Object)"rolledLogsExcludePattern", (Object)returned.getRolledLogsExcludePattern());
        rm1.stop();
    }

    private LogAggregationContext getLogAggregationContextFromContainerToken(MockRM rm1, MockNM nm1, LogAggregationContext logAggregationContext) throws Exception {
        RMApp app2 = rm1.submitApp(200, logAggregationContext);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        nm1.nodeHeartbeat(true);
        am2.allocate("127.0.0.1", 512, 1, new ArrayList<ContainerId>());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED);
        List containers = am2.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((Object)containerId, (Object)((Container)containers.get(0)).getId());
        Assert.assertNotNull((Object)((Container)containers.get(0)).getContainerToken());
        ContainerTokenIdentifier token = BuilderUtils.newContainerTokenIdentifier((Token)((Container)containers.get(0)).getContainerToken());
        return token.getLogAggregationContext();
    }

    @Test(timeout=30000L)
    public void testAMContainerAllocationWhenDNSUnavailable() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf){

            protected RMSecretManagerService createRMSecretManagerService() {
                return new TestRMSecretManagerService((Configuration)TestContainerAllocation.this.conf, this.rmContext);
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        RMApp app1 = rm1.submitApp(200);
        RMAppAttempt attempt = app1.getCurrentAppAttempt();
        nm1.nodeHeartbeat(true);
        while (this.numRetries <= 5) {
            nm1.nodeHeartbeat(true);
            Thread.sleep(1000L);
            Assert.assertEquals((Object)RMAppAttemptState.SCHEDULED, (Object)attempt.getAppAttemptState());
            System.out.println("Waiting for am container to be allocated.");
        }
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        rm1.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.ALLOCATED);
        MockRM.launchAndRegisterAM(app1, rm1, nm1);
    }

    private Configuration getConfigurationWithDefaultQueueLabels(Configuration config) {
        String A = "root.a";
        String B = "root.b";
        CapacitySchedulerConfiguration conf = (CapacitySchedulerConfiguration)this.getConfigurationWithQueueLabels(config);
        new CapacitySchedulerConfiguration(config);
        conf.setDefaultNodeLabelExpression("root.a", "x");
        conf.setDefaultNodeLabelExpression("root.b", "y");
        return conf;
    }

    private Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a", "b", "c"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        conf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        conf.setAccessibleNodeLabels("root.b", this.toSet("y"));
        conf.setCapacityByLabel("root.b", "y", 100.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
        conf.setAccessibleNodeLabels("root.c", RMNodeLabelsManager.EMPTY_STRING_SET);
        String A1 = "root.a.a1";
        conf.setQueues("root.a", new String[]{"a1"});
        conf.setCapacity("root.a.a1", 100.0f);
        conf.setMaximumCapacity("root.a.a1", 100.0f);
        conf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        String B1 = "root.b.b1";
        conf.setQueues("root.b", new String[]{"b1"});
        conf.setCapacity("root.b.b1", 100.0f);
        conf.setMaximumCapacity("root.b.b1", 100.0f);
        conf.setCapacityByLabel("root.b.b1", "y", 100.0f);
        String C1 = "root.c.c1";
        conf.setQueues("root.c", new String[]{"c1"});
        conf.setCapacity("root.c.c1", 100.0f);
        conf.setMaximumCapacity("root.c.c1", 100.0f);
        return conf;
    }

    private void checkTaskContainersHost(ApplicationAttemptId attemptId, ContainerId containerId, ResourceManager rm, String host) {
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        SchedulerAppReport appReport = scheduler.getSchedulerAppInfo(attemptId);
        Assert.assertTrue((appReport.getLiveContainers().size() > 0 ? 1 : 0) != 0);
        for (RMContainer c : appReport.getLiveContainers()) {
            if (!c.getContainerId().equals((Object)containerId)) continue;
            Assert.assertEquals((Object)host, (Object)c.getAllocatedNode().getHost());
        }
    }

    private <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    private Configuration getComplexConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        conf.setCapacityByLabel("root", "z", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 10.0f);
        conf.setAccessibleNodeLabels("root.a", this.toSet("x", "y"));
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        conf.setCapacityByLabel("root.a", "y", 50.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        conf.setMaximumCapacity("root.b", 100.0f);
        conf.setAccessibleNodeLabels("root.b", this.toSet("y", "z"));
        conf.setCapacityByLabel("root.b", "y", 50.0f);
        conf.setCapacityByLabel("root.b", "z", 100.0f);
        String A1 = "root.a.a1";
        conf.setQueues("root.a", new String[]{"a1"});
        conf.setCapacity("root.a.a1", 100.0f);
        conf.setMaximumCapacity("root.a.a1", 100.0f);
        conf.setAccessibleNodeLabels("root.a.a1", this.toSet("x", "y"));
        conf.setDefaultNodeLabelExpression("root.a.a1", "x");
        conf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        conf.setCapacityByLabel("root.a.a1", "y", 100.0f);
        conf.setQueues("root.b", new String[]{"b1", "b2"});
        String B1 = "root.b.b1";
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setMaximumCapacity("root.b.b1", 50.0f);
        conf.setAccessibleNodeLabels("root.b.b1", RMNodeLabelsManager.EMPTY_STRING_SET);
        String B2 = "root.b.b2";
        conf.setCapacity("root.b.b2", 50.0f);
        conf.setMaximumCapacity("root.b.b2", 50.0f);
        conf.setAccessibleNodeLabels("root.b.b2", this.toSet("y", "z"));
        conf.setCapacityByLabel("root.b.b2", "y", 100.0f);
        conf.setCapacityByLabel("root.b.b2", "z", 100.0f);
        return conf;
    }

    @Test(timeout=300000L)
    public void testContainerAllocationWithSingleUserLimits() throws Exception {
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)this.conf);
        mgr.addToCluserNodeLabels((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(this.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager((RMNodeLabelsManager)mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        RMApp app1 = rm1.submitApp(200, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        Assert.assertFalse((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        for (int id = 3; id <= 8; ++id) {
            containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)id);
            am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
            Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        }
        rm1.close();
    }

    @Test(timeout=300000L)
    public void testContainerAllocateWithComplexLabels() throws Exception {
        this.mgr.addToCluserNodeLabels((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y"), (Object)NodeId.newInstance((String)"h3", (int)0), this.toSet("y"), (Object)NodeId.newInstance((String)"h4", (int)0), this.toSet("z"), (Object)NodeId.newInstance((String)"h5", (int)0), (Object)RMNodeLabelsManager.EMPTY_STRING_SET));
        MockRM rm1 = new MockRM(this.getComplexConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 2048);
        MockNM nm2 = rm1.registerNode("h2:1234", 2048);
        MockNM nm3 = rm1.registerNode("h3:1234", 2048);
        MockNM nm4 = rm1.registerNode("h4:1234", 2048);
        MockNM nm5 = rm1.registerNode("h5:1234", 2048);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h2");
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm5);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm4, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertFalse((boolean)rm1.waitForState(nm5, containerId, RMContainerState.ALLOCATED, 10000));
        RMApp app3 = rm1.submitApp(1024, "app", "user", null, "b2");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm5);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "z");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm1.waitForState(nm4, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h4");
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testContainerAllocateWithLabels() throws Exception {
        this.mgr.addToCluserNodeLabels((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        MockNM nm2 = rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        RMApp app1 = rm1.submitApp(200, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm3);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        RMApp app2 = rm1.submitApp(200, "app", "user", null, "b1");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm3);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am2.getApplicationAttemptId(), containerId, rm1, "h2");
        RMApp app3 = rm1.submitApp(200, "app", "user", null, "c1");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm3);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testContainerAllocateWithDefaultQueueLabels() throws Exception {
        this.mgr.addToCluserNodeLabels((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(this.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        MockNM nm2 = rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        RMApp app1 = rm1.submitApp(200, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        RMApp app2 = rm1.submitApp(200, "app", "user", null, "b1");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am2.getApplicationAttemptId(), containerId, rm1, "h2");
        RMApp app3 = rm1.submitApp(200, "app", "user", null, "c1");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm3);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        rm1.close();
    }

    private class TestRMSecretManagerService
    extends RMSecretManagerService {
        public TestRMSecretManagerService(Configuration conf, RMContextImpl rmContext) {
            super(conf, rmContext);
        }

        protected RMContainerTokenSecretManager createContainerTokenSecretManager(Configuration conf) {
            return new RMContainerTokenSecretManager(conf){

                public Token createContainerToken(ContainerId containerId, NodeId nodeId, String appSubmitter, Resource capability, Priority priority2, long createTime, LogAggregationContext logAggregationContext) {
                    TestContainerAllocation.this.numRetries++;
                    return super.createContainerToken(containerId, nodeId, appSubmitter, capability, priority2, createTime, logAggregationContext);
                }
            };
        }
    }
}

