/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.NoOverCommitPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.MismatchedUserException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ResourceOverCommitException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNoOverCommitPolicy {
    long step;
    long initTime;
    InMemoryPlan plan;
    ReservationAgent mAgent;
    Resource minAlloc;
    ResourceCalculator res;
    Resource maxAlloc;
    int totCont = 1000000;

    @Before
    public void setup() throws Exception {
        this.step = 1000L;
        this.initTime = System.currentTimeMillis();
        this.minAlloc = Resource.newInstance((int)1024, (int)1);
        this.res = new DefaultResourceCalculator();
        this.maxAlloc = Resource.newInstance((int)8192, (int)8);
        this.mAgent = (ReservationAgent)Mockito.mock(ReservationAgent.class);
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        String reservationQ = testUtil.getFullReservationQueueName();
        QueueMetrics rootQueueMetrics = (QueueMetrics)Mockito.mock(QueueMetrics.class);
        Resource clusterResource = ReservationSystemTestUtil.calculateClusterResource(this.totCont);
        ReservationSchedulerConfiguration conf = (ReservationSchedulerConfiguration)Mockito.mock(ReservationSchedulerConfiguration.class);
        NoOverCommitPolicy policy = new NoOverCommitPolicy();
        policy.init(reservationQ, conf);
        this.plan = new InMemoryPlan(rootQueueMetrics, (SharingPolicy)policy, this.mAgent, clusterResource, this.step, this.res, this.minAlloc, this.maxAlloc, "dedicated", null, true);
    }

    public int[] generateData(int length, int val) {
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = val;
        }
        return data;
    }

    @Test
    public void testSingleUserEasyFitPass() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)Math.ceil(0.2 * (double)this.totCont));
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc)));
    }

    @Test
    public void testSingleUserBarelyFitPass() throws IOException, PlanningException {
        int[] f = this.generateData(3600, this.totCont);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc)));
    }

    @Test(expected=ResourceOverCommitException.class)
    public void testSingleFail() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)(1.1 * (double)this.totCont));
        this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc));
    }

    @Test(expected=MismatchedUserException.class)
    public void testUserMismatch() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)(0.5 * (double)this.totCont));
        ReservationId rid = ReservationSystemTestUtil.getNewReservationId();
        this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(rid, null, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc));
        this.plan.updateReservation((ReservationAllocation)new InMemoryReservationAllocation(rid, null, "u2", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc));
    }

    @Test
    public void testMultiTenantPass() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)Math.ceil(0.25 * (double)this.totCont));
        for (int i = 0; i < 4; ++i) {
            Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u" + i, "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc)));
        }
    }

    @Test(expected=ResourceOverCommitException.class)
    public void testMultiTenantFail() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)Math.ceil(0.25 * (double)this.totCont));
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u" + i, "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc)));
        }
    }
}

