/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestCapacityReservationSystem {
    @Test
    public void testInitialize() {
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        CapacityScheduler capScheduler = null;
        try {
            capScheduler = testUtil.mockCapacityScheduler(10);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        CapacityReservationSystem reservationSystem = new CapacityReservationSystem();
        reservationSystem.setRMContext(capScheduler.getRMContext());
        try {
            reservationSystem.reinitialize(capScheduler.getConf(), capScheduler.getRMContext());
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        String planQName = testUtil.getreservationQueueName();
        ReservationSystemTestUtil.validateReservationQueue((AbstractReservationSystem)reservationSystem, planQName);
    }

    @Test
    public void testReinitialize() {
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        CapacityScheduler capScheduler = null;
        try {
            capScheduler = testUtil.mockCapacityScheduler(10);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        CapacityReservationSystem reservationSystem = new CapacityReservationSystem();
        CapacitySchedulerConfiguration conf = capScheduler.getConfiguration();
        RMContext mockContext = capScheduler.getRMContext();
        reservationSystem.setRMContext(mockContext);
        try {
            reservationSystem.reinitialize((Configuration)capScheduler.getConfiguration(), mockContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        String planQName = testUtil.getreservationQueueName();
        ReservationSystemTestUtil.validateReservationQueue((AbstractReservationSystem)reservationSystem, planQName);
        String newQ = "reservation";
        Assert.assertNull((Object)reservationSystem.getPlan(newQ));
        testUtil.updateQueueConfiguration(conf, newQ);
        try {
            capScheduler.reinitialize((Configuration)conf, mockContext);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            reservationSystem.reinitialize((Configuration)conf, mockContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        ReservationSystemTestUtil.validateNewReservationQueue((AbstractReservationSystem)reservationSystem, newQ);
    }
}

