/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMoveApplication {
    private ResourceManager resourceManager = null;
    private static boolean failMove;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", FifoSchedulerWithMove.class, FifoSchedulerWithMove.class);
        this.conf.set("yarn.admin.acl", " ");
        this.conf.setBoolean("yarn.acl.enable", true);
        this.resourceManager = new ResourceManager();
        this.resourceManager.init(this.conf);
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMContext().getNMTokenSecretManager().rollMasterKey();
        this.resourceManager.start();
        failMove = false;
    }

    @After
    public void tearDown() {
        this.resourceManager.stop();
    }

    @Test
    public void testMoveRejectedByScheduler() throws Exception {
        failMove = true;
        Application application = new Application("user1", this.resourceManager);
        application.submit();
        RMApp app = (RMApp)this.resourceManager.rmContext.getRMApps().get(application.getApplicationId());
        while (app.getState() != RMAppState.ACCEPTED) {
            Thread.sleep(100L);
        }
        ClientRMService clientRMService = this.resourceManager.getClientRMService();
        try {
            clientRMService.moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)application.getApplicationId(), (String)"newqueue"));
            Assert.fail((String)"Should have hit exception");
        }
        catch (YarnException ex) {
            Assert.assertEquals((Object)"Move not supported", (Object)ex.getCause().getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testMoveTooLate() throws Exception {
        Application application = new Application("user1", this.resourceManager);
        ApplicationId appId = application.getApplicationId();
        application.submit();
        ClientRMService clientRMService = this.resourceManager.getClientRMService();
        clientRMService.forceKillApplication(KillApplicationRequest.newInstance((ApplicationId)appId));
        RMApp rmApp = (RMApp)this.resourceManager.getRMContext().getRMApps().get(appId);
        while (rmApp.getState() != RMAppState.KILLED) {
            Thread.sleep(100L);
        }
        try {
            clientRMService.moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)appId, (String)"newqueue"));
            Assert.fail((String)"Should have hit exception");
        }
        catch (YarnException ex) {
            Assert.assertEquals(YarnException.class, ((Object)((Object)ex)).getClass());
            Assert.assertEquals((Object)"App in KILLED state cannot be moved.", (Object)ex.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testMoveSuccessful() throws Exception {
        MockRM rm1 = new MockRM(this.conf);
        rm1.start();
        RMApp app = rm1.submitApp(1024);
        ClientRMService clientRMService = rm1.getClientRMService();
        clientRMService.moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)app.getApplicationId(), (String)"newqueue"));
        RMApp rmApp = (RMApp)rm1.getRMContext().getRMApps().get(app.getApplicationId());
        Assert.assertEquals((Object)"newqueue", (Object)rmApp.getQueue());
        rm1.stop();
    }

    @Test
    public void testMoveRejectedByPermissions() throws Exception {
        failMove = true;
        final Application application = new Application("user1", this.resourceManager);
        application.submit();
        final ClientRMService clientRMService = this.resourceManager.getClientRMService();
        try {
            UserGroupInformation.createRemoteUser((String)"otheruser").doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<MoveApplicationAcrossQueuesResponse>(){

                @Override
                public MoveApplicationAcrossQueuesResponse run() throws Exception {
                    return clientRMService.moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)application.getApplicationId(), (String)"newqueue"));
                }
            });
            Assert.fail((String)"Should have hit exception");
        }
        catch (Exception ex) {
            Assert.assertEquals(AccessControlException.class, ex.getCause().getCause().getClass());
        }
    }

    public static class FifoSchedulerWithMove
    extends FifoScheduler {
        public String moveApplication(ApplicationId appId, String newQueue) throws YarnException {
            if (failMove) {
                throw new YarnException("Move not supported");
            }
            return newQueue;
        }

        public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
            return acl != QueueACL.ADMINISTER_QUEUE;
        }
    }
}

