/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONMarshaller;
import com.sun.jersey.api.json.JSONUnmarshaller;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestRMWebServicesNodeLabels
extends JerseyTestBase {
    private static final Log LOG = LogFactory.getLog(TestRMWebServicesNodeLabels.class);
    private static MockRM rm;
    private YarnConfiguration conf;
    private String userName;
    private String notUserName;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ServletModule(){

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            try {
                TestRMWebServicesNodeLabels.this.userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to get current user name " + ioe.getMessage(), ioe);
            }
            TestRMWebServicesNodeLabels.this.notUserName = TestRMWebServicesNodeLabels.this.userName + "abc123";
            TestRMWebServicesNodeLabels.this.conf = new YarnConfiguration();
            TestRMWebServicesNodeLabels.this.conf.set("yarn.admin.acl", TestRMWebServicesNodeLabels.this.userName);
            rm = new MockRM((Configuration)TestRMWebServicesNodeLabels.this.conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.filter("/*", new String[0]).through(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }});

    public TestRMWebServicesNodeLabels() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testNodeLabels() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("add-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\":\"a\"}", "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((Object)"a", (Object)json.getString("nodeLabels"));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("add-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\":\"b\"}", "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        json = (JSONObject)response.getEntity(JSONObject.class);
        JSONArray jarr = json.getJSONArray("nodeLabels");
        Assert.assertEquals((long)2L, (long)jarr.length());
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\": [\"a\"]}", "application/json")).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((Object)"a", (Object)json.getString("nodeLabels"));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\":\"b\"}", "application/json")).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((Object)"b", (Object)json.getString("nodeLabels"));
        NodeToLabelsInfo ntli = new NodeToLabelsInfo();
        NodeLabelsInfo nli = new NodeLabelsInfo();
        nli.getNodeLabels().add("a");
        ntli.getNodeToLabels().put("nid:0", nli);
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("replace-node-to-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)this.toJson(ntli, NodeToLabelsInfo.class), "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-to-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        ntli = (NodeToLabelsInfo)response.getEntity(NodeToLabelsInfo.class);
        nli = (NodeLabelsInfo)ntli.getNodeToLabels().get("nid:0");
        Assert.assertEquals((long)1L, (long)nli.getNodeLabels().size());
        Assert.assertTrue((boolean)nli.getNodeLabels().contains("a"));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\"}", "application/json")).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((Object)"", (Object)json.getString("nodeLabels"));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\": \"a\"}", "application/json")).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((Object)"a", (Object)json.getString("nodeLabels"));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.notUserName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\": [\"b\"]}", "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((Object)"a", (Object)json.getString("nodeLabels"));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("add-node-labels").queryParam("user.name", this.notUserName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\":\"c\"}", "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        json = (JSONObject)response.getEntity(JSONObject.class);
        jarr = json.getJSONArray("nodeLabels");
        Assert.assertEquals((long)2L, (long)jarr.length());
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("remove-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\":\"b\"}", "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((Object)"a", (Object)json.getString("nodeLabels"));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("remove-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\":\"a\"}", "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        String res = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)res.equals("null"));
    }

    private String toJson(Object nsli, Class klass) throws Exception {
        StringWriter sw = new StringWriter();
        JSONJAXBContext ctx = new JSONJAXBContext(new Class[]{klass});
        JSONMarshaller jm = ctx.createJSONMarshaller();
        jm.marshallToJSON(nsli, (Writer)sw);
        return sw.toString();
    }

    private Object fromJson(String json, Class klass) throws Exception {
        StringReader sr = new StringReader(json);
        JSONJAXBContext ctx = new JSONJAXBContext(new Class[]{klass});
        JSONUnmarshaller jm = ctx.createJSONUnmarshaller();
        return jm.unmarshalFromJSON((Reader)sr, klass);
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestRMWebServicesNodeLabels.this.injector;
        }
    }
}

