/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodesPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebApp;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestNodesPage {
    final int numberOfRacks = 2;
    final int numberOfNodesPerRack = 6;
    final int numberOfLostNodesPerRack = 6 / NodeState.values().length;
    final int numberOfThInMetricsTable = 20;
    final int numberOfActualTableHeaders = 14;
    private Injector injector;

    @Before
    public void setUp() throws Exception {
        final RMContext mockRMContext = TestRMWebApp.mockRMContext(3, 2, 6, 8192);
        this.injector = WebAppTests.createMockInjector(RMContext.class, (Object)mockRMContext, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    binder.bind(ResourceManager.class).toInstance((Object)TestRMWebApp.mockRm(mockRMContext));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
    }

    @Test
    public void testNodesBlockRender() throws Exception {
        ((NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class)).render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)34))).print("<th");
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)188))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForLostNodes() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.state", "lost");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)34))).print("<th");
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)(2 * this.numberOfLostNodesPerRack * 14 + 20)))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForNodeLabelFilterWithNonEmptyLabel() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.label", "x");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)48))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForNodeLabelFilterWithEmptyLabel() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.label", "");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)160))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForNodeLabelFilterWithAnyLabel() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.label", "*");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)188))).print("<td");
    }
}

