/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.Comparator;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FakeSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestDominantResourceFairnessPolicy {
    private Comparator<Schedulable> createComparator(int clusterMem, int clusterCpu) {
        DominantResourceFairnessPolicy policy = new DominantResourceFairnessPolicy();
        policy.initialize(BuilderUtils.newResource((int)clusterMem, (int)clusterCpu));
        return policy.getComparator();
    }

    private Schedulable createSchedulable(int memUsage, int cpuUsage) {
        return this.createSchedulable(memUsage, cpuUsage, ResourceWeights.NEUTRAL, 0, 0);
    }

    private Schedulable createSchedulable(int memUsage, int cpuUsage, int minMemShare, int minCpuShare) {
        return this.createSchedulable(memUsage, cpuUsage, ResourceWeights.NEUTRAL, minMemShare, minCpuShare);
    }

    private Schedulable createSchedulable(int memUsage, int cpuUsage, ResourceWeights weights) {
        return this.createSchedulable(memUsage, cpuUsage, weights, 0, 0);
    }

    private Schedulable createSchedulable(int memUsage, int cpuUsage, ResourceWeights weights, int minMemShare, int minCpuShare) {
        Resource usage = BuilderUtils.newResource((int)memUsage, (int)cpuUsage);
        Resource minShare = BuilderUtils.newResource((int)minMemShare, (int)minCpuShare);
        return new FakeSchedulable(minShare, Resources.createResource((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE), weights, Resources.none(), usage, 0L);
    }

    @Test
    public void testSameDominantResource() {
        Assert.assertTrue((this.createComparator(8000, 4).compare(this.createSchedulable(1000, 1), this.createSchedulable(2000, 1)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDifferentDominantResource() {
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(4000, 3), this.createSchedulable(2000, 5)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOneIsNeedy() {
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(2000, 5, 0, 6), this.createSchedulable(4000, 3, 0, 0)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBothAreNeedy() {
        Assert.assertTrue((this.createComparator(8000, 100).compare(this.createSchedulable(2000, 5), this.createSchedulable(4000, 3)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.createComparator(8000, 100).compare(this.createSchedulable(2000, 5, 3000, 6), this.createSchedulable(4000, 3, 5000, 4)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEvenWeightsSameDominantResource() {
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(3000, 1, new ResourceWeights(2.0f)), this.createSchedulable(2000, 1)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(1000, 3, new ResourceWeights(2.0f)), this.createSchedulable(1000, 2)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEvenWeightsDifferentDominantResource() {
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(1000, 3, new ResourceWeights(2.0f)), this.createSchedulable(2000, 1)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(3000, 1, new ResourceWeights(2.0f)), this.createSchedulable(1000, 2)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUnevenWeightsSameDominantResource() {
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(3000, 1, new ResourceWeights(2.0f, 1.0f)), this.createSchedulable(2000, 1)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(1000, 3, new ResourceWeights(1.0f, 2.0f)), this.createSchedulable(1000, 2)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUnevenWeightsDifferentDominantResource() {
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(1000, 3, new ResourceWeights(1.0f, 2.0f)), this.createSchedulable(2000, 1)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(3000, 1, new ResourceWeights(2.0f, 1.0f)), this.createSchedulable(1000, 2)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateShares() {
        Resource used = Resources.createResource((int)10, (int)5);
        Resource capacity = Resources.createResource((int)100, (int)10);
        ResourceType[] resourceOrder = new ResourceType[2];
        ResourceWeights shares = new ResourceWeights();
        DominantResourceFairnessPolicy.DominantResourceFairnessComparator comparator = new DominantResourceFairnessPolicy.DominantResourceFairnessComparator();
        comparator.calculateShares(used, capacity, shares, resourceOrder, ResourceWeights.NEUTRAL);
        Assert.assertEquals((double)0.1, (double)shares.getWeight(ResourceType.MEMORY), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)shares.getWeight(ResourceType.CPU), (double)1.0E-5);
        Assert.assertEquals((Object)ResourceType.CPU, (Object)resourceOrder[0]);
        Assert.assertEquals((Object)ResourceType.MEMORY, (Object)resourceOrder[1]);
    }
}

