/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMWithCustomAMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationMasterLauncher {
    private static final Log LOG = LogFactory.getLog(TestApplicationMasterLauncher.class);

    @Test
    public void testAMLaunchAndCleanup() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MyContainerManagerImpl containerManager = new MyContainerManagerImpl();
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher(containerManager);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5120);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        int waitCount = 0;
        while (!containerManager.launched && waitCount++ < 20) {
            LOG.info((Object)"Waiting for AM Launch to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)containerManager.launched);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId appAttemptId = attempt.getAppAttemptId();
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)containerManager.attemptIdAtContainerManager);
        Assert.assertEquals((long)app.getSubmitTime(), (long)containerManager.submitTimeAtContainerManager);
        Assert.assertEquals((Object)app.getRMAppAttempt(appAttemptId).getMasterContainer().getId().toString(), (Object)containerManager.containerIdAtContainerManager);
        Assert.assertEquals((Object)nm1.getNodeId().toString(), (Object)containerManager.nmHostAtContainerManager);
        Assert.assertEquals((long)2L, (long)containerManager.maxAppAttempts);
        MockAM am = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.getApplicationMasterService(), appAttemptId);
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        waitCount = 0;
        while (!containerManager.cleanedup && waitCount++ < 20) {
            LOG.info((Object)"Waiting for AM Cleanup to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)containerManager.cleanedup);
        am.waitForState(RMAppAttemptState.FINISHED);
        rm.stop();
    }

    @Test(timeout=100000L)
    public void testallocateBeforeAMRegistration() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        boolean thrown = false;
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5000);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        int request = 2;
        AllocateResponse ar = null;
        try {
            ar = am.allocate("h1", 1000, request, new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationMasterNotRegisteredException e) {
            // empty catch block
        }
        nm1.nodeHeartbeat(true);
        AllocateResponse amrs = null;
        try {
            amrs = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationMasterNotRegisteredException e) {
            // empty catch block
        }
        am.registerAppAttempt();
        try {
            am.registerAppAttempt(false);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)("Application Master is already registered : " + attempt.getAppAttemptId().getApplicationId()), (Object)e.getMessage());
        }
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        try {
            amrs = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationAttemptNotFoundException e) {
            // empty catch block
        }
    }

    private static final class MyContainerManagerImpl
    implements ContainerManagementProtocol {
        boolean launched = false;
        boolean cleanedup = false;
        String attemptIdAtContainerManager = null;
        String containerIdAtContainerManager = null;
        String nmHostAtContainerManager = null;
        long submitTimeAtContainerManager;
        int maxAppAttempts;

        private MyContainerManagerImpl() {
        }

        public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException {
            StartContainerRequest request = (StartContainerRequest)requests.getStartContainerRequests().get(0);
            LOG.info((Object)("Container started by MyContainerManager: " + request));
            this.launched = true;
            Map env = request.getContainerLaunchContext().getEnvironment();
            Token containerToken = request.getContainerToken();
            ContainerTokenIdentifier tokenId = null;
            try {
                tokenId = BuilderUtils.newContainerTokenIdentifier((Token)containerToken);
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
            ContainerId containerId = tokenId.getContainerID();
            this.containerIdAtContainerManager = containerId.toString();
            this.attemptIdAtContainerManager = containerId.getApplicationAttemptId().toString();
            this.nmHostAtContainerManager = tokenId.getNmHostAddress();
            this.submitTimeAtContainerManager = Long.parseLong((String)env.get("APP_SUBMIT_TIME_ENV"));
            this.maxAppAttempts = Integer.parseInt((String)env.get("MAX_APP_ATTEMPTS"));
            return StartContainersResponse.newInstance(new HashMap(), new ArrayList(), new HashMap());
        }

        public StopContainersResponse stopContainers(StopContainersRequest request) throws YarnException {
            LOG.info((Object)"Container cleaned up by MyContainerManager");
            this.cleanedup = true;
            return null;
        }

        public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException {
            return null;
        }
    }
}

