/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import net.java.dev.eval.Expression;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={CapacitySchedulerLeafQueueInfo.class})
public class CapacitySchedulerQueueInfo {
    @XmlTransient
    static final float EPSILON = 1.0E-8f;
    @XmlTransient
    protected String queuePath;
    protected float capacity;
    protected float usedCapacity;
    protected float maxCapacity;
    protected float absoluteCapacity;
    protected float absoluteMaxCapacity;
    protected float absoluteUsedCapacity;
    protected int numApplications;
    protected String queueName;
    protected String label;
    protected String labelPolicy;
    protected QueueState state;
    protected CapacitySchedulerQueueInfoList queues;
    protected ResourceInfo resourcesUsed;

    CapacitySchedulerQueueInfo() {
    }

    CapacitySchedulerQueueInfo(CSQueue q) {
        this.queuePath = q.getQueuePath();
        this.capacity = q.getCapacity() * 100.0f;
        this.usedCapacity = q.getUsedCapacity() * 100.0f;
        this.maxCapacity = q.getMaximumCapacity();
        if (this.maxCapacity < 1.0E-8f || this.maxCapacity > 1.0f) {
            this.maxCapacity = 1.0f;
        }
        this.maxCapacity *= 100.0f;
        this.absoluteCapacity = CapacitySchedulerQueueInfo.cap(q.getAbsoluteCapacity(), 0.0f, 1.0f) * 100.0f;
        this.absoluteMaxCapacity = CapacitySchedulerQueueInfo.cap(q.getAbsoluteMaximumCapacity(), 0.0f, 1.0f) * 100.0f;
        this.absoluteUsedCapacity = CapacitySchedulerQueueInfo.cap(q.getAbsoluteUsedCapacity(), 0.0f, 1.0f) * 100.0f;
        this.numApplications = q.getNumApplications();
        this.queueName = q.getQueueName();
        this.state = q.getState();
        this.resourcesUsed = new ResourceInfo(q.getUsedResources());
        Expression labelE = q.getLabel();
        this.label = labelE == null ? "NONE" : labelE.toString();
        this.labelPolicy = q.getLabelPolicy() == null ? Queue.QueueLabelPolicy.AND.name() : q.getLabelPolicy().name();
    }

    public float getCapacity() {
        return this.capacity;
    }

    public float getUsedCapacity() {
        return this.usedCapacity;
    }

    public float getMaxCapacity() {
        return this.maxCapacity;
    }

    public float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    public float getAbsoluteMaxCapacity() {
        return this.absoluteMaxCapacity;
    }

    public float getAbsoluteUsedCapacity() {
        return this.absoluteUsedCapacity;
    }

    public int getNumApplications() {
        return this.numApplications;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getQueueState() {
        return this.state.toString();
    }

    public String getQueuePath() {
        return this.queuePath;
    }

    public CapacitySchedulerQueueInfoList getQueues() {
        return this.queues;
    }

    public ResourceInfo getResourcesUsed() {
        return this.resourcesUsed;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelPolicy() {
        return this.labelPolicy;
    }

    static float cap(float val, float low, float hi) {
        return Math.min(Math.max(val, low), hi);
    }
}

