/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.List;
import net.java.dev.eval.Expression;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;

@InterfaceStability.Evolving
@InterfaceAudience.LimitedPrivate(value={"yarn"})
public interface Queue {
    public static final String LABEL_NONE = "NONE";

    public String getQueueName();

    public QueueMetrics getMetrics();

    public QueueInfo getQueueInfo(boolean var1, boolean var2);

    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation var1);

    public boolean hasAccess(QueueACL var1, UserGroupInformation var2);

    public ActiveUsersManager getActiveUsersManager();

    public void recoverContainer(Resource var1, SchedulerApplicationAttempt var2, RMContainer var3);

    public QueueLabelPolicy getLabelPolicy();

    public Expression getLabel();

    public static enum QueueLabelPolicy {
        PREFER_QUEUE("PREFER_QUEUE"),
        PREFER_APP("PREFER_APP"),
        AND("AND"),
        OR("OR");

        private final String policyName;

        private QueueLabelPolicy(String policyName) {
            this.policyName = policyName;
        }

        public String getLabelPolicyName() {
            return this.policyName;
        }
    }
}

