/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElectorService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class MockRM
extends ResourceManager {
    static final String ENABLE_WEBAPP = "mockrm.webapp.enabled";

    public MockRM() {
        this((Configuration)new YarnConfiguration());
    }

    public MockRM(Configuration conf) {
        this(conf, null);
    }

    public MockRM(Configuration conf, RMStateStore store) {
        this.init((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
        if (store != null) {
            this.setRMStateStore(store);
        }
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
    }

    public void waitForState(ApplicationId appId, RMAppState finalState) throws Exception {
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(appId);
        Assert.assertNotNull((String)"app shouldn't be null", (Object)app);
        int timeoutSecs = 0;
        while (!finalState.equals((Object)app.getState()) && timeoutSecs++ < 40) {
            System.out.println("App : " + appId + " State is : " + app.getState() + " Waiting for state : " + finalState);
            Thread.sleep(2000L);
        }
        System.out.println("App State is : " + app.getState());
        Assert.assertEquals((String)"App state is not correct (timedout)", (Object)finalState, (Object)app.getState());
    }

    public void waitForState(ApplicationAttemptId attemptId, RMAppAttemptState finalState) throws Exception {
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(attemptId.getApplicationId());
        Assert.assertNotNull((String)"app shouldn't be null", (Object)app);
        RMAppAttempt attempt = app.getRMAppAttempt(attemptId);
        int timeoutSecs = 0;
        while (!finalState.equals((Object)attempt.getAppAttemptState()) && timeoutSecs++ < 40) {
            System.out.println("AppAttempt : " + attemptId + " State is : " + attempt.getAppAttemptState() + " Waiting for state : " + finalState);
            Thread.sleep(1000L);
        }
        System.out.println("Attempt State is : " + attempt.getAppAttemptState());
        Assert.assertEquals((String)"Attempt state is not correct (timedout)", (Object)finalState, (Object)attempt.getAppAttemptState());
    }

    public void waitForContainerAllocated(MockNM nm, ContainerId containerId) throws Exception {
        int timeoutSecs = 0;
        while (this.getResourceScheduler().getRMContainer(containerId) == null && timeoutSecs++ < 40) {
            System.out.println("Waiting for" + containerId + " to be allocated.");
            nm.nodeHeartbeat(true);
            Thread.sleep(200L);
        }
    }

    public void waitForContainerToComplete(RMAppAttempt attempt, NMContainerStatus completedContainer) throws InterruptedException {
        while (true) {
            List containers = attempt.getJustFinishedContainers();
            System.out.println("Received completed containers " + containers);
            for (ContainerStatus container : containers) {
                if (!container.getContainerId().equals((Object)completedContainer.getContainerId())) continue;
                return;
            }
            Thread.sleep(200L);
        }
    }

    public MockAM waitForNewAMToLaunchAndRegister(ApplicationId appId, int attemptSize, MockNM nm) throws Exception {
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(appId);
        Assert.assertNotNull((Object)app);
        while (app.getAppAttempts().size() != attemptSize) {
            System.out.println("Application " + appId + " is waiting for AM to restart. Current has " + app.getAppAttempts().size() + " attempts.");
            Thread.sleep(200L);
        }
        return MockRM.launchAndRegisterAM(app, this, nm);
    }

    public void waitForState(MockNM nm, ContainerId containerId, RMContainerState containerState) throws Exception {
        RMContainer container = this.getResourceScheduler().getRMContainer(containerId);
        int timeoutSecs = 0;
        while (container == null && timeoutSecs++ < 100) {
            nm.nodeHeartbeat(true);
            container = this.getResourceScheduler().getRMContainer(containerId);
            System.out.println("Waiting for container " + containerId + " to be allocated.");
            Thread.sleep(100L);
        }
        Assert.assertNotNull((String)"Container shouldn't be null", (Object)container);
        timeoutSecs = 0;
        while (!containerState.equals((Object)container.getState()) && timeoutSecs++ < 40) {
            System.out.println("Container : " + containerId + " State is : " + container.getState() + " Waiting for state : " + containerState);
            nm.nodeHeartbeat(true);
            Thread.sleep(300L);
        }
        System.out.println("Container State is : " + container.getState());
        Assert.assertEquals((String)"Container state is not correct (timedout)", (Object)containerState, (Object)container.getState());
    }

    public GetNewApplicationResponse getNewAppId() throws Exception {
        ClientRMService client = this.getClientRMService();
        return client.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
    }

    public RMApp submitApp(int masterMemory) throws Exception {
        return this.submitApp(masterMemory, false);
    }

    public RMApp submitApp(int masterMemory, boolean unmanaged) throws Exception {
        return this.submitApp(masterMemory, "", UserGroupInformation.getCurrentUser().getShortUserName(), unmanaged);
    }

    public RMApp submitApp(int masterMemory, String name, String user) throws Exception {
        return this.submitApp(masterMemory, name, user, false);
    }

    public RMApp submitApp(int masterMemory, String name, String user, boolean unmanaged) throws Exception {
        return this.submitApp(masterMemory, name, user, null, unmanaged, null, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, false, null, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, String queue) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, false, queue, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, unmanaged, queue, maxAppAttempts, ts, null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, unmanaged, queue, maxAppAttempts, ts, appType, true);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType, boolean waitForAccepted) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, unmanaged, queue, maxAppAttempts, ts, appType, waitForAccepted, false);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType, boolean waitForAccepted, boolean keepContainers) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, unmanaged, queue, maxAppAttempts, ts, appType, waitForAccepted, keepContainers, false, null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType, boolean waitForAccepted, boolean keepContainers, boolean isAppIdProvided, ApplicationId applicationId) throws Exception {
        ApplicationId appId = isAppIdProvided ? applicationId : null;
        ClientRMService client = this.getClientRMService();
        if (!isAppIdProvided) {
            GetNewApplicationResponse resp = client.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
            appId = resp.getApplicationId();
        }
        SubmitApplicationRequest req = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        ApplicationSubmissionContext sub = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        sub.setKeepContainersAcrossApplicationAttempts(keepContainers);
        sub.setApplicationId(appId);
        sub.setApplicationName(name);
        sub.setMaxAppAttempts(maxAppAttempts);
        if (unmanaged) {
            sub.setUnmanagedAM(true);
        }
        if (queue != null) {
            sub.setQueue(queue);
        }
        sub.setApplicationType(appType);
        ContainerLaunchContext clc = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(masterMemory);
        capability.setVirtualCores(1);
        sub.setResource(capability);
        clc.setApplicationACLs(acls);
        if (ts != null && UserGroupInformation.isSecurityEnabled()) {
            DataOutputBuffer dob = new DataOutputBuffer();
            ts.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            clc.setTokens(securityTokens);
        }
        sub.setAMContainerSpec(clc);
        req.setApplicationSubmissionContext(sub);
        UserGroupInformation fakeUser = UserGroupInformation.createUserForTesting((String)user, (String[])new String[]{"someGroup"});
        PrivilegedAction<SubmitApplicationResponse> action = new PrivilegedAction<SubmitApplicationResponse>(){
            ApplicationClientProtocol client;
            SubmitApplicationRequest req;

            @Override
            public SubmitApplicationResponse run() {
                try {
                    return this.client.submitApplication(this.req);
                }
                catch (YarnException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }

            PrivilegedAction<SubmitApplicationResponse> setClientReq(ApplicationClientProtocol client, SubmitApplicationRequest req) {
                this.client = client;
                this.req = req;
                return this;
            }
        }.setClientReq((ApplicationClientProtocol)client, req);
        fakeUser.doAs(action);
        if (waitForAccepted) {
            this.waitForState(appId, RMAppState.ACCEPTED);
        }
        return (RMApp)this.getRMContext().getRMApps().get(appId);
    }

    public MockNM registerNode(String nodeIdStr, int memory) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, this.getResourceTrackerService());
        nm.registerNode();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory, int vCores) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, vCores, this.getResourceTrackerService());
        nm.registerNode();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory, int vCores, List<ApplicationId> runningApplications) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, vCores, this.getResourceTrackerService(), YarnVersionInfo.getVersion());
        nm.registerNode(runningApplications);
        return nm;
    }

    public void sendNodeStarted(MockNM nm) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        node.handle((RMNodeEvent)new RMNodeStartedEvent(nm.getNodeId(), null, null));
    }

    public void sendNodeLost(MockNM nm) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        node.handle(new RMNodeEvent(nm.getNodeId(), RMNodeEventType.EXPIRE));
    }

    public void NMwaitForState(NodeId nodeid, NodeState finalState) throws Exception {
        RMNode node = (RMNode)this.getRMContext().getRMNodes().get(nodeid);
        Assert.assertNotNull((String)"node shouldn't be null", (Object)node);
        int timeoutSecs = 0;
        while (!finalState.equals((Object)node.getState()) && timeoutSecs++ < 20) {
            System.out.println("Node State is : " + node.getState() + " Waiting for state : " + finalState);
            Thread.sleep(500L);
        }
        System.out.println("Node State is : " + node.getState());
        Assert.assertEquals((String)"Node state is not correct (timedout)", (Object)finalState, (Object)node.getState());
    }

    public KillApplicationResponse killApp(ApplicationId appId) throws Exception {
        ClientRMService client = this.getClientRMService();
        KillApplicationRequest req = KillApplicationRequest.newInstance((ApplicationId)appId);
        return client.forceKillApplication(req);
    }

    public MockAM sendAMLaunched(ApplicationAttemptId appAttemptId) throws Exception {
        MockAM am = new MockAM(this.getRMContext(), (ApplicationMasterProtocol)this.masterService, appAttemptId);
        am.waitForState(RMAppAttemptState.ALLOCATED);
        this.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.LAUNCHED));
        return am;
    }

    public void sendAMLaunchFailed(ApplicationAttemptId appAttemptId) throws Exception {
        MockAM am = new MockAM(this.getRMContext(), (ApplicationMasterProtocol)this.masterService, appAttemptId);
        am.waitForState(RMAppAttemptState.ALLOCATED);
        this.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptLaunchFailedEvent(appAttemptId, "Failed"));
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService(this.getRMContext(), (YarnScheduler)this.getResourceScheduler(), this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager()){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ResourceTrackerService createResourceTrackerService() {
        Configuration conf = new Configuration();
        RMContainerTokenSecretManager containerTokenSecretManager = this.getRMContext().getContainerTokenSecretManager();
        containerTokenSecretManager.rollMasterKey();
        NMTokenSecretManagerInRM nmTokenSecretManager = this.getRMContext().getNMTokenSecretManager();
        nmTokenSecretManager.rollMasterKey();
        return new ResourceTrackerService(this.getRMContext(), this.nodesListManager, this.nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ApplicationMasterService createApplicationMasterService() {
        return new ApplicationMasterService(this.getRMContext(), (YarnScheduler)this.scheduler){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.getRMContext()){

            protected void serviceStart() {
            }

            public void handle(AMLauncherEvent appEvent) {
            }

            protected void serviceStop() {
            }
        };
    }

    protected AdminService createAdminService() {
        return new AdminService(this, this.getRMContext()){

            protected void startServer() {
            }

            protected void stopServer() {
            }

            protected EmbeddedElectorService createEmbeddedElectorService() {
                return null;
            }
        };
    }

    public NodesListManager getNodesListManager() {
        return this.nodesListManager;
    }

    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.getRMContext().getClientToAMTokenSecretManager();
    }

    public RMAppManager getRMAppManager() {
        return this.rmAppManager;
    }

    protected void startWepApp() {
        if (this.getConfig().getBoolean(ENABLE_WEBAPP, false)) {
            super.startWepApp();
            return;
        }
    }

    public static void finishAMAndVerifyAppState(RMApp rmApp, MockRM rm, MockNM nm, MockAM am) throws Exception {
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (String)"", (String)"");
        am.unregisterAppAttempt(req, true);
        am.waitForState(RMAppAttemptState.FINISHING);
        nm.nodeHeartbeat(am.getApplicationAttemptId(), 1, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        rm.waitForState(rmApp.getApplicationId(), RMAppState.FINISHED);
    }

    public static MockAM launchAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        rm.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        System.out.println("Launch AM " + attempt.getAppAttemptId());
        nm.nodeHeartbeat(true);
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.LAUNCHED);
        return am;
    }

    public static MockAM launchAndRegisterAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        MockAM am = MockRM.launchAM(app, rm, nm);
        am.registerAppAttempt();
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        return am;
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        ClientRMService client = this.getClientRMService();
        GetApplicationReportResponse response = client.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId));
        return response.getApplicationReport();
    }

    public void clearQueueMetrics(RMApp app) {
        ((SchedulerApplication)((AbstractYarnScheduler)this.getResourceScheduler()).getSchedulerApplications().get(app.getApplicationId())).getQueue().getMetrics();
        QueueMetrics.clearQueueMetrics();
    }

    public ResourceManager.RMActiveServices getRMActiveService() {
        return this.activeServices;
    }
}

