/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.Collection;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;

/*
 * Exception performing whole class analysis ignored.
 */
public class ComputeFairShares {
    private static final int COMPUTE_FAIR_SHARES_ITERATIONS = 25;

    public static void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources, ResourceType type) {
        if (schedulables.isEmpty()) {
            return;
        }
        int totalMaxShare = 0;
        for (Schedulable schedulable : schedulables) {
            int maxShare = ComputeFairShares.getResourceValue((Resource)schedulable.getMaxShare(), (ResourceType)type);
            if (maxShare == Integer.MAX_VALUE) {
                totalMaxShare = Integer.MAX_VALUE;
                break;
            }
            totalMaxShare += maxShare;
        }
        int totalResource = Math.min(totalMaxShare, ComputeFairShares.getResourceValue((Resource)totalResources, (ResourceType)type));
        double d = 1.0;
        while (ComputeFairShares.resourceUsedWithWeightToResourceRatio((double)d, schedulables, (ResourceType)type) < totalResource) {
            d *= 2.0;
        }
        double left = 0.0;
        double right = d;
        for (int i = 0; i < 25; ++i) {
            double d2 = (left + right) / 2.0;
            int plannedResourceUsed = ComputeFairShares.resourceUsedWithWeightToResourceRatio((double)d2, schedulables, (ResourceType)type);
            if (plannedResourceUsed == totalResource) {
                right = d2;
                break;
            }
            if (plannedResourceUsed < totalResource) {
                left = d2;
                continue;
            }
            right = d2;
        }
        for (Schedulable schedulable : schedulables) {
            ComputeFairShares.setResourceValue((int)ComputeFairShares.computeShare((Schedulable)schedulable, (double)right, (ResourceType)type), (Resource)schedulable.getFairShare(), (ResourceType)type);
        }
    }

    private static int resourceUsedWithWeightToResourceRatio(double w2rRatio, Collection<? extends Schedulable> schedulables, ResourceType type) {
        int resourcesTaken = 0;
        for (Schedulable schedulable : schedulables) {
            int share = ComputeFairShares.computeShare((Schedulable)schedulable, (double)w2rRatio, (ResourceType)type);
            resourcesTaken += share;
        }
        return resourcesTaken;
    }

    private static int computeShare(Schedulable sched, double w2rRatio, ResourceType type) {
        double share = (double)sched.getWeights().getWeight(type) * w2rRatio;
        share = Math.max(share, (double)ComputeFairShares.getResourceValue((Resource)sched.getMinShare(), (ResourceType)type));
        share = Math.min(share, (double)ComputeFairShares.getResourceValue((Resource)sched.getMaxShare(), (ResourceType)type));
        return (int)share;
    }

    private static int getResourceValue(Resource resource, ResourceType type) {
        switch (1.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$resource$ResourceType[type.ordinal()]) {
            case 1: {
                return resource.getMemory();
            }
            case 2: {
                return resource.getVirtualCores();
            }
            case 3: {
                return (int)Math.round(resource.getDisks());
            }
        }
        throw new IllegalArgumentException("Invalid resource");
    }

    private static void setResourceValue(int val, Resource resource, ResourceType type) {
        switch (1.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$resource$ResourceType[type.ordinal()]) {
            case 1: {
                resource.setMemory(val);
                break;
            }
            case 2: {
                resource.setVirtualCores(val);
                break;
            }
            case 3: {
                resource.setDisks((double)val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid resource");
            }
        }
    }
}

