/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSSchedulerApp
extends SchedulerApplicationAttempt {
    private static final Log LOG = LogFactory.getLog(FSSchedulerApp.class);
    private AppSchedulable appSchedulable;
    final Map<RMContainer, Long> preemptionMap = new HashMap();
    final Set<RMContainer> noneligibleForPreemptionSet = new HashSet();
    private Resource preemptedResources = Resources.createResource((int)0);
    final Map<Priority, NodeType> allowedLocalityLevel = new HashMap();

    public FSSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, FSLeafQueue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        super(applicationAttemptId, user, (Queue)queue, activeUsersManager, rmContext);
    }

    public void setAppSchedulable(AppSchedulable appSchedulable) {
        this.appSchedulable = appSchedulable;
    }

    public AppSchedulable getAppSchedulable() {
        return this.appSchedulable;
    }

    public synchronized void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        this.newlyAllocatedContainers.remove(rmContainer);
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
        LOG.info((Object)("Completed container: " + rmContainer.getContainerId() + " in state: " + rmContainer.getState() + " event:" + event));
        this.liveContainers.remove(rmContainer.getContainerId());
        RMAuditLogger.logSuccess((String)this.getUser(), (String)"AM Released Container", (String)"SchedulerApp", (ApplicationId)this.getApplicationId(), (ContainerId)containerId);
        Resource containerResource = rmContainer.getContainer().getResource();
        this.queue.getMetrics().releaseResources(this.getUser(), 1, containerResource);
        Resources.subtractFrom((Resource)this.currentConsumption, (Resource)containerResource);
        this.preemptionMap.remove(rmContainer);
    }

    public synchronized void unreserve(FSSchedulerNode node, Priority priority) {
        Map reservedContainers = (Map)this.reservedContainers.get(priority);
        RMContainer reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID());
        if (reservedContainers.isEmpty()) {
            this.reservedContainers.remove(priority);
        }
        this.resetReReservations(priority);
        Resource resource = reservedContainer.getContainer().getResource();
        Resources.subtractFrom((Resource)this.currentReservation, (Resource)resource);
        LOG.info((Object)("Application " + this.getApplicationId() + " unreserved " + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation));
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    public synchronized NodeType getAllowedLocalityLevel(Priority priority, int numNodes, double nodeLocalityThreshold, double rackLocalityThreshold) {
        double threshold;
        if (nodeLocalityThreshold > 1.0) {
            nodeLocalityThreshold = 1.0;
        }
        if (rackLocalityThreshold > 1.0) {
            rackLocalityThreshold = 1.0;
        }
        if (nodeLocalityThreshold < 0.0 || rackLocalityThreshold < 0.0) {
            return NodeType.OFF_SWITCH;
        }
        if (!this.allowedLocalityLevel.containsKey(priority)) {
            this.allowedLocalityLevel.put(priority, NodeType.NODE_LOCAL);
            return NodeType.NODE_LOCAL;
        }
        NodeType allowed = (NodeType)this.allowedLocalityLevel.get(priority);
        if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
            return NodeType.OFF_SWITCH;
        }
        double d = threshold = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityThreshold : rackLocalityThreshold;
        if ((double)this.getSchedulingOpportunities(priority) > (double)numNodes * threshold) {
            if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.RACK_LOCAL);
                this.resetSchedulingOpportunities(priority);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.OFF_SWITCH);
                this.resetSchedulingOpportunities(priority);
            }
        }
        return (NodeType)this.allowedLocalityLevel.get(priority);
    }

    public synchronized NodeType getAllowedLocalityLevelByTime(Priority priority, long nodeLocalityDelayMs, long rackLocalityDelayMs, long currentTimeMs) {
        long thresholdTime;
        if (nodeLocalityDelayMs < 0L || rackLocalityDelayMs < 0L) {
            return NodeType.OFF_SWITCH;
        }
        if (!this.allowedLocalityLevel.containsKey(priority)) {
            this.allowedLocalityLevel.put(priority, NodeType.NODE_LOCAL);
            return NodeType.NODE_LOCAL;
        }
        NodeType allowed = (NodeType)this.allowedLocalityLevel.get(priority);
        if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
            return NodeType.OFF_SWITCH;
        }
        long waitTime = currentTimeMs;
        waitTime = this.lastScheduledContainer.containsKey(priority) ? (waitTime -= ((Long)this.lastScheduledContainer.get(priority)).longValue()) : (waitTime -= this.appSchedulable.getStartTime());
        long l = thresholdTime = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityDelayMs : rackLocalityDelayMs;
        if (waitTime > thresholdTime) {
            if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.RACK_LOCAL);
                this.resetSchedulingOpportunities(priority, currentTimeMs);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.OFF_SWITCH);
                this.resetSchedulingOpportunities(priority, currentTimeMs);
            }
        }
        return (NodeType)this.allowedLocalityLevel.get(priority);
    }

    public synchronized RMContainer allocate(NodeType type, FSSchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        NodeType allowed = (NodeType)this.allowedLocalityLevel.get(priority);
        if (allowed != null) {
            if (allowed.equals((Object)NodeType.OFF_SWITCH) && (type.equals((Object)NodeType.NODE_LOCAL) || type.equals((Object)NodeType.RACK_LOCAL))) {
                this.resetAllowedLocalityLevel(priority, type);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL) && type.equals((Object)NodeType.NODE_LOCAL)) {
                this.resetAllowedLocalityLevel(priority, type);
            }
        }
        if (this.getTotalRequiredResources(priority) <= 0) {
            return null;
        }
        RMContainerImpl rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext);
        this.newlyAllocatedContainers.add(rmContainer);
        this.liveContainers.put(container.getId(), rmContainer);
        List resourceRequestList = this.appSchedulingInfo.allocate(type, (SchedulerNode)node, priority, request, container);
        Resources.addTo((Resource)this.currentConsumption, (Resource)container.getResource());
        rmContainer.setResourceRequests(resourceRequestList);
        rmContainer.handle((Event)new RMContainerEvent(container.getId(), RMContainerEventType.START));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationAttemptId=" + container.getId().getApplicationAttemptId() + " container=" + container.getId() + " host=" + container.getNodeId().getHost() + " type=" + type));
        }
        RMAuditLogger.logSuccess((String)this.getUser(), (String)"AM Allocated Container", (String)"SchedulerApp", (ApplicationId)this.getApplicationId(), (ContainerId)container.getId());
        return rmContainer;
    }

    public synchronized void resetAllowedLocalityLevel(Priority priority, NodeType level) {
        NodeType old = (NodeType)this.allowedLocalityLevel.get(priority);
        LOG.info((Object)("Raising locality level from " + old + " to " + level + " at " + " priority " + priority));
        this.allowedLocalityLevel.put(priority, level);
    }

    public void addPreemption(RMContainer container, long time) {
        assert (this.preemptionMap.get(container) == null);
        this.preemptionMap.put(container, time);
        Resources.addTo((Resource)this.preemptedResources, (Resource)container.getAllocatedResource());
    }

    public void addNonEligibleForPreemption(RMContainer container) {
        this.noneligibleForPreemptionSet.add(container);
    }

    public Set<RMContainer> getNonEligibleForPreemptionSet() {
        return this.noneligibleForPreemptionSet;
    }

    public void resetNonEligibleForPreemptionSet() {
        this.noneligibleForPreemptionSet.clear();
    }

    public Long getContainerPreemptionTime(RMContainer container) {
        return (Long)this.preemptionMap.get(container);
    }

    public Set<RMContainer> getPreemptionContainers() {
        return this.preemptionMap.keySet();
    }

    public FSLeafQueue getQueue() {
        return (FSLeafQueue)super.getQueue();
    }

    public Resource getPreemptedResources() {
        return this.preemptedResources;
    }

    public void resetPreemptedResources() {
        this.preemptedResources = Resources.createResource((int)0);
        for (RMContainer container : this.getPreemptionContainers()) {
            Resources.addTo((Resource)this.preemptedResources, (Resource)container.getAllocatedResource());
        }
    }

    public void clearPreemptedResources() {
        this.preemptedResources.setMemory(0);
        this.preemptedResources.setVirtualCores(0);
    }
}

