/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMZKUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMStateVersion;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.EpochPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.RMStateVersionPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ZKRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(ZKRMStateStore.class);
    private final SecureRandom random = new SecureRandom();
    protected static final String ROOT_ZNODE_NAME = "ZKRMStateRoot";
    protected static final RMStateVersion CURRENT_VERSION_INFO = RMStateVersion.newInstance((int)1, (int)1);
    private static final String RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME = "RMDelegationTokensRoot";
    private static final String RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME = "RMDTSequentialNumber";
    private static final String RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME = "RMDTMasterKeysRoot";
    private int numRetries;
    private String zkHostPort = null;
    private int zkSessionTimeout;
    @VisibleForTesting
    long zkRetryInterval;
    private List<ACL> zkAcl;
    private List<ZKUtil.ZKAuthInfo> zkAuths;
    private String zkRootNodePath;
    private String rmAppRoot;
    private String rmDTSecretManagerRoot;
    private String dtMasterKeysRootPath;
    private String delegationTokensRootPath;
    private String dtSequenceNumberPath;
    @VisibleForTesting
    protected String znodeWorkingPath;
    @VisibleForTesting
    protected ZooKeeper zkClient;
    private ZooKeeper oldZkClient;
    private static final String FENCING_LOCK = "RM_ZK_FENCING_LOCK";
    private String fencingNodePath;
    private Op createFencingNodePathOp;
    private Op deleteFencingNodePathOp;
    private Thread verifyActiveStatusThread;
    private String zkRootNodeUsername;
    private final String zkRootNodePassword = Long.toString(this.random.nextLong());
    @VisibleForTesting
    List<ACL> zkRootNodeAcl;
    private boolean useDefaultFencingScheme = false;
    public static final int CREATE_DELETE_PERMS = 12;
    private final String zkRootNodeAuthScheme = new DigestAuthenticationProvider().getScheme();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    protected List<ACL> constructZkRootNodeACL(Configuration conf, List<ACL> sourceACLs) throws NoSuchAlgorithmException {
        ArrayList<ACL> zkRootNodeAcl = new ArrayList<ACL>();
        for (ACL acl : sourceACLs) {
            zkRootNodeAcl.add(new ACL(ZKUtil.removeSpecificPerms((int)acl.getPerms(), (int)12), acl.getId()));
        }
        this.zkRootNodeUsername = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.address", (String)"0.0.0.0:8032", (Configuration)conf);
        Id rmId = new Id(this.zkRootNodeAuthScheme, DigestAuthenticationProvider.generateDigest((String)(this.zkRootNodeUsername + ":" + this.zkRootNodePassword)));
        zkRootNodeAcl.add(new ACL(12, rmId));
        return zkRootNodeAcl;
    }

    public synchronized void initInternal(Configuration conf) throws Exception {
        this.zkHostPort = conf.get("yarn.resourcemanager.zk-address");
        if (this.zkHostPort == null) {
            throw new YarnRuntimeException("No server address specified for zookeeper state store for Resource Manager recovery. yarn.resourcemanager.zk-address is not configured.");
        }
        this.numRetries = conf.getInt("yarn.resourcemanager.zk-num-retries", 1000);
        this.znodeWorkingPath = conf.get("yarn.resourcemanager.zk-state-store.parent-path", "/rmstore");
        this.zkSessionTimeout = conf.getInt("yarn.resourcemanager.zk-timeout-ms", 10000);
        this.zkRetryInterval = HAUtil.isHAEnabled((Configuration)conf) ? (long)(this.zkSessionTimeout / this.numRetries) : conf.getLong("yarn.resourcemanager.zk-retry-interval-ms", 1000L);
        this.zkAcl = RMZKUtils.getZKAcls((Configuration)conf);
        this.zkAuths = RMZKUtils.getZKAuths((Configuration)conf);
        this.zkRootNodePath = this.getNodePath(this.znodeWorkingPath, ROOT_ZNODE_NAME);
        this.rmAppRoot = this.getNodePath(this.zkRootNodePath, "RMAppRoot");
        this.fencingNodePath = this.getNodePath(this.zkRootNodePath, FENCING_LOCK);
        this.createFencingNodePathOp = Op.create((String)this.fencingNodePath, (byte[])new byte[0], (List)this.zkAcl, (CreateMode)CreateMode.PERSISTENT);
        this.deleteFencingNodePathOp = Op.delete((String)this.fencingNodePath, (int)-1);
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            String zkRootNodeAclConf = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.zk-state-store.root-node.acl", (Configuration)conf);
            if (zkRootNodeAclConf != null) {
                zkRootNodeAclConf = ZKUtil.resolveConfIndirection((String)zkRootNodeAclConf);
                try {
                    this.zkRootNodeAcl = ZKUtil.parseACLs((String)zkRootNodeAclConf);
                }
                catch (ZKUtil.BadAclFormatException bafe) {
                    LOG.error((Object)"Invalid format for yarn.resourcemanager.zk-state-store.root-node.acl");
                    throw bafe;
                }
            } else {
                this.useDefaultFencingScheme = true;
                this.zkRootNodeAcl = this.constructZkRootNodeACL(conf, this.zkAcl);
            }
        }
        this.rmDTSecretManagerRoot = this.getNodePath(this.zkRootNodePath, "RMDTSecretManagerRoot");
        this.dtMasterKeysRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME);
        this.delegationTokensRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME);
        this.dtSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME);
    }

    public synchronized void startInternal() throws Exception {
        this.createConnection();
        this.createRootDir(this.znodeWorkingPath);
        this.createRootDir(this.zkRootNodePath);
        if (HAUtil.isHAEnabled((Configuration)this.getConfig())) {
            this.fence();
            this.verifyActiveStatusThread = new VerifyActiveStatusThread(this);
            this.verifyActiveStatusThread.start();
        }
        this.createRootDir(this.rmAppRoot);
        this.createRootDir(this.rmDTSecretManagerRoot);
        this.createRootDir(this.dtMasterKeysRootPath);
        this.createRootDir(this.delegationTokensRootPath);
        this.createRootDir(this.dtSequenceNumberPath);
    }

    private void createRootDir(String rootPath) throws Exception {
        new /* Unavailable Anonymous Inner Class!! */.runWithRetries();
    }

    private void logRootNodeAcls(String prefix) throws Exception {
        Stat getStat = new Stat();
        List getAcls = this.getACLWithRetries(this.zkRootNodePath, getStat);
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        for (ACL acl : getAcls) {
            builder.append(acl.toString());
        }
        builder.append(getStat.toString());
        LOG.debug((Object)builder.toString());
    }

    private synchronized void fence() throws Exception {
        if (LOG.isTraceEnabled()) {
            this.logRootNodeAcls("Before fencing\n");
        }
        new /* Unavailable Anonymous Inner Class!! */.runWithRetries();
        new /* Unavailable Anonymous Inner Class!! */.runWithRetries();
        if (LOG.isTraceEnabled()) {
            this.logRootNodeAcls("After fencing\n");
        }
    }

    private synchronized void closeZkClients() throws IOException {
        if (this.zkClient != null) {
            try {
                this.zkClient.close();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing ZK", e);
            }
            this.zkClient = null;
        }
        if (this.oldZkClient != null) {
            try {
                this.oldZkClient.close();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing old ZK", e);
            }
            this.oldZkClient = null;
        }
    }

    protected synchronized void closeInternal() throws Exception {
        if (this.verifyActiveStatusThread != null) {
            this.verifyActiveStatusThread.interrupt();
            this.verifyActiveStatusThread.join(1000L);
        }
        this.closeZkClients();
    }

    protected RMStateVersion getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    protected synchronized void storeVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        byte[] data = ((RMStateVersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.existsWithRetries(versionNodePath, true) != null) {
            this.setDataWithRetries(versionNodePath, data, -1);
        } else {
            this.createWithRetries(versionNodePath, data, this.zkAcl, CreateMode.PERSISTENT);
        }
    }

    protected synchronized RMStateVersion loadVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        if (this.existsWithRetries(versionNodePath, true) != null) {
            byte[] data = this.getDataWithRetries(versionNodePath, true);
            RMStateVersionPBImpl version = new RMStateVersionPBImpl(YarnServerResourceManagerServiceProtos.RMStateVersionProto.parseFrom((byte[])data));
            return version;
        }
        return null;
    }

    public synchronized int getAndIncrementEpoch() throws Exception {
        String epochNodePath = this.getNodePath(this.zkRootNodePath, "EpochNode");
        int currentEpoch = 0;
        if (this.existsWithRetries(epochNodePath, true) != null) {
            byte[] data = this.getDataWithRetries(epochNodePath, true);
            EpochPBImpl epoch = new EpochPBImpl(YarnServerResourceManagerServiceProtos.EpochProto.parseFrom((byte[])data));
            currentEpoch = epoch.getEpoch();
            byte[] storeData = Epoch.newInstance((int)(currentEpoch + 1)).getProto().toByteArray();
            this.setDataWithRetries(epochNodePath, storeData, -1);
        } else {
            byte[] storeData = Epoch.newInstance((int)(currentEpoch + 1)).getProto().toByteArray();
            this.createWithRetries(epochNodePath, storeData, this.zkAcl, CreateMode.PERSISTENT);
        }
        return currentEpoch;
    }

    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        return rmState;
    }

    private synchronized void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        this.loadRMDelegationKeyState(rmState);
        this.loadRMSequentialNumberState(rmState);
        this.loadRMDelegationTokenState(rmState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDelegationKeyState(RMStateStore.RMState rmState) throws Exception {
        List childNodes = this.getChildrenWithRetries(this.dtMasterKeysRootPath, true);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.dtMasterKeysRootPath, childNodeName);
            byte[] childData = this.getDataWithRetries(childNodePath, true);
            if (childData == null) {
                LOG.warn((Object)("Content of " + childNodePath + " is broken."));
                continue;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            try {
                if (!childNodeName.startsWith("DelegationKey_")) continue;
                DelegationKey key = new DelegationKey();
                key.readFields((DataInput)fsIn);
                rmState.rmSecretManagerState.masterKeyState.add(key);
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMSequentialNumberState(RMStateStore.RMState rmState) throws Exception {
        byte[] seqData = this.getDataWithRetries(this.dtSequenceNumberPath, false);
        if (seqData != null) {
            ByteArrayInputStream seqIs = new ByteArrayInputStream(seqData);
            DataInputStream seqIn = new DataInputStream(seqIs);
            try {
                rmState.rmSecretManagerState.dtSequenceNumber = seqIn.readInt();
            }
            finally {
                seqIn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDelegationTokenState(RMStateStore.RMState rmState) throws Exception {
        List childNodes = this.getChildrenWithRetries(this.delegationTokensRootPath, true);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.delegationTokensRootPath, childNodeName);
            byte[] childData = this.getDataWithRetries(childNodePath, true);
            if (childData == null) {
                LOG.warn((Object)("Content of " + childNodePath + " is broken."));
                continue;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            try {
                if (!childNodeName.startsWith("RMDelegationToken_")) continue;
                RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier();
                identifier.readFields((DataInput)fsIn);
                long renewDate = fsIn.readLong();
                rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
            }
            finally {
                is.close();
            }
        }
    }

    private synchronized void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        List childNodes = this.getChildrenWithRetries(this.rmAppRoot, true);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.rmAppRoot, childNodeName);
            byte[] childData = this.getDataWithRetries(childNodePath, true);
            if (childNodeName.startsWith("application_")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading application from znode: " + childNodeName));
                }
                ApplicationId appId = ConverterUtils.toApplicationId((String)childNodeName);
                ApplicationStateDataPBImpl appStateData = new ApplicationStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationStateDataProto.parseFrom((byte[])childData));
                RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getStartTime(), appStateData.getApplicationSubmissionContext(), appStateData.getUser(), appStateData.getState(), appStateData.getDiagnostics(), appStateData.getFinishTime());
                if (!appId.equals((Object)appState.context.getApplicationId())) {
                    throw new YarnRuntimeException("The child node name is different from the application id");
                }
                rmState.appState.put(appId, appState);
                this.loadApplicationAttemptState(appState, appId);
                continue;
            }
            LOG.info((Object)("Unknown child node with name: " + childNodeName));
        }
    }

    private void loadApplicationAttemptState(RMStateStore.ApplicationState appState, ApplicationId appId) throws Exception {
        String appPath = this.getNodePath(this.rmAppRoot, appId.toString());
        List attempts = this.getChildrenWithRetries(appPath, false);
        for (String attemptIDStr : attempts) {
            if (!attemptIDStr.startsWith("appattempt_")) continue;
            String attemptPath = this.getNodePath(appPath, attemptIDStr);
            byte[] attemptData = this.getDataWithRetries(attemptPath, true);
            ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)attemptIDStr);
            ApplicationAttemptStateDataPBImpl attemptStateData = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto.parseFrom((byte[])attemptData));
            Credentials credentials = null;
            if (attemptStateData.getAppAttemptTokens() != null) {
                credentials = new Credentials();
                DataInputByteBuffer dibb = new DataInputByteBuffer();
                dibb.reset(new ByteBuffer[]{attemptStateData.getAppAttemptTokens()});
                credentials.readTokenStorageStream((DataInputStream)dibb);
            }
            RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(attemptId, attemptStateData.getMasterContainer(), credentials, attemptStateData.getStartTime(), attemptStateData.getState(), attemptStateData.getFinalTrackingUrl(), attemptStateData.getDiagnostics(), attemptStateData.getFinalApplicationStatus(), attemptStateData.getAMContainerExitStatus());
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        LOG.debug((Object)"Done Loading applications from ZK state store");
    }

    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        String nodeCreatePath = this.getNodePath(this.rmAppRoot, appId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing info for app: " + appId + " at: " + nodeCreatePath));
        }
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        this.createWithRetries(nodeCreatePath, appStateData, this.zkAcl, CreateMode.PERSISTENT);
    }

    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        String nodeUpdatePath = this.getNodePath(this.rmAppRoot, appId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing final state info for app: " + appId + " at: " + nodeUpdatePath));
        }
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        if (this.existsWithRetries(nodeUpdatePath, true) != null) {
            this.setDataWithRetries(nodeUpdatePath, appStateData, -1);
        } else {
            this.createWithRetries(nodeUpdatePath, appStateData, this.zkAcl, CreateMode.PERSISTENT);
            LOG.debug((Object)(appId + " znode didn't exist. Created a new znode to" + " update the application state."));
        }
    }

    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        String appDirPath = this.getNodePath(this.rmAppRoot, appAttemptId.getApplicationId().toString());
        String nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing info for attempt: " + appAttemptId + " at: " + nodeCreatePath));
        }
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        this.createWithRetries(nodeCreatePath, attemptStateData, this.zkAcl, CreateMode.PERSISTENT);
    }

    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        String appIdStr = appAttemptId.getApplicationId().toString();
        String appAttemptIdStr = appAttemptId.toString();
        String appDirPath = this.getNodePath(this.rmAppRoot, appIdStr);
        String nodeUpdatePath = this.getNodePath(appDirPath, appAttemptIdStr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing final state info for attempt: " + appAttemptIdStr + " at: " + nodeUpdatePath));
        }
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        if (this.existsWithRetries(nodeUpdatePath, true) != null) {
            this.setDataWithRetries(nodeUpdatePath, attemptStateData, -1);
        } else {
            this.createWithRetries(nodeUpdatePath, attemptStateData, this.zkAcl, CreateMode.PERSISTENT);
            LOG.debug((Object)(appAttemptId + " znode didn't exist. Created a new znode to" + " update the application attempt state."));
        }
    }

    public synchronized void removeApplicationStateInternal(RMStateStore.ApplicationState appState) throws Exception {
        String appId = appState.getAppId().toString();
        String appIdRemovePath = this.getNodePath(this.rmAppRoot, appId);
        ArrayList<Op> opList = new ArrayList<Op>();
        for (ApplicationAttemptId attemptId : appState.attempts.keySet()) {
            String attemptRemovePath = this.getNodePath(appIdRemovePath, attemptId.toString());
            opList.add(Op.delete((String)attemptRemovePath, (int)-1));
        }
        opList.add(Op.delete((String)appIdRemovePath, (int)-1));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing info for app: " + appId + " at: " + appIdRemovePath + " and its attempts."));
        }
        this.doMultiWithRetries(opList);
    }

    protected synchronized void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) throws Exception {
        ArrayList opList = new ArrayList();
        this.addStoreOrUpdateOps(opList, rmDTIdentifier, renewDate, latestSequenceNumber, false);
        this.doMultiWithRetries(opList);
    }

    protected synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
        ArrayList<Op> opList = new ArrayList<Op>();
        String nodeRemovePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing RMDelegationToken_" + rmDTIdentifier.getSequenceNumber()));
        }
        if (this.existsWithRetries(nodeRemovePath, true) != null) {
            opList.add(Op.delete((String)nodeRemovePath, (int)-1));
        } else {
            LOG.debug((Object)("Attempted to delete a non-existing znode " + nodeRemovePath));
        }
        this.doMultiWithRetries(opList);
    }

    protected void updateRMDelegationTokenAndSequenceNumberInternal(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) throws Exception {
        ArrayList opList = new ArrayList();
        String nodeRemovePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        if (this.existsWithRetries(nodeRemovePath, true) == null) {
            this.addStoreOrUpdateOps(opList, rmDTIdentifier, renewDate, latestSequenceNumber, false);
            LOG.debug((Object)("Attempted to update a non-existing znode " + nodeRemovePath));
        } else {
            this.addStoreOrUpdateOps(opList, rmDTIdentifier, renewDate, latestSequenceNumber, true);
        }
        this.doMultiWithRetries(opList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStoreOrUpdateOps(ArrayList<Op> opList, RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber, boolean isUpdate) throws Exception {
        String nodeCreatePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        ByteArrayOutputStream tokenOs = new ByteArrayOutputStream();
        DataOutputStream tokenOut = new DataOutputStream(tokenOs);
        ByteArrayOutputStream seqOs = new ByteArrayOutputStream();
        DataOutputStream seqOut = new DataOutputStream(seqOs);
        try {
            rmDTIdentifier.write((DataOutput)tokenOut);
            tokenOut.writeLong(renewDate);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)((isUpdate ? "Storing " : "Updating ") + "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber()));
            }
            if (isUpdate) {
                opList.add(Op.setData((String)nodeCreatePath, (byte[])tokenOs.toByteArray(), (int)-1));
            } else {
                opList.add(Op.create((String)nodeCreatePath, (byte[])tokenOs.toByteArray(), (List)this.zkAcl, (CreateMode)CreateMode.PERSISTENT));
            }
            seqOut.writeInt(latestSequenceNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)((isUpdate ? "Storing " : "Updating ") + this.dtSequenceNumberPath + ". SequenceNumber: " + latestSequenceNumber));
            }
            opList.add(Op.setData((String)this.dtSequenceNumberPath, (byte[])seqOs.toByteArray(), (int)-1));
        }
        finally {
            tokenOs.close();
            seqOs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void storeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeCreatePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream fsOut = new DataOutputStream(os);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing RMDelegationKey_" + delegationKey.getKeyId()));
        }
        delegationKey.write((DataOutput)fsOut);
        try {
            this.createWithRetries(nodeCreatePath, os.toByteArray(), this.zkAcl, CreateMode.PERSISTENT);
        }
        finally {
            os.close();
        }
    }

    protected synchronized void removeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeRemovePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing RMDelegationKey_" + delegationKey.getKeyId()));
        }
        if (this.existsWithRetries(nodeRemovePath, true) != null) {
            this.doMultiWithRetries(Op.delete((String)nodeRemovePath, (int)-1));
        } else {
            LOG.debug((Object)("Attempted to delete a non-existing znode " + nodeRemovePath));
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public synchronized void processWatchEvent(WatchedEvent event) throws Exception {
        Watcher.Event.EventType eventType = event.getType();
        LOG.info((Object)("Watcher event type: " + eventType + " with state:" + event.getState() + " for path:" + event.getPath() + " for " + this));
        if (eventType == Watcher.Event.EventType.None) {
            switch (9.$SwitchMap$org$apache$zookeeper$Watcher$Event$KeeperState[event.getState().ordinal()]) {
                case 1: {
                    LOG.info((Object)"ZKRMStateStore Session connected");
                    if (this.oldZkClient == null) break;
                    this.zkClient = this.oldZkClient;
                    this.oldZkClient = null;
                    this.notifyAll();
                    LOG.info((Object)"ZKRMStateStore Session restored");
                    break;
                }
                case 2: {
                    LOG.info((Object)"ZKRMStateStore Session disconnected");
                    this.oldZkClient = this.zkClient;
                    this.zkClient = null;
                    break;
                }
                case 3: {
                    LOG.info((Object)"ZKRMStateStore Session expired");
                    this.createConnection();
                    break;
                }
                default: {
                    LOG.error((Object)("Unexpected Zookeeper watch event state: " + event.getState()));
                }
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    String getNodePath(String root, String nodeName) {
        return root + "/" + nodeName;
    }

    private synchronized void doMultiWithRetries(List<Op> opList) throws Exception {
        ArrayList<Op> execOpList = new ArrayList<Op>(opList.size() + 2);
        execOpList.add(this.createFencingNodePathOp);
        execOpList.addAll(opList);
        execOpList.add(this.deleteFencingNodePathOp);
        new /* Unavailable Anonymous Inner Class!! */.runWithRetries();
    }

    private void doMultiWithRetries(Op op) throws Exception {
        this.doMultiWithRetries(Collections.singletonList(op));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public void createWithRetries(String path, byte[] data, List<ACL> acl, CreateMode mode) throws Exception {
        this.doMultiWithRetries(Op.create((String)path, (byte[])data, acl, (CreateMode)mode));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public void setDataWithRetries(String path, byte[] data, int version) throws Exception {
        this.doMultiWithRetries(Op.setData((String)path, (byte[])data, (int)version));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public byte[] getDataWithRetries(String path, boolean watch) throws Exception {
        return (byte[])new /* Unavailable Anonymous Inner Class!! */.runWithRetries();
    }

    private List<ACL> getACLWithRetries(String path, Stat stat) throws Exception {
        return (List)new /* Unavailable Anonymous Inner Class!! */.runWithRetries();
    }

    private List<String> getChildrenWithRetries(String path, boolean watch) throws Exception {
        return (List)new /* Unavailable Anonymous Inner Class!! */.runWithRetries();
    }

    private Stat existsWithRetries(String path, boolean watch) throws Exception {
        return (Stat)new /* Unavailable Anonymous Inner Class!! */.runWithRetries();
    }

    private synchronized void createConnection() throws IOException, InterruptedException {
        this.closeZkClients();
        for (int retries = 0; retries < this.numRetries && this.zkClient == null; ++retries) {
            try {
                this.zkClient = this.getNewZooKeeper();
                for (ZKUtil.ZKAuthInfo zkAuth : this.zkAuths) {
                    this.zkClient.addAuthInfo(zkAuth.getScheme(), zkAuth.getAuth());
                }
                if (!this.useDefaultFencingScheme) continue;
                this.zkClient.addAuthInfo(this.zkRootNodeAuthScheme, (this.zkRootNodeUsername + ":" + this.zkRootNodePassword).getBytes());
                continue;
            }
            catch (IOException ioe) {
                LOG.info((Object)("Failed to connect to the ZooKeeper on attempt - " + (retries + 1)));
                ioe.printStackTrace();
            }
        }
        if (this.zkClient == null) {
            LOG.error((Object)"Unable to connect to Zookeeper");
            throw new YarnRuntimeException("Unable to connect to Zookeeper");
        }
        this.notifyAll();
        LOG.info((Object)"Created new ZK connection");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    protected synchronized ZooKeeper getNewZooKeeper() throws IOException, InterruptedException {
        ZooKeeper zk = new ZooKeeper(this.zkHostPort, this.zkSessionTimeout, null);
        zk.register((Watcher)new ForwardingWatcher(this, null));
        return zk;
    }

    static /* synthetic */ List access$100(ZKRMStateStore x0) {
        return x0.zkAcl;
    }

    static /* synthetic */ String access$200(ZKRMStateStore x0) {
        return x0.zkRootNodePath;
    }

    static /* synthetic */ Op access$300(ZKRMStateStore x0) {
        return x0.deleteFencingNodePathOp;
    }

    static /* synthetic */ String access$400(ZKRMStateStore x0) {
        return x0.fencingNodePath;
    }

    static /* synthetic */ void access$500(ZKRMStateStore x0, List x1) throws Exception {
        x0.doMultiWithRetries(x1);
    }

    static /* synthetic */ int access$600(ZKRMStateStore x0) {
        return x0.zkSessionTimeout;
    }

    static /* synthetic */ int access$700(ZKRMStateStore x0) {
        return x0.numRetries;
    }
}

