/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateVersionIncompatibleException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFencedException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMStateVersion;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppUpdateSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUpdateSavedEvent;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMStateStore
extends AbstractService {
    protected static final String RM_APP_ROOT = "RMAppRoot";
    protected static final String RM_DT_SECRET_MANAGER_ROOT = "RMDTSecretManagerRoot";
    protected static final String DELEGATION_KEY_PREFIX = "DelegationKey_";
    protected static final String DELEGATION_TOKEN_PREFIX = "RMDelegationToken_";
    protected static final String DELEGATION_TOKEN_SEQUENCE_NUMBER_PREFIX = "RMDTSequenceNumber_";
    protected static final String VERSION_NODE = "RMVersionNode";
    protected static final String EPOCH_NODE = "EpochNode";
    public static final Log LOG = LogFactory.getLog(RMStateStore.class);
    private static final StateMachineFactory<RMStateStore, RMStateStoreState, RMStateStoreEventType, RMStateStoreEvent> stateMachineFactory = new StateMachineFactory((Enum)RMStateStoreState.DEFAULT).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.STORE_APP, (SingleArcTransition)new StoreAppTransition(null)).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.UPDATE_APP, (SingleArcTransition)new UpdateAppTransition(null)).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.REMOVE_APP, (SingleArcTransition)new RemoveAppTransition(null)).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.STORE_APP_ATTEMPT, (SingleArcTransition)new StoreAppAttemptTransition(null)).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.UPDATE_APP_ATTEMPT, (SingleArcTransition)new UpdateAppAttemptTransition(null));
    private final StateMachine<RMStateStoreState, RMStateStoreEventType, RMStateStoreEvent> stateMachine = stateMachineFactory.make((Object)this);
    private Dispatcher rmDispatcher;
    AsyncDispatcher dispatcher;
    public static final Text AM_RM_TOKEN_SERVICE = new Text("AM_RM_TOKEN_SERVICE");
    public static final Text AM_CLIENT_TOKEN_MASTER_KEY_NAME = new Text("YARN_CLIENT_TOKEN_MASTER_KEY");

    public RMStateStore() {
        super(RMStateStore.class.getName());
    }

    public void setRMDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.dispatcher = new AsyncDispatcher();
        this.dispatcher.init(conf);
        this.dispatcher.register(RMStateStoreEventType.class, (EventHandler)new ForwardingEventHandler(this, null));
        this.dispatcher.setDrainEventsOnStop();
        this.initInternal(conf);
    }

    protected void serviceStart() throws Exception {
        this.dispatcher.start();
        this.startInternal();
    }

    protected abstract void initInternal(Configuration var1) throws Exception;

    protected abstract void startInternal() throws Exception;

    protected void serviceStop() throws Exception {
        this.closeInternal();
        this.dispatcher.stop();
    }

    protected abstract void closeInternal() throws Exception;

    public void checkVersion() throws Exception {
        RMStateVersion loadedVersion = this.loadVersion();
        LOG.info((Object)("Loaded RM state version info " + loadedVersion));
        if (loadedVersion != null && loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (loadedVersion == null) {
            loadedVersion = RMStateVersion.newInstance((int)1, (int)0);
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new RMStateVersionIncompatibleException("Expecting RM state version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info((Object)("Storing RM state version info " + this.getCurrentVersion()));
        this.storeVersion();
    }

    protected abstract RMStateVersion loadVersion() throws Exception;

    protected abstract void storeVersion() throws Exception;

    protected abstract RMStateVersion getCurrentVersion();

    public abstract int getAndIncrementEpoch() throws Exception;

    public abstract RMState loadState() throws Exception;

    public synchronized void storeNewApplication(RMApp app) {
        ApplicationSubmissionContext context = app.getApplicationSubmissionContext();
        assert (context instanceof ApplicationSubmissionContextPBImpl);
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), app.getStartTime(), context, app.getUser());
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppEvent(appState));
    }

    public synchronized void updateApplicationState(ApplicationState appState) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateUpdateAppEvent(appState));
    }

    protected abstract void storeApplicationStateInternal(ApplicationId var1, ApplicationStateData var2) throws Exception;

    protected abstract void updateApplicationStateInternal(ApplicationId var1, ApplicationStateData var2) throws Exception;

    public synchronized void storeNewApplicationAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
        ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials, appAttempt.getStartTime());
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppAttemptEvent(attemptState));
    }

    public synchronized void updateApplicationAttemptState(ApplicationAttemptState attemptState) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateUpdateAppAttemptEvent(attemptState));
    }

    protected abstract void storeApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateData var2) throws Exception;

    protected abstract void updateApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateData var2) throws Exception;

    public synchronized void storeRMDelegationTokenAndSequenceNumber(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) {
        try {
            this.storeRMDelegationTokenAndSequenceNumberState(rmDTIdentifier, renewDate, latestSequenceNumber);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier var1, Long var2, int var3) throws Exception;

    public synchronized void removeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier, int sequenceNumber) {
        try {
            this.removeRMDelegationTokenState(rmDTIdentifier);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void removeRMDelegationTokenState(RMDelegationTokenIdentifier var1) throws Exception;

    public synchronized void updateRMDelegationTokenAndSequenceNumber(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) {
        try {
            this.updateRMDelegationTokenAndSequenceNumberInternal(rmDTIdentifier, renewDate, latestSequenceNumber);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void updateRMDelegationTokenAndSequenceNumberInternal(RMDelegationTokenIdentifier var1, Long var2, int var3) throws Exception;

    public synchronized void storeRMDTMasterKey(DelegationKey delegationKey) {
        try {
            this.storeRMDTMasterKeyState(delegationKey);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void storeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public synchronized void removeRMDTMasterKey(DelegationKey delegationKey) {
        try {
            this.removeRMDTMasterKeyState(delegationKey);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void removeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public synchronized void removeApplication(RMApp app) {
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser());
        for (RMAppAttempt appAttempt : app.getAppAttempts().values()) {
            Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
            ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials, appAttempt.getStartTime());
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreRemoveAppEvent(appState));
    }

    protected abstract void removeApplicationStateInternal(ApplicationState var1) throws Exception;

    public Credentials getCredentialsFromAppAttempt(RMAppAttempt appAttempt) {
        SecretKey clientTokenMasterKey;
        Credentials credentials = new Credentials();
        Token appToken = appAttempt.getAMRMToken();
        if (appToken != null) {
            credentials.addToken(AM_RM_TOKEN_SERVICE, appToken);
        }
        if ((clientTokenMasterKey = appAttempt.getClientTokenMasterKey()) != null) {
            credentials.addSecretKey(AM_CLIENT_TOKEN_MASTER_KEY_NAME, clientTokenMasterKey.getEncoded());
        }
        return credentials;
    }

    protected void handleStoreEvent(RMStateStoreEvent event) {
        try {
            this.stateMachine.doTransition(event.getType(), (Object)event);
        }
        catch (InvalidStateTransitonException e) {
            LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
        }
    }

    protected void notifyStoreOperationFailed(Exception failureCause) {
        RMFatalEventType type = failureCause instanceof StoreFencedException ? RMFatalEventType.STATE_STORE_FENCED : RMFatalEventType.STATE_STORE_OP_FAILED;
        this.rmDispatcher.getEventHandler().handle((Event)new RMFatalEvent(type, failureCause));
    }

    private void notifyDoneStoringApplication(ApplicationId appId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppNewSavedEvent(appId, storedException));
    }

    private void notifyDoneUpdatingApplication(ApplicationId appId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppUpdateSavedEvent(appId, storedException));
    }

    private void notifyDoneStoringApplicationAttempt(ApplicationAttemptId attemptId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppAttemptNewSavedEvent(attemptId, storedException));
    }

    private void notifyDoneUpdatingApplicationAttempt(ApplicationAttemptId attemptId, Exception updatedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppAttemptUpdateSavedEvent(attemptId, updatedException));
    }

    static /* synthetic */ void access$500(RMStateStore x0, ApplicationId x1, Exception x2) {
        x0.notifyDoneStoringApplication(x1, x2);
    }

    static /* synthetic */ void access$600(RMStateStore x0, ApplicationId x1, Exception x2) {
        x0.notifyDoneUpdatingApplication(x1, x2);
    }

    static /* synthetic */ void access$700(RMStateStore x0, ApplicationAttemptId x1, Exception x2) {
        x0.notifyDoneStoringApplicationAttempt(x1, x2);
    }

    static /* synthetic */ void access$800(RMStateStore x0, ApplicationAttemptId x1, Exception x2) {
        x0.notifyDoneUpdatingApplicationAttempt(x1, x2);
    }
}

