/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMAuditLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMAuditLogger {
    private static final String USER = "test";
    private static final String OPERATION = "oper";
    private static final String TARGET = "tgt";
    private static final String PERM = "admin group";
    private static final String DESC = "description of an audit log";
    private static final ApplicationId APPID = (ApplicationId)Mockito.mock(ApplicationId.class);
    private static final ApplicationAttemptId ATTEMPTID = (ApplicationAttemptId)Mockito.mock(ApplicationAttemptId.class);
    private static final ContainerId CONTAINERID = (ContainerId)Mockito.mock(ContainerId.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)APPID.toString()).thenReturn((Object)"app_1");
        Mockito.when((Object)ATTEMPTID.toString()).thenReturn((Object)"app_attempt_1");
        Mockito.when((Object)CONTAINERID.toString()).thenReturn((Object)"container_1");
    }

    @Test
    public void testKeyValLogFormat() throws Exception {
        StringBuilder actLog = new StringBuilder();
        StringBuilder expLog = new StringBuilder();
        RMAuditLogger.start((RMAuditLogger.Keys)RMAuditLogger.Keys.USER, (String)USER, (StringBuilder)actLog);
        expLog.append("USER=test");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
        RMAuditLogger.add((RMAuditLogger.Keys)RMAuditLogger.Keys.OPERATION, (String)OPERATION, (StringBuilder)actLog);
        expLog.append("\tOPERATION=oper");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
        RMAuditLogger.add((RMAuditLogger.Keys)RMAuditLogger.Keys.APPID, (String)null, (StringBuilder)actLog);
        expLog.append("\tAPPID=null");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
        RMAuditLogger.add((RMAuditLogger.Keys)RMAuditLogger.Keys.TARGET, (String)TARGET, (StringBuilder)actLog);
        expLog.append("\tTARGET=tgt");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
    }

    private void testSuccessLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        String sLog = RMAuditLogger.createSuccessLog((String)USER, (String)OPERATION, (String)TARGET, (ApplicationId)appId, (ApplicationAttemptId)attemptId, (ContainerId)containerId);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=test\t");
        if (checkIP) {
            InetAddress ip = Server.getRemoteIp();
            expLog.append(RMAuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=oper\tTARGET=tgt\tRESULT=SUCCESS");
        if (appId != null) {
            expLog.append("\tAPPID=app_1");
        }
        if (attemptId != null) {
            expLog.append("\tAPPATTEMPTID=app_attempt_1");
        }
        if (containerId != null) {
            expLog.append("\tCONTAINERID=container_1");
        }
        Assert.assertEquals((Object)expLog.toString(), (Object)sLog);
    }

    private void testSuccessLogNulls(boolean checkIP) {
        String sLog = RMAuditLogger.createSuccessLog(null, null, null, null, null, null);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=null\t");
        if (checkIP) {
            InetAddress ip = Server.getRemoteIp();
            expLog.append(RMAuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=null\tTARGET=null\tRESULT=SUCCESS");
        Assert.assertEquals((Object)expLog.toString(), (Object)sLog);
    }

    private void testSuccessLogFormat(boolean checkIP) {
        this.testSuccessLogFormatHelper(checkIP, null, null, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, null, null);
        this.testSuccessLogFormatHelper(checkIP, null, null, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, null, ATTEMPTID, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, null, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, null, ATTEMPTID, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID);
        this.testSuccessLogNulls(checkIP);
    }

    private void testFailureLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        String fLog = RMAuditLogger.createFailureLog((String)USER, (String)OPERATION, (String)PERM, (String)TARGET, (String)DESC, (ApplicationId)appId, (ApplicationAttemptId)attemptId, (ContainerId)containerId);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=test\t");
        if (checkIP) {
            InetAddress ip = Server.getRemoteIp();
            expLog.append(RMAuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=oper\tTARGET=tgt\tRESULT=FAILURE\t");
        expLog.append("DESCRIPTION=description of an audit log");
        expLog.append("\tPERMISSIONS=admin group");
        if (appId != null) {
            expLog.append("\tAPPID=app_1");
        }
        if (attemptId != null) {
            expLog.append("\tAPPATTEMPTID=app_attempt_1");
        }
        if (containerId != null) {
            expLog.append("\tCONTAINERID=container_1");
        }
        Assert.assertEquals((Object)expLog.toString(), (Object)fLog);
    }

    private void testFailureLogFormat(boolean checkIP) {
        this.testFailureLogFormatHelper(checkIP, null, null, null);
        this.testFailureLogFormatHelper(checkIP, APPID, null, null);
        this.testFailureLogFormatHelper(checkIP, null, null, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, null, ATTEMPTID, null);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, null);
        this.testFailureLogFormatHelper(checkIP, APPID, null, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, null, ATTEMPTID, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID);
    }

    @Test
    public void testRMAuditLoggerWithoutIP() throws Exception {
        this.testSuccessLogFormat(false);
        this.testFailureLogFormat(false);
    }

    @Test
    public void testRMAuditLoggerWithIP() throws Exception {
        Configuration conf = new Configuration();
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestRPC.TestProtocol.class).setInstance((Object)new MyTestRPCServer(this, null)).setBindAddress("0.0.0.0").setPort(0).setNumHandlers(5).setVerbose(true).build();
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestRPC.TestProtocol proxy = (TestRPC.TestProtocol)RPC.getProxy(TestRPC.TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
        proxy.ping();
        server.stop();
    }

    static /* synthetic */ void access$000(TestRMAuditLogger x0, boolean x1) {
        x0.testSuccessLogFormat(x1);
    }

    static /* synthetic */ void access$100(TestRMAuditLogger x0, boolean x1) {
        x0.testFailureLogFormat(x1);
    }
}

