/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.http.lib.StaticUserWebFilter;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.ConfigurationProviderFactory;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.ConfigurableAuxServices;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAuthenticationHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceManager
extends CompositeService
implements Recoverable {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(ResourceManager.class);
    private static long clusterTimeStamp = System.currentTimeMillis();
    @VisibleForTesting
    protected RMContextImpl rmContext;
    private Dispatcher rmDispatcher;
    @VisibleForTesting
    protected AdminService adminService;
    protected RMActiveServices activeServices;
    protected RMSecretManagerService rmSecretManagerService;
    protected ResourceScheduler scheduler;
    private ClientRMService clientRM;
    protected ApplicationMasterService masterService;
    protected NMLivelinessMonitor nmLivelinessMonitor;
    protected NodesListManager nodesListManager;
    protected RMAppManager rmAppManager;
    protected ApplicationACLsManager applicationACLsManager;
    protected QueueACLsManager queueACLsManager;
    private WebApp webApp;
    private AppReportFetcher fetcher = null;
    protected ResourceTrackerService resourceTracker;
    private String webAppAddress;
    private ConfigurationProvider configurationProvider = null;
    private Configuration conf;
    private UserGroupInformation rmLoginUGI;
    private ConfigurableAuxServices auxiliaryServices;

    public ResourceManager() {
        super("ResourceManager");
    }

    public RMContext getRMContext() {
        return this.rmContext;
    }

    public static long getClusterTimeStamp() {
        return clusterTimeStamp;
    }

    @VisibleForTesting
    protected static void setClusterTimeStamp(long timestamp) {
        clusterTimeStamp = timestamp;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        this.rmContext = new RMContextImpl();
        this.configurationProvider = ConfigurationProviderFactory.getConfigurationProvider((Configuration)conf);
        this.configurationProvider.init(this.conf);
        this.rmContext.setConfigurationProvider(this.configurationProvider);
        InputStream coreSiteXMLInputStream = this.configurationProvider.getConfigurationInputStream(this.conf, "core-site.xml");
        if (coreSiteXMLInputStream != null) {
            this.conf.addResource(coreSiteXMLInputStream);
        }
        Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)this.conf).refresh();
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
        InputStream yarnSiteXMLInputStream = this.configurationProvider.getConfigurationInputStream(this.conf, "yarn-site.xml");
        if (yarnSiteXMLInputStream != null) {
            this.conf.addResource(yarnSiteXMLInputStream);
        }
        ResourceManager.validateConfigs((Configuration)this.conf);
        this.auxiliaryServices = new ConfigurableAuxServices("RMAuxServices", "yarn.resourcemanager.aux-services");
        this.addService((Service)this.auxiliaryServices);
        this.rmDispatcher = this.setupDispatcher();
        this.addIfService((Object)this.rmDispatcher);
        this.rmContext.setDispatcher(this.rmDispatcher);
        this.adminService = this.createAdminService();
        this.addService((Service)this.adminService);
        this.rmContext.setRMAdminService(this.adminService);
        this.rmContext.setHAEnabled(HAUtil.isHAEnabled((Configuration)this.conf));
        if (this.rmContext.isHAEnabled()) {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
        }
        this.createAndInitActiveServices();
        this.webAppAddress = WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.conf);
        this.rmLoginUGI = UserGroupInformation.getCurrentUser();
        super.serviceInit(this.conf);
    }

    protected QueueACLsManager createQueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        return new QueueACLsManager(scheduler, conf);
    }

    @VisibleForTesting
    protected void setRMStateStore(RMStateStore rmStore) {
        rmStore.setRMDispatcher(this.rmDispatcher);
        this.rmContext.setStateStore(rmStore);
    }

    protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
        return new SchedulerEventDispatcher(this.scheduler);
    }

    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    protected ResourceScheduler createScheduler() {
        String schedulerClassName = this.conf.get("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler");
        LOG.info((Object)("Using Scheduler: " + schedulerClassName));
        try {
            Class<?> schedulerClazz = Class.forName(schedulerClassName);
            if (ResourceScheduler.class.isAssignableFrom(schedulerClazz)) {
                return (ResourceScheduler)ReflectionUtils.newInstance(schedulerClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + schedulerClassName + " not instance of " + ResourceScheduler.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate Scheduler: " + schedulerClassName, (Throwable)e);
        }
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher((RMContext)this.rmContext);
    }

    private NMLivelinessMonitor createNMLivelinessMonitor() {
        return new NMLivelinessMonitor(this.rmContext.getDispatcher());
    }

    protected AMLivelinessMonitor createAMLivelinessMonitor() {
        return new AMLivelinessMonitor(this.rmDispatcher);
    }

    protected DelegationTokenRenewer createDelegationTokenRenewer() {
        return new DelegationTokenRenewer();
    }

    protected RMAppManager createRMAppManager() {
        return new RMAppManager((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.masterService, this.applicationACLsManager, this.conf);
    }

    protected RMApplicationHistoryWriter createRMApplicationHistoryWriter() {
        return new RMApplicationHistoryWriter();
    }

    protected static void validateConfigs(Configuration conf) {
        long heartbeatIntvl;
        int globalMaxAppAttempts = conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        if (globalMaxAppAttempts <= 0) {
            throw new YarnRuntimeException("Invalid global max attempts configuration, yarn.resourcemanager.am.max-attempts=" + globalMaxAppAttempts + ", it should be a positive integer.");
        }
        long expireIntvl = conf.getLong("yarn.nm.liveness-monitor.expiry-interval-ms", 600000L);
        if (expireIntvl < (heartbeatIntvl = conf.getLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 1000L))) {
            throw new YarnRuntimeException("Nodemanager expiry interval should be no less than heartbeat interval, yarn.nm.liveness-monitor.expiry-interval-ms=" + expireIntvl + ", " + "yarn.resourcemanager.nodemanagers.heartbeat-interval-ms" + "=" + heartbeatIntvl);
        }
    }

    protected void startWepApp() {
        Configuration conf = this.getConfig();
        boolean useYarnAuthenticationFilter = conf.getBoolean("yarn.resourcemanager.webapp.delegation-token-auth-filter.enabled", true);
        String authPrefix = "hadoop.http.authentication.";
        String authTypeKey = authPrefix + "type";
        String initializers = conf.get("hadoop.http.filter.initializers");
        if (UserGroupInformation.isSecurityEnabled() && useYarnAuthenticationFilter && conf.get(authTypeKey, "").equalsIgnoreCase("kerberos")) {
            LOG.info((Object)"Using RM authentication filter(kerberos/delegation-token) for RM webapp authentication");
            RMAuthenticationHandler.setSecretManager((RMDelegationTokenSecretManager)this.getClientRMService().rmDTSecretManager);
            String yarnAuthKey = authPrefix + "yarn.resourcemanager.authentication-handler";
            conf.setStrings(yarnAuthKey, new String[]{RMAuthenticationHandler.class.getName()});
            String string = initializers = initializers == null || initializers.isEmpty() ? "" : "," + initializers;
            if (!initializers.contains(RMAuthenticationFilterInitializer.class.getName())) {
                conf.set("hadoop.http.filter.initializers", RMAuthenticationFilterInitializer.class.getName() + initializers);
            }
        }
        if (!UserGroupInformation.isSecurityEnabled()) {
            if (initializers == null || initializers.isEmpty()) {
                conf.set("hadoop.http.filter.initializers", RMAuthenticationFilterInitializer.class.getName());
                conf.set(authTypeKey, "simple");
            } else if (initializers.equals(StaticUserWebFilter.class.getName())) {
                conf.set("hadoop.http.filter.initializers", RMAuthenticationFilterInitializer.class.getName() + "," + initializers);
                conf.set(authTypeKey, "simple");
            }
        }
        WebApps.Builder builder = WebApps.$for((String)"cluster", ApplicationMasterService.class, (Object)this.masterService, (String)"ws").with(conf).withHttpSpnegoPrincipalKey("yarn.resourcemanager.webapp.spnego-principal").withHttpSpnegoKeytabKey("yarn.resourcemanager.webapp.spnego-keytab-file").at(this.webAppAddress);
        String proxyHostAndPort = WebAppUtils.getProxyHostAndPort((Configuration)conf);
        if (WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)conf).equals(proxyHostAndPort)) {
            this.fetcher = HAUtil.isHAEnabled((Configuration)conf) ? new AppReportFetcher(conf) : new AppReportFetcher(conf, (ApplicationClientProtocol)this.getClientRMService());
            builder.withServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            builder.withAttribute("AppUrlFetcher", (Object)this.fetcher);
            String[] proxyParts = proxyHostAndPort.split(":");
            builder.withAttribute("proxyHost", (Object)proxyParts[0]);
        }
        this.webApp = builder.start((WebApp)new RMWebApp(this));
    }

    void createAndInitActiveServices() throws Exception {
        this.activeServices = new RMActiveServices(this);
        this.activeServices.init(this.conf);
    }

    void startActiveServices() throws Exception {
        if (this.activeServices != null) {
            clusterTimeStamp = System.currentTimeMillis();
            this.activeServices.start();
        }
    }

    void stopActiveServices() throws Exception {
        if (this.activeServices != null) {
            this.activeServices.stop();
            this.activeServices = null;
            this.rmContext.getRMNodes().clear();
            this.rmContext.getInactiveRMNodes().clear();
            this.rmContext.getRMApps().clear();
            ClusterMetrics.destroy();
            QueueMetrics.clearQueueMetrics();
        }
    }

    @VisibleForTesting
    protected boolean areActiveServicesRunning() {
        return this.activeServices != null && this.activeServices.isInState(Service.STATE.STARTED);
    }

    synchronized void transitionToActive() throws Exception {
        if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
            LOG.info((Object)"Already in active state");
            return;
        }
        LOG.info((Object)"Transitioning to active state");
        this.rmLoginUGI.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        LOG.info((Object)"Transitioned to active state");
    }

    synchronized void transitionToStandby(boolean initialize) throws Exception {
        if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY) {
            LOG.info((Object)"Already in standby state");
            return;
        }
        LOG.info((Object)"Transitioning to standby state");
        if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
            this.stopActiveServices();
            if (initialize) {
                this.resetDispatcher();
                this.createAndInitActiveServices();
            }
        }
        this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.STANDBY);
        LOG.info((Object)"Transitioned to standby state");
    }

    protected void serviceStart() throws Exception {
        try {
            this.doSecureLogin();
        }
        catch (IOException ie) {
            throw new YarnRuntimeException("Failed to login", (Throwable)ie);
        }
        if (this.rmContext.isHAEnabled()) {
            this.transitionToStandby(true);
        } else {
            this.transitionToActive();
        }
        this.startWepApp();
        if (this.getConfig().getBoolean("yarn.is.minicluster", false)) {
            int port = this.webApp.port();
            WebAppUtils.setRMWebAppPort((Configuration)this.conf, (int)port);
        }
        super.serviceStart();
    }

    protected void doSecureLogin() throws IOException {
        InetSocketAddress socAddr = ResourceManager.getBindAddress((Configuration)this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"yarn.resourcemanager.keytab", (String)"yarn.resourcemanager.principal", (String)socAddr.getHostName());
        if (UserGroupInformation.isSecurityEnabled()) {
            this.rmLoginUGI = UserGroupInformation.getLoginUser();
        }
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        if (this.fetcher != null) {
            this.fetcher.stop();
        }
        if (this.configurationProvider != null) {
            this.configurationProvider.close();
        }
        super.serviceStop();
        this.transitionToStandby(false);
        this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.STOPPING);
    }

    protected ResourceTrackerService createResourceTrackerService() {
        return new ResourceTrackerService((RMContext)this.rmContext, this.nodesListManager, this.nmLivelinessMonitor, this.rmContext.getContainerTokenSecretManager(), this.rmContext.getNMTokenSecretManager());
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.rmContext.getRMDelegationTokenSecretManager());
    }

    protected ApplicationMasterService createApplicationMasterService() {
        return new ApplicationMasterService((RMContext)this.rmContext, (YarnScheduler)this.scheduler);
    }

    protected AdminService createAdminService() {
        return new AdminService(this, (RMContext)this.rmContext);
    }

    protected RMSecretManagerService createRMSecretManagerService() {
        return new RMSecretManagerService(this.conf, this.rmContext);
    }

    @InterfaceAudience.Private
    public ClientRMService getClientRMService() {
        return this.clientRM;
    }

    @InterfaceAudience.Private
    public ResourceScheduler getResourceScheduler() {
        return this.scheduler;
    }

    @InterfaceAudience.Private
    public ResourceTrackerService getResourceTrackerService() {
        return this.resourceTracker;
    }

    @InterfaceAudience.Private
    public ApplicationMasterService getApplicationMasterService() {
        return this.masterService;
    }

    @InterfaceAudience.Private
    public ApplicationACLsManager getApplicationACLsManager() {
        return this.applicationACLsManager;
    }

    @InterfaceAudience.Private
    public QueueACLsManager getQueueACLsManager() {
        return this.queueACLsManager;
    }

    @InterfaceAudience.Private
    WebApp getWebapp() {
        return this.webApp;
    }

    public void recover(RMStateStore.RMState state) throws Exception {
        this.rmContext.getRMDelegationTokenSecretManager().recover(state);
        this.rmAppManager.recover(state);
    }

    public static void main(String[] argv) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(ResourceManager.class, (String[])argv, (Log)LOG);
        try {
            YarnConfiguration conf = new YarnConfiguration();
            ResourceManager resourceManager = new ResourceManager();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)resourceManager), 30);
            resourceManager.init((Configuration)conf);
            resourceManager.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting ResourceManager", t);
            System.exit(-1);
        }
    }

    private Dispatcher setupDispatcher() {
        Dispatcher dispatcher = this.createDispatcher();
        dispatcher.register(RMFatalEventType.class, (EventHandler)new RMFatalEventDispatcher((RMContext)this.rmContext, this));
        return dispatcher;
    }

    private void resetDispatcher() {
        Dispatcher dispatcher = this.setupDispatcher();
        ((Service)dispatcher).init(this.conf);
        ((Service)dispatcher).start();
        this.removeService((Service)this.rmDispatcher);
        this.rmDispatcher = dispatcher;
        this.addIfService((Object)this.rmDispatcher);
        this.rmContext.setDispatcher(this.rmDispatcher);
    }

    public static InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    static /* synthetic */ Configuration access$000(ResourceManager x0) {
        return x0.conf;
    }

    static /* synthetic */ Dispatcher access$100(ResourceManager x0) {
        return x0.rmDispatcher;
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }

    static /* synthetic */ NMLivelinessMonitor access$300(ResourceManager x0) {
        return x0.createNMLivelinessMonitor();
    }

    static /* synthetic */ ClientRMService access$402(ResourceManager x0, ClientRMService x1) {
        x0.clientRM = x1;
        return x0.clientRM;
    }

    static /* synthetic */ ClientRMService access$400(ResourceManager x0) {
        return x0.clientRM;
    }
}

