/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSParentQueue
extends FSQueue {
    private static final Log LOG = LogFactory.getLog((String)FSParentQueue.class.getName());
    private final List<FSQueue> childQueues = new ArrayList<FSQueue>();
    private Resource demand = Resources.createResource((int)0);
    private int runnableApps;

    public FSParentQueue(String name, FairScheduler scheduler, FSParentQueue parent) {
        super(name, scheduler, parent);
    }

    public void addChildQueue(FSQueue child) {
        this.childQueues.add(child);
    }

    @Override
    public void recomputeShares() {
        this.policy.computeShares(this.childQueues, this.getFairShare());
        for (FSQueue childQueue : this.childQueues) {
            childQueue.getMetrics().setFairShare(childQueue.getFairShare());
            childQueue.recomputeShares();
        }
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    @Override
    public Resource getResourceUsage() {
        Resource usage = Resources.createResource((int)0);
        for (FSQueue child : this.childQueues) {
            Resources.addTo((Resource)usage, (Resource)child.getResourceUsage());
        }
        return usage;
    }

    @Override
    public void updateDemand() {
        Resource maxRes = this.scheduler.getAllocationConfiguration().getMaxResources(this.getName());
        this.demand = Resources.createResource((int)0);
        for (FSQueue childQueue : this.childQueues) {
            childQueue.updateDemand();
            Resource toAdd = childQueue.getDemand();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Counting resource from " + childQueue.getName() + " " + toAdd + "; Total resource consumption for " + this.getName() + " now " + this.demand));
            }
            this.demand = Resources.add((Resource)this.demand, (Resource)toAdd);
            this.demand = Resources.componentwiseMin((Resource)this.demand, (Resource)maxRes);
            if (!Resources.equals((Resource)this.demand, (Resource)maxRes)) continue;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The updated demand for " + this.getName() + " is " + this.demand + "; the max is " + maxRes));
        }
    }

    private synchronized QueueUserACLInfo getUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return userAclInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        ArrayList<QueueUserACLInfo> userAcls = new ArrayList<QueueUserACLInfo>();
        userAcls.add(this.getUserAclInfo(user));
        for (FSQueue child : this.childQueues) {
            userAcls.addAll(child.getQueueUserAclInfo(user));
        }
        return userAcls;
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        FSQueue child;
        Resource assigned = Resources.none();
        if (!this.assignContainerPreCheck(node)) {
            return assigned;
        }
        Collections.sort(this.childQueues, this.policy.getComparator());
        Iterator<FSQueue> i$ = this.childQueues.iterator();
        while (i$.hasNext() && Resources.equals((Resource)(assigned = (child = i$.next()).assignContainer(node)), (Resource)Resources.none())) {
        }
        return assigned;
    }

    @Override
    public RMContainer preemptContainer() {
        RMContainer toBePreempted = null;
        if (!this.preemptContainerPreCheck()) {
            return toBePreempted;
        }
        FSQueue candidateQueue = null;
        Comparator<Schedulable> comparator = this.policy.getComparator();
        PriorityQueue<Schedulable> sortedQueues = new PriorityQueue<Schedulable>(this.childQueues.size(), Collections.reverseOrder(comparator));
        sortedQueues.addAll(this.childQueues);
        while (!sortedQueues.isEmpty() && (toBePreempted = (candidateQueue = (FSQueue)sortedQueues.poll()).preemptContainer()) == null) {
        }
        sortedQueues.clear();
        sortedQueues = null;
        return toBePreempted;
    }

    @Override
    public List<FSQueue> getChildQueues() {
        return this.childQueues;
    }

    @Override
    public void setPolicy(SchedulingPolicy policy) throws AllocationConfigurationException {
        boolean allowed = SchedulingPolicy.isApplicableTo(policy, this.parent == null ? (byte)4 : 2);
        if (!allowed) {
            this.throwPolicyDoesnotApplyException(policy);
        }
        this.policy = policy;
    }

    public void incrementRunnableApps() {
        ++this.runnableApps;
    }

    public void decrementRunnableApps() {
        --this.runnableApps;
    }

    @Override
    public int getNumRunnableApps() {
        return this.runnableApps;
    }

    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        for (FSQueue childQueue : this.childQueues) {
            childQueue.collectSchedulerApplications(apps);
        }
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return null;
    }

    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt schedulerAttempt, RMContainer rmContainer) {
    }
}

