/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppSchedulable
extends Schedulable {
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private FairScheduler scheduler;
    private FSSchedulerApp app;
    private Resource demand = Resources.createResource((int)0);
    private long startTime;
    private static final Log LOG = LogFactory.getLog(AppSchedulable.class);
    private FSLeafQueue queue;
    private RMContainerTokenSecretManager containerTokenSecretManager;
    private Priority priority;
    private ResourceWeights resourceWeights;
    private RMContainerComparator comparator = new RMContainerComparator();

    public AppSchedulable(FairScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public AppSchedulable(FairScheduler scheduler, FSSchedulerApp app, FSLeafQueue queue) {
        this.scheduler = scheduler;
        this.app = app;
        this.startTime = scheduler.getClock().getTime();
        this.queue = queue;
        this.containerTokenSecretManager = scheduler.getContainerTokenSecretManager();
        this.priority = Priority.newInstance((int)1);
        this.resourceWeights = new ResourceWeights();
    }

    @Override
    public String getName() {
        return this.app.getApplicationId().toString();
    }

    public FSSchedulerApp getApp() {
        return this.app;
    }

    public ResourceWeights getResourceWeights() {
        return this.resourceWeights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDemand() {
        this.demand = Resources.createResource((int)0);
        Resources.addTo((Resource)this.demand, (Resource)this.app.getCurrentConsumption());
        FSSchedulerApp fSSchedulerApp = this.app;
        synchronized (fSSchedulerApp) {
            for (Priority p : this.app.getPriorities()) {
                for (ResourceRequest r : this.app.getResourceRequests(p).values()) {
                    Resource total = Resources.multiply((Resource)r.getCapability(), (double)r.getNumContainers());
                    Resources.addTo((Resource)this.demand, (Resource)total);
                }
            }
        }
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public Resource getResourceUsage() {
        return Resources.subtract((Resource)this.app.getCurrentConsumption(), (Resource)this.app.getPreemptedResources());
    }

    @Override
    public Resource getMinShare() {
        return Resources.none();
    }

    @Override
    public Resource getMaxShare() {
        return Resources.unbounded();
    }

    public QueueMetrics getMetrics() {
        return this.queue.getMetrics();
    }

    @Override
    public ResourceWeights getWeights() {
        return this.scheduler.getAppWeight(this);
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    public Container createContainer(FSSchedulerApp application, FSSchedulerNode node, Resource capability, Priority priority) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (int)application.getNewContainerId());
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, null);
        return container;
    }

    private void reserve(Priority priority, FSSchedulerNode node, Container container, boolean alreadyReserved) {
        LOG.info((Object)("Making reservation: node=" + node.getNodeName() + " app_id=" + this.app.getApplicationId()));
        if (!alreadyReserved) {
            this.getMetrics().reserveResource(this.app.getUser(), container.getResource());
            RMContainer rmContainer = this.app.reserve(node, priority, null, container);
            node.reserveResource(this.app, priority, rmContainer);
        } else {
            RMContainer rmContainer = node.getReservedContainer();
            this.app.reserve(node, priority, rmContainer, container);
            node.reserveResource(this.app, priority, rmContainer);
        }
    }

    public void unreserve(Priority priority, FSSchedulerNode node) {
        RMContainer rmContainer = node.getReservedContainer();
        this.app.unreserve(node, priority);
        node.unreserveResource(this.app);
        this.getMetrics().unreserveResource(this.app.getUser(), rmContainer.getContainer().getResource());
    }

    private Resource assignContainer(FSSchedulerNode node, ResourceRequest request, NodeType type, boolean reserved) {
        Resource capability = request.getCapability();
        Resource available = node.getAvailableResource();
        Container container = null;
        container = reserved ? node.getReservedContainer().getContainer() : this.createContainer(this.app, node, capability, request.getPriority());
        if (Resources.fitsIn((Resource)capability, (Resource)available)) {
            RMContainer allocatedContainer = this.app.allocate(type, node, request.getPriority(), request, container);
            if (allocatedContainer == null) {
                if (reserved) {
                    this.unreserve(request.getPriority(), node);
                }
                return Resources.none();
            }
            if (reserved) {
                this.unreserve(request.getPriority(), node);
            }
            node.allocateContainer(allocatedContainer);
            if (this.app.getLiveContainers().size() == 1 && !this.app.getUnmanagedAM()) {
                this.queue.addAMResourceUsage(container.getResource());
                this.app.setAmRunning(true);
            }
            return container.getResource();
        }
        this.reserve(request.getPriority(), node, container, reserved);
        return FairScheduler.CONTAINER_RESERVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource assignContainer(FSSchedulerNode node, boolean reserved) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node offered to app: " + this.getName() + " reserved: " + reserved));
        }
        Collection<Priority> prioritiesToTry = reserved ? Arrays.asList(node.getReservedContainer().getReservedPriority()) : this.app.getPriorities();
        FSSchedulerApp fSSchedulerApp = this.app;
        synchronized (fSSchedulerApp) {
            for (Priority priority : prioritiesToTry) {
                if (this.app.getTotalRequiredResources(priority) <= 0 || !this.hasContainerForNode(priority, node)) continue;
                this.app.addSchedulingOpportunity(priority);
                if (this.app.getLiveContainers().size() == 0 && !this.app.getUnmanagedAM() && !this.queue.canRunAppAM(this.app.getAMResource())) {
                    return Resources.none();
                }
                ResourceRequest rackLocalRequest = this.app.getResourceRequest(priority, node.getRackName());
                ResourceRequest localRequest = this.app.getResourceRequest(priority, node.getNodeName());
                if (localRequest != null && !localRequest.getRelaxLocality()) {
                    LOG.warn((Object)("Relax locality off is not supported on local request: " + localRequest));
                }
                NodeType allowedLocality = this.scheduler.isContinuousSchedulingEnabled() ? this.app.getAllowedLocalityLevelByTime(priority, this.scheduler.getNodeLocalityDelayMs(), this.scheduler.getRackLocalityDelayMs(), this.scheduler.getClock().getTime()) : this.app.getAllowedLocalityLevel(priority, this.scheduler.getNumClusterNodes(), this.scheduler.getNodeLocalityThreshold(), this.scheduler.getRackLocalityThreshold());
                if (rackLocalRequest != null && rackLocalRequest.getNumContainers() != 0 && localRequest != null && localRequest.getNumContainers() != 0) {
                    return this.assignContainer(node, localRequest, NodeType.NODE_LOCAL, reserved);
                }
                if (rackLocalRequest != null && !rackLocalRequest.getRelaxLocality()) continue;
                if (rackLocalRequest != null && rackLocalRequest.getNumContainers() != 0 && (allowedLocality.equals((Object)NodeType.RACK_LOCAL) || allowedLocality.equals((Object)NodeType.OFF_SWITCH))) {
                    return this.assignContainer(node, rackLocalRequest, NodeType.RACK_LOCAL, reserved);
                }
                ResourceRequest offSwitchRequest = this.app.getResourceRequest(priority, "*");
                if (offSwitchRequest != null && !offSwitchRequest.getRelaxLocality() || offSwitchRequest == null || offSwitchRequest.getNumContainers() == 0 || !allowedLocality.equals((Object)NodeType.OFF_SWITCH)) continue;
                return this.assignContainer(node, offSwitchRequest, NodeType.OFF_SWITCH, reserved);
            }
        }
        return Resources.none();
    }

    public Resource assignReservedContainer(FSSchedulerNode node) {
        RMContainer rmContainer = node.getReservedContainer();
        Priority priority = rmContainer.getReservedPriority();
        if (this.app.getTotalRequiredResources(priority) == 0) {
            this.unreserve(priority, node);
            return Resources.none();
        }
        if (!Resources.fitsIn((Resource)node.getReservedContainer().getReservedResource(), (Resource)node.getAvailableResource())) {
            return Resources.none();
        }
        return this.assignContainer(node, true);
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        return this.assignContainer(node, false);
    }

    @Override
    public RMContainer preemptContainer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("App " + this.getName() + " is going to preempt a running " + "container"));
        }
        RMContainer toBePreempted = null;
        for (RMContainer container : this.app.getLiveContainers()) {
            if (this.app.getPreemptionContainers().contains(container) || this.app.getNonEligibleForPreemptionSet().contains(container) || toBePreempted != null && this.comparator.compare(toBePreempted, container) <= 0) continue;
            toBePreempted = container;
        }
        return toBePreempted;
    }

    public boolean hasContainerForNode(Priority prio, FSSchedulerNode node) {
        ResourceRequest anyRequest = this.app.getResourceRequest(prio, "*");
        ResourceRequest rackRequest = this.app.getResourceRequest(prio, node.getRackName());
        ResourceRequest nodeRequest = this.app.getResourceRequest(prio, node.getNodeName());
        return anyRequest != null && anyRequest.getNumContainers() > 0 && (anyRequest.getRelaxLocality() || rackRequest != null && rackRequest.getNumContainers() > 0) && (rackRequest == null || rackRequest.getRelaxLocality() || nodeRequest != null && nodeRequest.getNumContainers() > 0) && Resources.lessThanOrEqual((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)anyRequest.getCapability(), (Resource)node.getRMNode().getTotalCapability());
    }

    static class RMContainerComparator
    implements Comparator<RMContainer>,
    Serializable {
        RMContainerComparator() {
        }

        @Override
        public int compare(RMContainer c1, RMContainer c2) {
            int ret = c1.getContainer().getPriority().compareTo(c2.getContainer().getPriority());
            if (ret == 0) {
                return c2.getContainerId().compareTo(c1.getContainerId());
            }
            return ret;
        }
    }
}

