/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.common.collect.Maps;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.FairSchedulerPage;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMWebAppFairScheduler {
    @Test
    public void testFairSchedulerWebAppPage() {
        List<RMAppState> appStates = Arrays.asList(RMAppState.NEW, RMAppState.NEW_SAVING, RMAppState.SUBMITTED);
        final RMContext rmContext = TestRMWebAppFairScheduler.mockRMContext(appStates);
        Injector injector = WebAppTests.createMockInjector(RMContext.class, (Object)rmContext, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    ResourceManager mockRmWithFairScheduler = TestRMWebAppFairScheduler.mockRm(rmContext);
                    binder.bind(ResourceManager.class).toInstance((Object)mockRmWithFairScheduler);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
        FairSchedulerPage fsViewInstance = (FairSchedulerPage)injector.getInstance(FairSchedulerPage.class);
        fsViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    private static RMContext mockRMContext(List<RMAppState> states) {
        final ConcurrentMap applicationsMaps = Maps.newConcurrentMap();
        int i = 0;
        for (RMAppState state : states) {
            MockRMApp app = new MockRMApp(i, i, state);
            applicationsMaps.put(app.getApplicationId(), app);
            ++i;
        }
        return new RMContextImpl(null, null, null, null, null, null, null, null, null, null){

            public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
                return applicationsMaps;
            }
        };
    }

    private static ResourceManager mockRm(RMContext rmContext) throws IOException {
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        FairScheduler rs = TestRMWebAppFairScheduler.mockFairScheduler();
        Mockito.when((Object)rm.getResourceScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        return rm;
    }

    private static FairScheduler mockFairScheduler() throws IOException {
        FairScheduler fs = new FairScheduler();
        FairSchedulerConfiguration conf = new FairSchedulerConfiguration();
        fs.setRMContext((RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null));
        fs.init((Configuration)conf);
        return fs;
    }
}

