/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.util.Clock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSSchedulerApp {
    private ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
        return attId;
    }

    @Test
    public void testDelayScheduling() {
        int i;
        FSLeafQueue queue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Priority prio = (Priority)Mockito.mock(Priority.class);
        Mockito.when((Object)prio.getPriority()).thenReturn((Object)1);
        double nodeLocalityThreshold = 0.5;
        double rackLocalityThreshold = 0.6;
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getEpoch()).thenReturn((Object)0);
        FSSchedulerApp schedulerApp = new FSSchedulerApp(applicationAttemptId, "user1", queue, null, rmContext);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        for (i = 0; i < 5; ++i) {
            schedulerApp.addSchedulingOpportunity(prio);
            Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        }
        schedulerApp.addSchedulingOpportunity(prio);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        schedulerApp.resetAllowedLocalityLevel(prio, NodeType.NODE_LOCAL);
        schedulerApp.resetSchedulingOpportunities(prio);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        for (i = 0; i < 5; ++i) {
            schedulerApp.addSchedulingOpportunity(prio);
            Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        }
        schedulerApp.addSchedulingOpportunity(prio);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        for (i = 0; i < 6; ++i) {
            schedulerApp.addSchedulingOpportunity(prio);
            Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        }
        schedulerApp.addSchedulingOpportunity(prio);
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
    }

    @Test
    public void testDelaySchedulingForContinuousScheduling() throws InterruptedException {
        FSLeafQueue queue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Priority prio = (Priority)Mockito.mock(Priority.class);
        Mockito.when((Object)prio.getPriority()).thenReturn((Object)1);
        MockClock clock = new MockClock();
        long nodeLocalityDelayMs = 5000L;
        long rackLocalityDelayMs = 6000L;
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getEpoch()).thenReturn((Object)0);
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        FSSchedulerApp schedulerApp = new FSSchedulerApp(applicationAttemptId, "user1", queue, null, rmContext);
        AppSchedulable appSchedulable = (AppSchedulable)Mockito.mock(AppSchedulable.class);
        long startTime = clock.getTime();
        Mockito.when((Object)appSchedulable.getStartTime()).thenReturn((Object)startTime);
        schedulerApp.setAppSchedulable(appSchedulable);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        clock.tick(4);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        clock.tick(2);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        schedulerApp.resetAllowedLocalityLevel(prio, NodeType.NODE_LOCAL);
        schedulerApp.resetSchedulingOpportunities(prio, clock.getTime());
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        clock.tick(6);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        clock.tick(7);
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
    }

    @Test
    public void testLocalityLevelWithoutDelays() {
        FSLeafQueue queue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Priority prio = (Priority)Mockito.mock(Priority.class);
        Mockito.when((Object)prio.getPriority()).thenReturn((Object)1);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getEpoch()).thenReturn((Object)0);
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        FSSchedulerApp schedulerApp = new FSSchedulerApp(applicationAttemptId, "user1", queue, null, rmContext);
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, -1.0, -1.0));
    }

    private class MockClock
    implements Clock {
        private long time = 0L;

        private MockClock() {
        }

        public long getTime() {
            return this.time;
        }

        public void tick(int seconds) {
            this.time += (long)(seconds * 1000);
        }
    }
}

