/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.mockito.Mockito;

public class FairSchedulerTestBase {
    protected static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected int APP_ID = 1;
    protected int ATTEMPT_ID = 1;
    protected Configuration conf;
    protected FairScheduler scheduler;
    protected ResourceManager resourceManager;

    protected Configuration createConfiguration() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 1024);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setBoolean("yarn.scheduler.fair.assignmultiple", false);
        conf.setFloat("yarn.scheduler.fair.preemption.cluster-utilization-threshold", 0.0f);
        return conf;
    }

    protected ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        return ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
    }

    protected ResourceRequest createResourceRequest(int memory, String host, int priority, int numContainers, boolean relaxLocality) {
        return this.createResourceRequest(memory, 1, host, priority, numContainers, relaxLocality);
    }

    protected ResourceRequest createResourceRequest(int memory, int vcores, String host, int priority, int numContainers, boolean relaxLocality) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        request.setCapability(BuilderUtils.newResource((int)memory, (int)vcores));
        request.setResourceName(host);
        request.setNumContainers(numContainers);
        Priority prio = (Priority)recordFactory.newRecordInstance(Priority.class);
        prio.setPriority(priority);
        request.setPriority(prio);
        request.setRelaxLocality(relaxLocality);
        return request;
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId) {
        return this.createSchedulingRequest(memory, queueId, userId, 1);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId) {
        return this.createSchedulingRequest(memory, vcores, queueId, userId, 1);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId, int numContainers) {
        return this.createSchedulingRequest(memory, queueId, userId, numContainers, 1);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId, int numContainers) {
        return this.createSchedulingRequest(memory, vcores, queueId, userId, numContainers, 1);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId, int numContainers, int priority) {
        return this.createSchedulingRequest(memory, 1, queueId, userId, numContainers, priority);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId, int numContainers, int priority) {
        ApplicationAttemptId id = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.scheduler.addApplication(id.getApplicationId(), queueId, userId);
        if (this.scheduler.getSchedulerApplications().containsKey(id.getApplicationId())) {
            this.scheduler.addApplicationAttempt(id, false, true);
        }
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest request = this.createResourceRequest(memory, vcores, "*", priority, numContainers, true);
        ask.add(request);
        this.scheduler.allocate(id, ask, new ArrayList(), null, null);
        return id;
    }

    protected void createSchedulingRequestExistingApplication(int memory, int priority, ApplicationAttemptId attId) {
        ResourceRequest request = this.createResourceRequest(memory, "*", priority, 1, true);
        this.createSchedulingRequestExistingApplication(request, attId);
    }

    protected ApplicationAttemptId createSchedulingRequest(String queueId, String userId, List<ResourceRequest> ask) {
        ApplicationAttemptId id = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.scheduler.addApplication(id.getApplicationId(), queueId, userId);
        if (this.scheduler.getSchedulerApplications().containsKey(id.getApplicationId())) {
            this.scheduler.addApplicationAttempt(id, false, true);
        }
        this.scheduler.allocate(id, ask, new ArrayList(), null, null);
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        RMAppAttempt rmAppAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)rmApp.getCurrentAppAttempt()).thenReturn((Object)rmAppAttempt);
        this.resourceManager.getRMContext().getRMApps().put(id.getApplicationId(), rmApp);
        return id;
    }

    protected void createSchedulingRequestExistingApplication(int memory, int vcores, int priority, ApplicationAttemptId attId) {
        ResourceRequest request = this.createResourceRequest(memory, vcores, "*", priority, 1, true);
        this.createSchedulingRequestExistingApplication(request, attId);
    }

    protected void createSchedulingRequestExistingApplication(ResourceRequest request, ApplicationAttemptId attId) {
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ask.add(request);
        this.scheduler.allocate(attId, ask, new ArrayList(), null, null);
    }

    protected void createApplicationWithAMResource(ApplicationAttemptId attId, String queue, String user, Resource amResource) {
        RMContext rmContext = this.resourceManager.getRMContext();
        RMAppImpl rmApp = new RMAppImpl(attId.getApplicationId(), rmContext, this.conf, null, null, null, ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)amResource, null), null, null, 0L, null, null);
        rmContext.getRMApps().put(attId.getApplicationId(), rmApp);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(attId.getApplicationId(), queue, user);
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attempAddedEvent = new AppAttemptAddedSchedulerEvent(attId, false);
        this.scheduler.handle((SchedulerEvent)attempAddedEvent);
    }

    protected static class MockClock
    implements Clock {
        private long time = 0L;

        protected MockClock() {
        }

        public long getTime() {
            return this.time;
        }

        public void tick(int seconds) {
            this.time += (long)(seconds * 1000);
        }
    }
}

