/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.TestAMAuthorization;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCapacityScheduler {
    private static final Log LOG = LogFactory.getLog(TestCapacityScheduler.class);
    private final int GB = 1024;
    private static final String A = "root.a";
    private static final String B = "root.b";
    private static final String A1 = "root.a.a1";
    private static final String A2 = "root.a.a2";
    private static final String B1 = "root.b.b1";
    private static final String B2 = "root.b.b2";
    private static final String B3 = "root.b.b3";
    private static float A_CAPACITY = 10.5f;
    private static float B_CAPACITY = 89.5f;
    private static float A1_CAPACITY = 30.0f;
    private static float A2_CAPACITY = 70.0f;
    private static float B1_CAPACITY = 79.2f;
    private static float B2_CAPACITY = 0.8f;
    private static float B3_CAPACITY = 20.0f;
    private ResourceManager resourceManager = null;
    private RMContext mockContext;

    @Before
    public void setUp() throws Exception {
        this.resourceManager = new ResourceManager();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.resourceManager.init((Configuration)conf);
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMContext().getNMTokenSecretManager().rollMasterKey();
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.mockContext.getConfigurationProvider()).thenReturn((Object)new LocalConfigurationProvider());
    }

    @After
    public void tearDown() throws Exception {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
        }
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        CapacityScheduler scheduler = new CapacityScheduler();
        scheduler.setRMContext(this.resourceManager.getRMContext());
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 2048);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        try {
            scheduler.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
        conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 2);
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 1);
        try {
            scheduler.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"Exception is expected because the min vcores allocation is larger than the max vcores allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler vcores"));
        }
    }

    private NodeManager registerNode(String hostName, int containerManagerPort, int httpPort, String rackName, Resource capability) throws IOException, YarnException {
        NodeManager nm = new NodeManager(hostName, containerManagerPort, httpPort, rackName, capability, this.resourceManager);
        NodeAddedSchedulerEvent nodeAddEvent1 = new NodeAddedSchedulerEvent((RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId()));
        this.resourceManager.getResourceScheduler().handle((Event)nodeAddEvent1);
        return nm;
    }

    @Test
    public void testCapacityScheduler() throws Exception {
        LOG.info((Object)"--- START: testCapacityScheduler ---");
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)1));
        String host_1 = "host_1";
        NodeManager nm_1 = this.registerNode(host_1, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)1));
        Priority priority_0 = org.apache.hadoop.yarn.server.resourcemanager.resource.Priority.create((int)0);
        Priority priority_1 = org.apache.hadoop.yarn.server.resourcemanager.resource.Priority.create((int)1);
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)1024, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_0);
        Application application_1 = new Application("user_1", "b2", this.resourceManager);
        application_1.submit();
        application_1.addNodeManager(host_0, 1234, nm_0);
        application_1.addNodeManager(host_1, 1234, nm_1);
        Resource capability_1_0 = Resources.createResource((int)3072, (int)1);
        application_1.addResourceRequestSpec(priority_1, capability_1_0);
        Resource capability_1_1 = Resources.createResource((int)2048, (int)1);
        application_1.addResourceRequestSpec(priority_0, capability_1_1);
        Task task_1_0 = new Task(application_1, priority_1, new String[]{host_0, host_1});
        application_1.addTask(task_1_0);
        application_0.schedule();
        application_1.schedule();
        LOG.info((Object)"Kick!");
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        application_0.schedule();
        this.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(3072, application_1);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(0, nm_1);
        LOG.info((Object)"Adding new tasks...");
        Task task_1_1 = new Task(application_1, priority_0, new String[]{"*"});
        application_1.addTask(task_1_1);
        application_1.schedule();
        Task task_0_1 = new Task(application_0, priority_0, new String[]{host_0, host_1});
        application_0.addTask(task_0_1);
        application_0.schedule();
        LOG.info((Object)("Sending hb from " + nm_0.getHostName()));
        this.nodeUpdate(nm_0);
        LOG.info((Object)("Sending hb from " + nm_1.getHostName()));
        this.nodeUpdate(nm_1);
        LOG.info((Object)"Trying to allocate...");
        application_0.schedule();
        this.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(5120, application_1);
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(2048, nm_1);
        LOG.info((Object)"--- END: testCapacityScheduler ---");
    }

    private void nodeUpdate(NodeManager nm) {
        RMNode node = (RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.resourceManager.getResourceScheduler().handle((Event)nodeUpdate);
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacity(A, A_CAPACITY);
        conf.setCapacity(B, B_CAPACITY);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, A1_CAPACITY);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, A2_CAPACITY);
        conf.setUserLimitFactor(A2, 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(B1, B1_CAPACITY);
        conf.setUserLimitFactor(B1, 100.0f);
        conf.setCapacity(B2, B2_CAPACITY);
        conf.setUserLimitFactor(B2, 100.0f);
        conf.setCapacity(B3, B3_CAPACITY);
        conf.setUserLimitFactor(B3, 100.0f);
        LOG.info((Object)"Setup top-level queues a and b");
    }

    @Test
    public void testMaximumCapacitySetup() {
        float delta = 1.0E-7f;
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        Assert.assertEquals((float)100.0f, (float)conf.getMaximumCapacity(A), (float)delta);
        conf.setMaximumCapacity(A, 50.0f);
        Assert.assertEquals((float)50.0f, (float)conf.getMaximumCapacity(A), (float)delta);
        conf.setMaximumCapacity(A, -1.0f);
        Assert.assertEquals((float)100.0f, (float)conf.getMaximumCapacity(A), (float)delta);
    }

    @Test
    public void testRefreshQueues() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null);
        this.setupQueueConfiguration(conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        conf.setCapacity(A, 80.0f);
        conf.setCapacity(B, 20.0f);
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.checkQueueCapacities(cs, 80.0f, 20.0f);
        cs.stop();
    }

    private void checkQueueCapacities(CapacityScheduler cs, float capacityA, float capacityB) {
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = this.findQueue(rootQueue, A);
        CSQueue queueB = this.findQueue(rootQueue, B);
        CSQueue queueA1 = this.findQueue(queueA, A1);
        CSQueue queueA2 = this.findQueue(queueA, A2);
        CSQueue queueB1 = this.findQueue(queueB, B1);
        CSQueue queueB2 = this.findQueue(queueB, B2);
        CSQueue queueB3 = this.findQueue(queueB, B3);
        float capA = capacityA / 100.0f;
        float capB = capacityB / 100.0f;
        this.checkQueueCapacity(queueA, capA, capA, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB, capB, capB, 1.0f, 1.0f);
        this.checkQueueCapacity(queueA1, A1_CAPACITY / 100.0f, A1_CAPACITY / 100.0f * capA, 1.0f, 1.0f);
        this.checkQueueCapacity(queueA2, A2_CAPACITY / 100.0f, A2_CAPACITY / 100.0f * capA, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB1, B1_CAPACITY / 100.0f, B1_CAPACITY / 100.0f * capB, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB2, B2_CAPACITY / 100.0f, B2_CAPACITY / 100.0f * capB, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB3, B3_CAPACITY / 100.0f, B3_CAPACITY / 100.0f * capB, 1.0f, 1.0f);
    }

    private void checkQueueCapacity(CSQueue q, float expectedCapacity, float expectedAbsCapacity, float expectedMaxCapacity, float expectedAbsMaxCapacity) {
        float epsilon = 1.0E-5f;
        Assert.assertEquals((String)"capacity", (float)expectedCapacity, (float)q.getCapacity(), (float)1.0E-5f);
        Assert.assertEquals((String)"absolute capacity", (float)expectedAbsCapacity, (float)q.getAbsoluteCapacity(), (float)1.0E-5f);
        Assert.assertEquals((String)"maximum capacity", (float)expectedMaxCapacity, (float)q.getMaximumCapacity(), (float)1.0E-5f);
        Assert.assertEquals((String)"absolute maximum capacity", (float)expectedAbsMaxCapacity, (float)q.getAbsoluteMaximumCapacity(), (float)1.0E-5f);
    }

    private CSQueue findQueue(CSQueue root, String queuePath) {
        if (root.getQueuePath().equals(queuePath)) {
            return root;
        }
        List childQueues = root.getChildQueues();
        if (childQueues != null) {
            for (CSQueue q : childQueues) {
                CSQueue result;
                if (!queuePath.startsWith(q.getQueuePath()) || (result = this.findQueue(q, queuePath)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private void checkApplicationResourceUsage(int expected, Application application) {
        Assert.assertEquals((long)expected, (long)application.getUsedResources().getMemory());
    }

    private void checkNodeResourceUsage(int expected, NodeManager node) {
        Assert.assertEquals((long)expected, (long)node.getUsed().getMemory());
        node.checkResourceUsage();
    }

    @Test(expected=IOException.class)
    public void testParseQueue() throws IOException {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        conf.setQueues(A1, new String[]{"b1"});
        conf.setCapacity("root.a.a1.b1", 100.0f);
        conf.setUserLimitFactor("root.a.a1.b1", 100.0f);
        cs.reinitialize((Configuration)conf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null));
    }

    @Test
    public void testReconnectedNode() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)csConf);
        cs.start();
        cs.reinitialize((Configuration)csConf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null));
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1);
        RMNode n2 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 2);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        Assert.assertEquals((long)6144L, (long)cs.getClusterResource().getMemory());
        n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 1);
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        Assert.assertEquals((long)4096L, (long)cs.getClusterResource().getMemory());
        cs.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefreshQueuesWithNewQueue() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null));
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        String B4 = "root.b.b4";
        float B4_CAPACITY = 10.0f;
        B3_CAPACITY -= B4_CAPACITY;
        try {
            conf.setCapacity(A, 80.0f);
            conf.setCapacity(B, 20.0f);
            conf.setQueues(B, new String[]{"b1", "b2", "b3", "b4"});
            conf.setCapacity(B1, B1_CAPACITY);
            conf.setCapacity(B2, B2_CAPACITY);
            conf.setCapacity(B3, B3_CAPACITY);
            conf.setCapacity(B4, B4_CAPACITY);
            cs.reinitialize((Configuration)conf, this.mockContext);
            this.checkQueueCapacities(cs, 80.0f, 20.0f);
            CSQueue rootQueue = cs.getRootQueue();
            CSQueue queueB = this.findQueue(rootQueue, B);
            CSQueue queueB4 = this.findQueue(queueB, B4);
            Assert.assertEquals((Object)queueB, (Object)queueB4.getParent());
        }
        finally {
            B3_CAPACITY += B4_CAPACITY;
            cs.stop();
        }
    }

    @Test
    public void testCapacitySchedulerInfo() throws Exception {
        QueueInfo queueInfo = this.resourceManager.getResourceScheduler().getQueueInfo("a", true, true);
        Assert.assertEquals((Object)queueInfo.getQueueName(), (Object)"a");
        Assert.assertEquals((long)queueInfo.getChildQueues().size(), (long)2L);
        List userACLInfo = this.resourceManager.getResourceScheduler().getQueueUserAclInfo();
        Assert.assertNotNull((Object)userACLInfo);
        for (QueueUserACLInfo queueUserACLInfo : userACLInfo) {
            Assert.assertEquals((long)this.getQueueCount(userACLInfo, queueUserACLInfo.getQueueName()), (long)1L);
        }
    }

    private int getQueueCount(List<QueueUserACLInfo> queueInformation, String queueName) {
        int result = 0;
        for (QueueUserACLInfo queueUserACLInfo : queueInformation) {
            if (!queueName.equals(queueUserACLInfo.getQueueName())) continue;
            ++result;
        }
        return result;
    }

    @Test
    public void testBlackListNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        String host = "127.0.0.1";
        RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        ApplicationId appId = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "default", "user");
        cs.handle((SchedulerEvent)addAppEvent);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        cs.handle((SchedulerEvent)addAttemptEvent);
        cs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(host), null);
        Assert.assertTrue((boolean)cs.getApplicationAttempt(appAttemptId).isBlacklisted(host));
        cs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, Collections.singletonList(host));
        Assert.assertFalse((boolean)cs.getApplicationAttempt(appAttemptId).isBlacklisted(host));
        rm.stop();
    }

    @Test(timeout=5000L)
    public void testApplicationComparator() {
        CapacityScheduler cs = new CapacityScheduler();
        Comparator appComparator = cs.getApplicationComparator();
        ApplicationId id1 = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationId id2 = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationId id3 = ApplicationId.newInstance((long)2L, (int)1);
        FiCaSchedulerApp app1 = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)app1.getApplicationId()).thenReturn((Object)id1);
        FiCaSchedulerApp app2 = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)app2.getApplicationId()).thenReturn((Object)id2);
        FiCaSchedulerApp app3 = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)app3.getApplicationId()).thenReturn((Object)id3);
        Assert.assertTrue((appComparator.compare(app1, app2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((appComparator.compare(app1, app3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((appComparator.compare(app2, app3) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAppsInQueue() throws Exception {
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        Application application_1 = new Application("user_0", "a2", this.resourceManager);
        application_1.submit();
        Application application_2 = new Application("user_0", "b2", this.resourceManager);
        application_2.submit();
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(application_0.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInA.contains(application_1.getApplicationAttemptId()));
        Assert.assertEquals((long)2L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(application_0.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInRoot.contains(application_1.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInRoot.contains(application_2.getApplicationAttemptId()));
        Assert.assertEquals((long)3L, (long)appsInRoot.size());
        Assert.assertNull((Object)scheduler.getAppsInQueue("nonexistentqueue"));
    }

    @Test
    public void testAddAndRemoveAppFromCapacityScheduler() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        AbstractYarnScheduler cs = (AbstractYarnScheduler)rm.getResourceScheduler();
        SchedulerApplication<SchedulerApplicationAttempt> app = TestSchedulerUtils.verifyAppAddedAndRemovedFromScheduler(cs.getSchedulerApplications(), (EventHandler<SchedulerEvent>)cs, "a1");
        Assert.assertEquals((Object)"a1", (Object)app.getQueue().getQueueName());
    }

    @Test
    public void testAsyncScheduling() throws Exception {
        int i;
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        int NODES = 100;
        for (i = 0; i < 100; ++i) {
            String host = "192.168.1." + i;
            RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
            cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        }
        for (i = 0; i < 100; ++i) {
            CapacityScheduler.schedule((CapacityScheduler)cs);
        }
    }

    @Test(timeout=30000L)
    public void testAllocateDoesNotBlockOnSchedulerLock() throws Exception {
        final YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestAMAuthorization.MyContainerManager containerManager = new TestAMAuthorization.MyContainerManager();
        TestAMAuthorization.MockRMWithAMS rm = new TestAMAuthorization.MockRMWithAMS((Configuration)conf, containerManager);
        rm.start();
        MockNM nm1 = rm.registerNode("localhost:1234", 5120);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(2);
        acls.put(ApplicationAccessType.VIEW_APP, "*");
        RMApp app = rm.submitApp(1024, "appname", "appuser", acls);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
        int msecToSleep = 100;
        for (int msecToWait = 10000; attempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED && msecToWait > 0; msecToWait -= msecToSleep) {
            LOG.info((Object)("Waiting for AppAttempt to reach LAUNCHED state. Current state is " + attempt.getAppAttemptState()));
            Thread.sleep(msecToSleep);
        }
        Assert.assertEquals((Object)attempt.getAppAttemptState(), (Object)RMAppAttemptState.LAUNCHED);
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
        Credentials credentials = containerManager.getContainerCredentials();
        final InetSocketAddress rmBindAddress = rm.getApplicationMasterService().getBindAddress();
        Token<? extends TokenIdentifier> amRMToken = TestAMAuthorization.MockRMWithAMS.setupAndReturnAMRMToken(rmBindAddress, credentials.getAllTokens());
        currentUser.addToken(amRMToken);
        ApplicationMasterProtocol client = (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ApplicationMasterProtocol>(){

            @Override
            public ApplicationMasterProtocol run() {
                return (ApplicationMasterProtocol)rpc.getProxy(ApplicationMasterProtocol.class, rmBindAddress, (Configuration)conf);
            }
        });
        RegisterApplicationMasterRequest request = RegisterApplicationMasterRequest.newInstance((String)"localhost", (int)12345, (String)"");
        client.registerApplicationMaster(request);
        final CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Thread otherThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CapacityScheduler capacityScheduler = cs;
                synchronized (capacityScheduler) {
                    try {
                        barrier.await();
                        barrier.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (BrokenBarrierException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        otherThread.start();
        barrier.await();
        AllocateRequest allocateRequest = AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null);
        client.allocate(allocateRequest);
        barrier.await();
        otherThread.join();
        rm.stop();
    }

    @Test
    public void testNumClusterNodes() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)conf);
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null);
        cs.setRMContext((RMContext)rmContext);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        cs.init((Configuration)csConf);
        cs.start();
        Assert.assertEquals((long)0L, (long)cs.getNumClusterNodes());
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1);
        RMNode n2 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 2);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        Assert.assertEquals((long)2L, (long)cs.getNumClusterNodes());
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        Assert.assertEquals((long)1L, (long)cs.getNumClusterNodes());
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        Assert.assertEquals((long)2L, (long)cs.getNumClusterNodes());
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n2));
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        Assert.assertEquals((long)0L, (long)cs.getNumClusterNodes());
        cs.stop();
    }

    @Test(timeout=30000L)
    public void testRecoverRequestAfterPreemption() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        RMApp app1 = rm1.submitApp(1024);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId1 = ContainerId.newInstance((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)2);
        rm1.waitForState(nm1, containerId1, RMContainerState.ALLOCATED);
        RMContainer rmContainer = cs.getRMContainer(containerId1);
        List requests = rmContainer.getResourceRequests();
        FiCaSchedulerApp app = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerNode node = cs.getNode(rmContainer.getAllocatedNode());
        for (ResourceRequest request : requests) {
            if (request.getResourceName().equals(node.getRackName()) || request.getResourceName().equals("*")) continue;
            Assert.assertNull((Object)app.getResourceRequest(request.getPriority(), request.getResourceName()));
        }
        cs.killContainer(rmContainer);
        Assert.assertEquals((long)3L, (long)requests.size());
        for (ResourceRequest request : requests) {
            Assert.assertEquals((long)1L, (long)app.getResourceRequest(request.getPriority(), request.getResourceName()).getNumContainers());
        }
        ContainerId containerId2 = ContainerId.newInstance((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)3);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertTrue((containers.size() == 1 ? 1 : 0) != 0);
    }
}

