/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.common.base.Joiner;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesNodes;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWebServicesNodes
extends JerseyTest {
    private static MockRM rm;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWebServicesNodes() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testNodes() throws JSONException, Exception {
        this.testNodesHelper("nodes", "application/json");
    }

    @Test
    public void testNodesSlash() throws JSONException, Exception {
        this.testNodesHelper("nodes/", "application/json");
    }

    @Test
    public void testNodesDefault() throws JSONException, Exception {
        this.testNodesHelper("nodes/", "");
    }

    @Test
    public void testNodesDefaultWithUnHealthyNode() throws JSONException, Exception {
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:1235", 5121);
        rm.sendNodeStarted(nm1);
        rm.NMwaitForState(nm1.getNodeId(), NodeState.RUNNING);
        rm.NMwaitForState(nm2.getNodeId(), NodeState.NEW);
        MockNM nm3 = rm.registerNode("h3:1236", 5122);
        rm.NMwaitForState(nm3.getNodeId(), NodeState.NEW);
        rm.sendNodeStarted(nm3);
        rm.NMwaitForState(nm3.getNodeId(), NodeState.RUNNING);
        RMNodeImpl node = (RMNodeImpl)rm.getRMContext().getRMNodes().get(nm3.getNodeId());
        NodeHealthStatus nodeHealth = NodeHealthStatus.newInstance((boolean)false, (String)"test health report", (long)System.currentTimeMillis());
        node.handle((RMNodeEvent)new RMNodeStatusEvent(nm3.getNodeId(), nodeHealth, new ArrayList(), null, null));
        rm.NMwaitForState(nm3.getNodeId(), NodeState.UNHEALTHY);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)nodeArray.length());
    }

    @Test
    public void testNodesQueryNew() throws JSONException, Exception {
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:1235", 5121);
        rm.sendNodeStarted(nm1);
        rm.NMwaitForState(nm1.getNodeId(), NodeState.RUNNING);
        rm.NMwaitForState(nm2.getNodeId(), NodeState.NEW);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", NodeState.NEW.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodeArray.length());
        JSONObject info = nodeArray.getJSONObject(0);
        this.verifyNodeInfo(info, nm2);
    }

    @Test
    public void testNodesQueryStateNone() throws JSONException, Exception {
        WebResource r = this.resource();
        rm.registerNode("h1:1234", 5120);
        rm.registerNode("h2:1235", 5121);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", NodeState.DECOMMISSIONED.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"nodes is not null", (Object)JSONObject.NULL, (Object)json.get("nodes"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodesQueryStateInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        rm.registerNode("h1:1234", 5120);
        rm.registerNode("h2:1235", 5121);
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", "BOGUSSTATE").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception querying invalid state");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringContains((String)"exception message", (String)"org.apache.hadoop.yarn.api.records.NodeState.BOGUSSTATE", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"IllegalArgumentException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"java.lang.IllegalArgumentException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    @Test
    public void testNodesQueryStateLost() throws JSONException, Exception {
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:1234", 5120);
        rm.sendNodeStarted(nm1);
        rm.sendNodeStarted(nm2);
        rm.NMwaitForState(nm1.getNodeId(), NodeState.RUNNING);
        rm.NMwaitForState(nm2.getNodeId(), NodeState.RUNNING);
        rm.sendNodeLost(nm1);
        rm.sendNodeLost(nm2);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", NodeState.LOST.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodeArray.length());
        for (int i = 0; i < nodeArray.length(); ++i) {
            JSONObject info = nodeArray.getJSONObject(i);
            String host = info.get("id").toString().split(":")[0];
            RMNode rmNode = (RMNode)rm.getRMContext().getInactiveRMNodes().get(host);
            WebServicesTestUtils.checkStringMatch((String)"nodeHTTPAddress", (String)"", (String)info.getString("nodeHTTPAddress"));
            WebServicesTestUtils.checkStringMatch((String)"state", (String)rmNode.getState().toString(), (String)info.getString("state"));
        }
    }

    @Test
    public void testSingleNodeQueryStateLost() throws JSONException, Exception {
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:1234", 5120);
        rm.sendNodeStarted(nm1);
        rm.sendNodeStarted(nm2);
        rm.NMwaitForState(nm1.getNodeId(), NodeState.RUNNING);
        rm.NMwaitForState(nm2.getNodeId(), NodeState.RUNNING);
        rm.sendNodeLost(nm1);
        rm.sendNodeLost(nm2);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("h2:1234").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject info = json.getJSONObject("node");
        String id = info.get("id").toString();
        Assert.assertEquals((String)"Incorrect Node Information.", (Object)"h2:1234", (Object)id);
        RMNode rmNode = (RMNode)rm.getRMContext().getInactiveRMNodes().get("h2");
        WebServicesTestUtils.checkStringMatch((String)"nodeHTTPAddress", (String)"", (String)info.getString("nodeHTTPAddress"));
        WebServicesTestUtils.checkStringMatch((String)"state", (String)rmNode.getState().toString(), (String)info.getString("state"));
    }

    @Test
    public void testNodesQueryRunning() throws JSONException, Exception {
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:1235", 5121);
        rm.sendNodeStarted(nm1);
        rm.NMwaitForState(nm1.getNodeId(), NodeState.RUNNING);
        rm.NMwaitForState(nm2.getNodeId(), NodeState.NEW);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", "running").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodeArray.length());
    }

    @Test
    public void testNodesQueryHealthyFalse() throws JSONException, Exception {
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:1235", 5121);
        rm.sendNodeStarted(nm1);
        rm.NMwaitForState(nm1.getNodeId(), NodeState.RUNNING);
        rm.NMwaitForState(nm2.getNodeId(), NodeState.NEW);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", "UNHEALTHY").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"nodes is not null", (Object)JSONObject.NULL, (Object)json.get("nodes"));
    }

    public void testNodesHelper(String path, String media) throws JSONException, Exception {
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:1235", 5121);
        rm.sendNodeStarted(nm1);
        rm.sendNodeStarted(nm2);
        rm.NMwaitForState(nm1.getNodeId(), NodeState.RUNNING);
        rm.NMwaitForState(nm2.getNodeId(), NodeState.RUNNING);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path(path).accept(new String[]{media}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodeArray.length());
        JSONObject info = nodeArray.getJSONObject(0);
        String id = info.get("id").toString();
        if (id.matches("h1:1234")) {
            this.verifyNodeInfo(info, nm1);
            this.verifyNodeInfo(nodeArray.getJSONObject(1), nm2);
        } else {
            this.verifyNodeInfo(info, nm2);
            this.verifyNodeInfo(nodeArray.getJSONObject(1), nm1);
        }
    }

    @Test
    public void testSingleNode() throws JSONException, Exception {
        rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:1235", 5121);
        this.testSingleNodeHelper("h2:1235", nm2, "application/json");
    }

    @Test
    public void testSingleNodeSlash() throws JSONException, Exception {
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        rm.registerNode("h2:1235", 5121);
        this.testSingleNodeHelper("h1:1234/", nm1, "application/json");
    }

    @Test
    public void testSingleNodeDefault() throws JSONException, Exception {
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        rm.registerNode("h2:1235", 5121);
        this.testSingleNodeHelper("h1:1234/", nm1, "");
    }

    public void testSingleNodeHelper(String nodeid, MockNM nm, String media) throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path(nodeid).accept(new String[]{media}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject info = json.getJSONObject("node");
        this.verifyNodeInfo(info, nm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonexistNode() throws JSONException, Exception {
        rm.registerNode("h1:1234", 5120);
        rm.registerNode("h2:1235", 5121);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").path("node_invalid:99").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on non-existent nodeid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyNonexistNodeException(message, type, classname);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonexistNodeDefault() throws JSONException, Exception {
        rm.registerNode("h1:1234", 5120);
        rm.registerNode("h2:1235", 5121);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").path("node_invalid:99").get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on non-existent nodeid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyNonexistNodeException(message, type, classname);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonexistNodeXML() throws JSONException, Exception {
        rm.registerNode("h1:1234", 5120);
        rm.registerNode("h2:1235", 5121);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").path("node_invalid:99").accept(new String[]{"application/xml"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on non-existent nodeid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String msg = (String)response.getEntity(String.class);
            System.out.println(msg);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(msg));
            Document dom = db.parse(is);
            NodeList nodes = dom.getElementsByTagName("RemoteException");
            Element element = (Element)nodes.item(0);
            String message = WebServicesTestUtils.getXmlString((Element)element, (String)"message");
            String type = WebServicesTestUtils.getXmlString((Element)element, (String)"exception");
            String classname = WebServicesTestUtils.getXmlString((Element)element, (String)"javaClassName");
            this.verifyNonexistNodeException(message, type, classname);
        }
        finally {
            rm.stop();
        }
    }

    private void verifyNonexistNodeException(String message, String type, String classname) {
        Assert.assertTrue((String)"exception message incorrect", (boolean)"java.lang.Exception: nodeId, node_invalid:99, is not found".matches(message));
        Assert.assertTrue((String)"exception type incorrect", (boolean)"NotFoundException".matches(type));
        Assert.assertTrue((String)"exception className incorrect", (boolean)"org.apache.hadoop.yarn.webapp.NotFoundException".matches(classname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidNode() throws JSONException, Exception {
        rm.registerNode("h1:1234", 5120);
        rm.registerNode("h2:1235", 5121);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").path("node_invalid_foo").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on non-existent nodeid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"Invalid NodeId \\[node_invalid_foo\\]. Expected host:port", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"IllegalArgumentException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"java.lang.IllegalArgumentException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    @Test
    public void testNodesXML() throws JSONException, Exception {
        rm.start();
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodesApps = dom.getElementsByTagName("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodesApps.getLength());
        NodeList nodes = dom.getElementsByTagName("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        this.verifyNodesXML(nodes, nm1);
        rm.stop();
    }

    @Test
    public void testSingleNodesXML() throws JSONException, Exception {
        rm.start();
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("h1:1234").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        this.verifyNodesXML(nodes, nm1);
        rm.stop();
    }

    @Test
    public void testNodes2XML() throws JSONException, Exception {
        rm.start();
        WebResource r = this.resource();
        rm.registerNode("h1:1234", 5120);
        rm.registerNode("h2:1235", 5121);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodesApps = dom.getElementsByTagName("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodesApps.getLength());
        NodeList nodes = dom.getElementsByTagName("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodes.getLength());
        rm.stop();
    }

    @Test
    public void testQueryAll() throws Exception {
        WebResource r = this.resource();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:1235", 5121);
        MockNM nm3 = rm.registerNode("h3:1236", 5122);
        rm.sendNodeStarted(nm1);
        rm.sendNodeStarted(nm3);
        rm.NMwaitForState(nm1.getNodeId(), NodeState.RUNNING);
        rm.NMwaitForState(nm2.getNodeId(), NodeState.NEW);
        rm.sendNodeLost(nm3);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", Joiner.on((char)',').join(EnumSet.allOf(NodeState.class))).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)nodeArray.length());
    }

    public void verifyNodesXML(NodeList nodes, MockNM nm) throws JSONException, Exception {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyNodeInfoGeneric(nm, WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"rack"), WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHostName"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHTTPAddress"), WebServicesTestUtils.getXmlLong((Element)element, (String)"lastHealthUpdate"), WebServicesTestUtils.getXmlString((Element)element, (String)"healthReport"), WebServicesTestUtils.getXmlInt((Element)element, (String)"numContainers"), WebServicesTestUtils.getXmlLong((Element)element, (String)"usedMemoryMB"), WebServicesTestUtils.getXmlLong((Element)element, (String)"availMemoryMB"), WebServicesTestUtils.getXmlLong((Element)element, (String)"usedVirtualCores"), WebServicesTestUtils.getXmlLong((Element)element, (String)"availableVirtualCores"), WebServicesTestUtils.getXmlString((Element)element, (String)"version"));
        }
    }

    public void verifyNodeInfo(JSONObject nodeInfo, MockNM nm) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)15L, (long)nodeInfo.length());
        this.verifyNodeInfoGeneric(nm, nodeInfo.getString("state"), nodeInfo.getString("rack"), nodeInfo.getString("id"), nodeInfo.getString("nodeHostName"), nodeInfo.getString("nodeHTTPAddress"), nodeInfo.getLong("lastHealthUpdate"), nodeInfo.getString("healthReport"), nodeInfo.getInt("numContainers"), nodeInfo.getLong("usedMemoryMB"), nodeInfo.getLong("availMemoryMB"), nodeInfo.getLong("usedVirtualCores"), nodeInfo.getLong("availableVirtualCores"), nodeInfo.getString("version"));
    }

    public void verifyNodeInfoGeneric(MockNM nm, String state, String rack, String id, String nodeHostName, String nodeHTTPAddress, long lastHealthUpdate, String healthReport, int numContainers, long usedMemoryMB, long availMemoryMB, long usedVirtualCores, long availVirtualCores, String version) throws JSONException, Exception {
        RMNode node = (RMNode)rm.getRMContext().getRMNodes().get(nm.getNodeId());
        ResourceScheduler sched = rm.getResourceScheduler();
        SchedulerNodeReport report = sched.getNodeReport(nm.getNodeId());
        WebServicesTestUtils.checkStringMatch((String)"state", (String)node.getState().toString(), (String)state);
        WebServicesTestUtils.checkStringMatch((String)"rack", (String)node.getRackName(), (String)rack);
        WebServicesTestUtils.checkStringMatch((String)"id", (String)nm.getNodeId().toString(), (String)id);
        WebServicesTestUtils.checkStringMatch((String)"nodeHostName", (String)nm.getNodeId().getHost(), (String)nodeHostName);
        WebServicesTestUtils.checkStringMatch((String)"healthReport", (String)String.valueOf(node.getHealthReport()), (String)healthReport);
        String expectedHttpAddress = nm.getNodeId().getHost() + ":" + nm.getHttpPort();
        WebServicesTestUtils.checkStringMatch((String)"nodeHTTPAddress", (String)expectedHttpAddress, (String)nodeHTTPAddress);
        WebServicesTestUtils.checkStringMatch((String)"version", (String)node.getNodeManagerVersion(), (String)version);
        long expectedHealthUpdate = node.getLastHealthReportTime();
        Assert.assertEquals((String)("lastHealthUpdate doesn't match, got: " + lastHealthUpdate + " expected: " + expectedHealthUpdate), (long)expectedHealthUpdate, (long)lastHealthUpdate);
        if (report != null) {
            Assert.assertEquals((String)("numContainers doesn't match: " + numContainers), (long)report.getNumContainers(), (long)numContainers);
            Assert.assertEquals((String)("usedMemoryMB doesn't match: " + usedMemoryMB), (long)report.getUsedResource().getMemory(), (long)usedMemoryMB);
            Assert.assertEquals((String)("availMemoryMB doesn't match: " + availMemoryMB), (long)report.getAvailableResource().getMemory(), (long)availMemoryMB);
            Assert.assertEquals((String)("usedVirtualCores doesn't match: " + usedVirtualCores), (long)report.getUsedResource().getVirtualCores(), (long)usedVirtualCores);
            Assert.assertEquals((String)("availVirtualCores doesn't match: " + availVirtualCores), (long)report.getAvailableResource().getVirtualCores(), (long)availVirtualCores);
        }
    }

    static /* synthetic */ MockRM access$002(MockRM x0) {
        rm = x0;
        return rm;
    }

    static /* synthetic */ MockRM access$000() {
        return rm;
    }

    static /* synthetic */ Injector access$100(TestRMWebServicesNodes x0) {
        return x0.injector;
    }
}

