/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;

public class SchedulingMonitor
extends AbstractService {
    private final SchedulingEditPolicy scheduleEditPolicy;
    private static final Log LOG = LogFactory.getLog(SchedulingMonitor.class);
    private Thread checkerThread;
    private volatile boolean stopped;
    private long monitorInterval;
    private RMContext rmContext;

    public SchedulingMonitor(RMContext rmContext, SchedulingEditPolicy scheduleEditPolicy) {
        super("SchedulingMonitor (" + scheduleEditPolicy.getPolicyName() + ")");
        this.scheduleEditPolicy = scheduleEditPolicy;
        this.rmContext = rmContext;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    @VisibleForTesting
    public synchronized SchedulingEditPolicy getSchedulingEditPolicy() {
        return this.scheduleEditPolicy;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.scheduleEditPolicy.init(conf, this.rmContext.getDispatcher().getEventHandler(), (PreemptableResourceScheduler)this.rmContext.getScheduler());
        this.monitorInterval = this.scheduleEditPolicy.getMonitoringInterval();
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        assert (!this.stopped) : "starting when already stopped";
        this.checkerThread = new Thread((Runnable)new PreemptionChecker(this, null));
        this.checkerThread.setName(this.getName());
        this.checkerThread.start();
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        this.stopped = true;
        if (this.checkerThread != null) {
            this.checkerThread.interrupt();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    public void invokePolicy() {
        this.scheduleEditPolicy.editSchedule();
    }

    static /* synthetic */ boolean access$100(SchedulingMonitor x0) {
        return x0.stopped;
    }

    static /* synthetic */ long access$200(SchedulingMonitor x0) {
        return x0.monitorInterval;
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }
}

