/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSSchedulerNode
extends SchedulerNode {
    private static final Log LOG = LogFactory.getLog(FSSchedulerNode.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private Resource availableResource;
    private Resource usedResource = (Resource)recordFactory.newRecordInstance(Resource.class);
    private Resource totalResourceCapability;
    private volatile int numContainers;
    private RMContainer reservedContainer;
    private AppSchedulable reservedAppSchedulable;
    private final Map<ContainerId, RMContainer> launchedContainers = new HashMap<ContainerId, RMContainer>();
    private final RMNode rmNode;
    private final String nodeName;

    public FSSchedulerNode(RMNode node, boolean usePortForNodeName) {
        this.rmNode = node;
        this.availableResource = Resources.clone((Resource)node.getTotalCapability());
        this.totalResourceCapability = Resource.newInstance((int)node.getTotalCapability().getMemory(), (int)node.getTotalCapability().getVirtualCores(), (double)node.getTotalCapability().getDisks());
        this.nodeName = usePortForNodeName ? this.rmNode.getHostName() + ":" + node.getNodeID().getPort() : this.rmNode.getHostName();
    }

    public RMNode getRMNode() {
        return this.rmNode;
    }

    @Override
    public NodeId getNodeID() {
        return this.rmNode.getNodeID();
    }

    public String getHttpAddress() {
        return this.rmNode.getHttpAddress();
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getRackName() {
        return this.rmNode.getRackName();
    }

    public synchronized void allocateContainer(ApplicationId applicationId, RMContainer rmContainer) {
        Container container = rmContainer.getContainer();
        this.deductAvailableResource(container.getResource());
        ++this.numContainers;
        this.launchedContainers.put(container.getId(), rmContainer);
        LOG.info((Object)("Assigned container " + container.getId() + " of capacity " + container.getResource() + " on host " + this.rmNode.getNodeAddress() + ", which currently has " + this.numContainers + " containers, " + this.getUsedResource() + " used and " + this.getAvailableResource() + " available"));
    }

    @Override
    public synchronized Resource getAvailableResource() {
        return this.availableResource;
    }

    @Override
    public synchronized Resource getUsedResource() {
        return this.usedResource;
    }

    private synchronized boolean isValidContainer(Container c) {
        return this.launchedContainers.containsKey(c.getId());
    }

    private synchronized void updateResource(Container container) {
        this.addAvailableResource(container.getResource());
        --this.numContainers;
    }

    public synchronized void releaseContainer(Container container) {
        if (!this.isValidContainer(container)) {
            LOG.error((Object)("Invalid container released " + container));
            return;
        }
        this.launchedContainers.remove(container.getId());
        this.updateResource(container);
        LOG.info((Object)("Released container " + container.getId() + " of capacity " + container.getResource() + " on host " + this.rmNode.getNodeAddress() + ", which currently has " + this.numContainers + " containers, " + this.getUsedResource() + " used and " + this.getAvailableResource() + " available" + ", release resources=" + true));
    }

    private synchronized void addAvailableResource(Resource resource) {
        if (resource == null) {
            LOG.error((Object)("Invalid resource addition of null resource for " + this.rmNode.getNodeAddress()));
            return;
        }
        Resources.addTo((Resource)this.availableResource, (Resource)resource);
        Resources.subtractFrom((Resource)this.usedResource, (Resource)resource);
    }

    @Override
    public Resource getTotalResource() {
        return this.totalResourceCapability;
    }

    private synchronized void deductAvailableResource(Resource resource) {
        if (resource == null) {
            LOG.error((Object)("Invalid deduction of null resource for " + this.rmNode.getNodeAddress()));
            return;
        }
        Resources.subtractFrom((Resource)this.availableResource, (Resource)resource);
        Resources.addTo((Resource)this.usedResource, (Resource)resource);
    }

    public String toString() {
        return "host: " + this.rmNode.getNodeAddress() + " #containers=" + this.getNumContainers() + " available=" + this.getAvailableResource() + " used=" + this.getUsedResource();
    }

    @Override
    public int getNumContainers() {
        return this.numContainers;
    }

    public synchronized List<RMContainer> getRunningContainers() {
        return new ArrayList<RMContainer>(this.launchedContainers.values());
    }

    public synchronized void reserveResource(FSSchedulerApp application, Priority priority, RMContainer reservedContainer) {
        if (this.reservedContainer != null) {
            if (!reservedContainer.getContainer().getNodeId().equals((Object)this.getNodeID())) {
                throw new IllegalStateException("Trying to reserve container " + reservedContainer + " on node " + reservedContainer.getReservedNode() + " when currently" + " reserved resource " + this.reservedContainer + " on node " + this.reservedContainer.getReservedNode());
            }
            if (!this.reservedContainer.getContainer().getId().getApplicationAttemptId().equals((Object)reservedContainer.getContainer().getId().getApplicationAttemptId())) {
                throw new IllegalStateException("Trying to reserve container " + reservedContainer + " for application " + application.getApplicationId() + " when currently" + " reserved container " + this.reservedContainer + " on node " + this);
            }
            LOG.info((Object)("Updated reserved container " + reservedContainer.getContainer().getId() + " on node " + this + " for application " + application));
        } else {
            LOG.info((Object)("Reserved container " + reservedContainer.getContainer().getId() + " on node " + this + " for application " + application));
        }
        this.reservedContainer = reservedContainer;
        this.reservedAppSchedulable = application.getAppSchedulable();
    }

    public synchronized void unreserveResource(FSSchedulerApp application) {
        ApplicationAttemptId reservedApplication = this.reservedContainer.getContainer().getId().getApplicationAttemptId();
        if (!reservedApplication.equals((Object)application.getApplicationAttemptId())) {
            throw new IllegalStateException("Trying to unreserve  for application " + application.getApplicationId() + " when currently reserved " + " for application " + reservedApplication.getApplicationId() + " on node " + this);
        }
        this.reservedContainer = null;
        this.reservedAppSchedulable = null;
    }

    public synchronized RMContainer getReservedContainer() {
        return this.reservedContainer;
    }

    public synchronized AppSchedulable getReservedAppSchedulable() {
        return this.reservedAppSchedulable;
    }

    @Override
    public synchronized void applyDeltaOnAvailableResource(Resource deltaResource) {
        Resources.addTo((Resource)this.availableResource, (Resource)deltaResource);
    }
}

