/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodesPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebApp;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestNodesPage {
    final int numberOfRacks = 2;
    final int numberOfNodesPerRack = 6;
    final int numberOfLostNodesPerRack = 6 / NodeState.values().length;
    final int numberOfThInMetricsTable = 13;
    final int numberOfActualTableHeaders = 14;
    private Injector injector;

    @Before
    public void setUp() throws Exception {
        final RMContext mockRMContext = TestRMWebApp.mockRMContext(3, 2, 6, 8192);
        this.injector = WebAppTests.createMockInjector(RMContext.class, (Object)mockRMContext, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    binder.bind(ResourceManager.class).toInstance((Object)TestRMWebApp.mockRm(mockRMContext));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
    }

    @Test
    public void testNodesBlockRender() throws Exception {
        ((NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class)).render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)27))).print("<th");
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)181))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForLostNodes() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.state", "lost");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)27))).print("<th");
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)(2 * this.numberOfLostNodesPerRack * 14 + 13)))).print("<td");
    }
}

