/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestQueueManager {
    private FairSchedulerConfiguration conf;
    private QueueManager queueManager;
    private Set<FSQueue> notEmptyQueues;

    @Before
    public void setUp() throws Exception {
        this.conf = new FairSchedulerConfiguration();
        FairScheduler scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)this.conf);
        Mockito.when((Object)scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        Mockito.when((Object)scheduler.getConf()).thenReturn((Object)this.conf);
        SystemClock clock = new SystemClock();
        Mockito.when((Object)scheduler.getClock()).thenReturn((Object)clock);
        this.notEmptyQueues = new HashSet<FSQueue>();
        this.queueManager = new QueueManager(scheduler){

            public boolean isEmpty(FSQueue queue) {
                return !TestQueueManager.this.notEmptyQueues.contains(queue);
            }
        };
        FSQueueMetrics.forQueue((String)"root", null, (boolean)true, (Configuration)this.conf);
        this.queueManager.initialize((Configuration)this.conf);
    }

    @Test
    public void testReloadTurnsLeafQueueIntoParent() throws Exception {
        this.updateConfiguredQueues(this.queueManager, "queue1");
        this.updateConfiguredQueues(this.queueManager, "queue1.queue2");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        this.updateConfiguredQueues(this.queueManager, "queue1");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1", false));
        this.notEmptyQueues.add((FSQueue)this.queueManager.getLeafQueue("queue1", false));
        this.updateConfiguredQueues(this.queueManager, "queue1.queue2");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1", false));
        this.notEmptyQueues.clear();
        this.updateConfiguredQueues(this.queueManager, "queue1.queue2");
        this.notEmptyQueues.add(this.queueManager.getQueue("root.queue1"));
        this.updateConfiguredQueues(this.queueManager, "queue1");
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1", false));
        this.updateConfiguredQueues(this.queueManager, "default.queue3");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("default.queue3", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("default", false));
    }

    private void updateConfiguredQueues(QueueManager queueMgr, String ... confQueues) {
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)this.conf);
        allocConf.queueNames = Sets.newHashSet((Object[])confQueues);
        queueMgr.updateAllocationConfiguration(allocConf);
    }
}

