/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestRM {
    private static final Log LOG = LogFactory.getLog(TestRM.class);
    private static final int WAIT_SLEEP_MS = 100;

    @Test
    public void testGetNewAppId() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        GetNewApplicationResponse resp = rm.getNewAppId();
        assert (resp.getApplicationId().getId() != 0);
        assert (resp.getMaximumResourceCapability().getMemory() > 0);
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testAppWithNoContainers() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testAppOnMultiNode() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.scheduler.capacity.node-locality-delay", "-1");
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:5678", 10240);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        int request = 13;
        am.allocate("h1", 1000, request, new ArrayList<ContainerId>());
        List conts = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        int contReceived = conts.size();
        while (contReceived < 3) {
            nm1.nodeHeartbeat(true);
            conts.addAll(am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            contReceived = conts.size();
            LOG.info((Object)("Got " + contReceived + " containers. Waiting to get " + 3));
            Thread.sleep(100L);
        }
        Assert.assertEquals((int)3, (int)conts.size());
        conts = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        contReceived = conts.size();
        while (contReceived < 10) {
            nm2.nodeHeartbeat(true);
            conts.addAll(am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            contReceived = conts.size();
            LOG.info((Object)("Got " + contReceived + " containers. Waiting to get " + 10));
            Thread.sleep(100L);
        }
        Assert.assertEquals((int)10, (int)conts.size());
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        rm.stop();
    }

    @Test(timeout=20000L)
    public void testNMTokenSentForNormalContainer() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getCanonicalName());
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        RMApp app = rm.submitApp(2000);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        cs.getApplicationAttempt(attempt.getAppAttemptId()).getNewContainerId();
        nm1.nodeHeartbeat(true);
        MockAM am = MockRM.launchAM(app, rm, nm1);
        Assert.assertTrue((attempt.getMasterContainer().getId().getId() != 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)rm.getRMContext().getNMTokenSecretManager().isApplicationAttemptNMTokenPresent(attempt.getAppAttemptId(), nm1.getNodeId()));
        am.registerAppAttempt();
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        int NUM_CONTAINERS = 1;
        ArrayList containers = new ArrayList();
        ArrayList expectedNMTokens = new ArrayList();
        while (true) {
            AllocateResponse response = am.allocate("127.0.0.1", 2000, NUM_CONTAINERS, new ArrayList<ContainerId>());
            nm1.nodeHeartbeat(true);
            containers.addAll(response.getAllocatedContainers());
            expectedNMTokens.addAll(response.getNMTokens());
            if (containers.size() == NUM_CONTAINERS) break;
            Thread.sleep(200L);
            System.out.println("Waiting for container to be allocated.");
        }
        NodeId nodeId = ((NMToken)expectedNMTokens.get(0)).getNodeId();
        Assert.assertEquals((Object)nm1.getNodeId(), (Object)nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=40000L)
    public void testNMToken() throws Exception {
        MockRM rm = new MockRM();
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("h1:1234", 10000);
            NMTokenSecretManagerInRM nmTokenSecretManager = rm.getRMContext().getNMTokenSecretManager();
            RMApp app = rm.submitApp(1000);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt = app.getCurrentAppAttempt();
            MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
            Assert.assertTrue((boolean)nmTokenSecretManager.isApplicationAttemptRegistered(attempt.getAppAttemptId()));
            am.registerAppAttempt();
            ArrayList<Container> containersReceivedForNM1 = new ArrayList<Container>();
            ArrayList<ContainerId> releaseContainerList = new ArrayList<ContainerId>();
            HashMap<String, Token> nmTokens = new HashMap<String, Token>();
            AllocateResponse response = am.allocate("h1", 1000, 2, releaseContainerList);
            Assert.assertEquals((int)0, (int)response.getAllocatedContainers().size());
            this.allocateContainersAndValidateNMTokens(am, containersReceivedForNM1, 2, nmTokens, nm1);
            Assert.assertEquals((int)1, (int)nmTokens.size());
            response = am.allocate("h1", 1000, 2, releaseContainerList);
            Assert.assertEquals((int)0, (int)response.getAllocatedContainers().size());
            this.allocateContainersAndValidateNMTokens(am, containersReceivedForNM1, 4, nmTokens, nm1);
            Assert.assertEquals((int)1, (int)nmTokens.size());
            MockNM nm2 = rm.registerNode("h2:1234", 10000);
            nm2.nodeHeartbeat(true);
            ArrayList<Container> containersReceivedForNM2 = new ArrayList<Container>();
            response = am.allocate("h2", 1000, 2, releaseContainerList);
            Assert.assertEquals((int)0, (int)response.getAllocatedContainers().size());
            this.allocateContainersAndValidateNMTokens(am, containersReceivedForNM2, 2, nmTokens, nm2);
            Assert.assertEquals((int)2, (int)nmTokens.size());
            nm2 = rm.registerNode("h2:1234", 10000);
            ConcurrentMap nodes = rm.getRMContext().getRMNodes();
            while (((RMNode)nodes.get(nm2.getNodeId())).getLastNodeHeartBeatResponse().getResponseId() > 0) {
                Thread.sleep(100L);
            }
            int interval = 40;
            while (nmTokenSecretManager.isApplicationAttemptNMTokenPresent(attempt.getAppAttemptId(), nm2.getNodeId()) && interval-- > 0) {
                LOG.info((Object)("waiting for nmToken to be cleared for : " + nm2.getNodeId()));
                Thread.sleep(100L);
            }
            Assert.assertTrue((boolean)nmTokenSecretManager.isApplicationAttemptRegistered(attempt.getAppAttemptId()));
            nmTokens.remove(nm2.getNodeId().toString());
            Assert.assertEquals((int)1, (int)nmTokens.size());
            response = am.allocate("h2", 1000, 2, releaseContainerList);
            Assert.assertEquals((int)0, (int)response.getAllocatedContainers().size());
            this.allocateContainersAndValidateNMTokens(am, containersReceivedForNM2, 4, nmTokens, nm2);
            Assert.assertEquals((int)2, (int)nmTokens.size());
            Assert.assertTrue((boolean)nmTokenSecretManager.isApplicationAttemptNMTokenPresent(attempt.getAppAttemptId(), nm1.getNodeId()));
            Assert.assertTrue((boolean)nmTokenSecretManager.isApplicationAttemptNMTokenPresent(attempt.getAppAttemptId(), nm2.getNodeId()));
            nmTokenSecretManager.rollMasterKey();
            nmTokenSecretManager.activateNextMasterKey();
            Assert.assertFalse((boolean)nmTokenSecretManager.isApplicationAttemptNMTokenPresent(attempt.getAppAttemptId(), nm1.getNodeId()));
            Assert.assertFalse((boolean)nmTokenSecretManager.isApplicationAttemptNMTokenPresent(attempt.getAppAttemptId(), nm2.getNodeId()));
            Assert.assertTrue((boolean)nmTokenSecretManager.isApplicationAttemptRegistered(attempt.getAppAttemptId()));
            nmTokens.clear();
            Assert.assertEquals((int)0, (int)nmTokens.size());
            response = am.allocate("h2", 1000, 1, releaseContainerList);
            Assert.assertEquals((int)0, (int)response.getAllocatedContainers().size());
            this.allocateContainersAndValidateNMTokens(am, containersReceivedForNM2, 5, nmTokens, nm2);
            Assert.assertEquals((int)1, (int)nmTokens.size());
            Assert.assertTrue((boolean)nmTokenSecretManager.isApplicationAttemptNMTokenPresent(attempt.getAppAttemptId(), nm2.getNodeId()));
            Assert.assertTrue((boolean)nmTokenSecretManager.isApplicationAttemptRegistered(attempt.getAppAttemptId()));
            am.unregisterAppAttempt();
            for (Container container : containersReceivedForNM1) {
                nm1.nodeHeartbeat(attempt.getAppAttemptId(), container.getId().getId(), ContainerState.COMPLETE);
            }
            for (Container container : containersReceivedForNM2) {
                nm2.nodeHeartbeat(attempt.getAppAttemptId(), container.getId().getId(), ContainerState.COMPLETE);
            }
            nm1.nodeHeartbeat(am.getApplicationAttemptId(), 1, ContainerState.COMPLETE);
            am.waitForState(RMAppAttemptState.FINISHED);
            Assert.assertFalse((boolean)nmTokenSecretManager.isApplicationAttemptRegistered(attempt.getAppAttemptId()));
        }
        finally {
            rm.stop();
        }
    }

    protected void allocateContainersAndValidateNMTokens(MockAM am, ArrayList<Container> containersReceived, int totalContainerRequested, HashMap<String, Token> nmTokens, MockNM nm) throws Exception, InterruptedException {
        ArrayList<ContainerId> releaseContainerList = new ArrayList<ContainerId>();
        ArrayList<ResourceRequest> resourceRequest = new ArrayList<ResourceRequest>();
        while (containersReceived.size() < totalContainerRequested) {
            nm.nodeHeartbeat(true);
            LOG.info((Object)"requesting containers..");
            AllocateResponse response = am.allocate(resourceRequest, releaseContainerList);
            containersReceived.addAll(response.getAllocatedContainers());
            if (!response.getNMTokens().isEmpty()) {
                for (NMToken nmToken : response.getNMTokens()) {
                    String nodeId = nmToken.getNodeId().toString();
                    if (nmTokens.containsKey(nodeId)) {
                        Assert.fail((String)("Duplicate NMToken received for : " + nodeId));
                    }
                    nmTokens.put(nodeId, nmToken.getToken());
                }
            }
            LOG.info((Object)("Got " + containersReceived.size() + " containers. Waiting to get " + totalContainerRequested));
            Thread.sleep(100L);
        }
    }

    @Test(timeout=300000L)
    public void testActivatingApplicationAfterAddingNM() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm1 = new MockRM((Configuration)conf);
        rm1.start();
        RMApp app1 = rm1.submitApp(200);
        RMApp app2 = rm1.submitApp(200);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        ApplicationAttemptId attemptId1 = attempt1.getAppAttemptId();
        rm1.waitForState(attemptId1, RMAppAttemptState.SCHEDULED);
        RMAppAttempt attempt2 = app2.getCurrentAppAttempt();
        ApplicationAttemptId attemptId2 = attempt2.getAppAttemptId();
        rm1.waitForState(attemptId2, RMAppAttemptState.SCHEDULED);
        MockNM nm1 = new MockNM("h1:1234", 15120, rm1.getResourceTrackerService());
        MockNM nm2 = new MockNM("h2:5678", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        nm1.nodeHeartbeat(true);
        rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        rm1.waitForState(attemptId2, RMAppAttemptState.SCHEDULED);
        nm2.nodeHeartbeat(true);
        rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        rm1.waitForState(attemptId2, RMAppAttemptState.ALLOCATED);
        rm1.stop();
    }

    @Test(timeout=80000L)
    public void testInvalidateAMHostPortWhenAMFailedOrKilled() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        MockRM rm1 = new MockRM((Configuration)conf);
        rm1.start();
        RMApp app1 = rm1.submitApp(200);
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRM.finishAMAndVerifyAppState(app1, rm1, nm1, am1);
        RMApp app2 = rm1.submitApp(200);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        nm1.nodeHeartbeat(am2.getApplicationAttemptId(), 1, ContainerState.COMPLETE);
        am2.waitForState(RMAppAttemptState.FAILED);
        rm1.waitForState(app2.getApplicationId(), RMAppState.FAILED);
        RMApp app3 = rm1.submitApp(200);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
        rm1.killApp(app3.getApplicationId());
        rm1.waitForState(app3.getApplicationId(), RMAppState.KILLED);
        rm1.waitForState(am3.getApplicationAttemptId(), RMAppAttemptState.KILLED);
        GetApplicationsRequest request1 = GetApplicationsRequest.newInstance(EnumSet.of(YarnApplicationState.FINISHED, YarnApplicationState.KILLED, YarnApplicationState.FAILED));
        GetApplicationsResponse response1 = rm1.getClientRMService().getApplications(request1);
        List appList1 = response1.getApplicationList();
        Assert.assertEquals((int)3, (int)appList1.size());
        for (ApplicationReport report : appList1) {
            if (report.getApplicationId().equals((Object)app2.getApplicationId()) || report.getApplicationId().equals((Object)app3.getApplicationId())) {
                Assert.assertEquals((String)"N/A", (String)report.getHost());
                Assert.assertEquals((int)-1, (int)report.getRpcPort());
            }
            if (!report.getApplicationId().equals((Object)app1.getApplicationId())) continue;
            Assert.assertFalse((boolean)report.getHost().equals("N/A"));
            Assert.assertTrue((report.getRpcPort() != -1 ? 1 : 0) != 0);
        }
    }

    @Test(timeout=60000L)
    public void testInvalidatedAMHostPortOnAMRestart() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm1 = new MockRM((Configuration)conf);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app2 = rm1.submitApp(200);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        nm1.nodeHeartbeat(am2.getApplicationAttemptId(), 1, ContainerState.COMPLETE);
        am2.waitForState(RMAppAttemptState.FAILED);
        rm1.waitForState(app2.getApplicationId(), RMAppState.ACCEPTED);
        GetApplicationReportRequest request1 = GetApplicationReportRequest.newInstance((ApplicationId)app2.getApplicationId());
        ApplicationReport report1 = rm1.getClientRMService().getApplicationReport(request1).getApplicationReport();
        Assert.assertEquals((String)"N/A", (String)report1.getHost());
        Assert.assertEquals((int)-1, (int)report1.getRpcPort());
    }

    @Test(timeout=60000L)
    public void testApplicationKillAtAcceptedState() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        AsyncDispatcher dispatcher = new AsyncDispatcher(){

            public EventHandler getEventHandler() {
                EventHandler handler = (EventHandler)Mockito.spy((Object)super.getEventHandler());
                class EventArgMatcher
                extends ArgumentMatcher<AbstractEvent> {
                    EventArgMatcher() {
                    }

                    public boolean matches(Object argument) {
                        return argument instanceof RMAppAttemptEvent && ((RMAppAttemptEventType)((RMAppAttemptEvent)argument).getType()).equals((Object)RMAppAttemptEventType.KILL);
                    }
                }
                ((EventHandler)Mockito.doNothing().when((Object)handler)).handle((Event)Matchers.argThat((Matcher)new EventArgMatcher()));
                return handler;
            }
        };
        MockRM rm = new MockRM((Configuration)conf, (Dispatcher)dispatcher){
            final /* synthetic */ Dispatcher val$dispatcher;
            {
                this.val$dispatcher = dispatcher;
                super(x0);
            }

            protected Dispatcher createDispatcher() {
                return this.val$dispatcher;
            }
        };
        QueueMetrics metrics = rm.getResourceScheduler().getRootQueueMetrics();
        int appsKilled = metrics.getAppsKilled();
        int appsSubmitted = metrics.getAppsSubmitted();
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm.getResourceTrackerService());
        nm1.registerNode();
        RMApp application = rm.submitApp(200);
        MockAM am = MockRM.launchAM(application, rm, nm1);
        am.waitForState(RMAppAttemptState.LAUNCHED);
        nm1.nodeHeartbeat(am.getApplicationAttemptId(), 1, ContainerState.RUNNING);
        rm.waitForState(application.getApplicationId(), RMAppState.ACCEPTED);
        KillApplicationRequest request = KillApplicationRequest.newInstance((ApplicationId)application.getApplicationId());
        rm.getClientRMService().forceKillApplication(request);
        am.registerAppAttempt(false);
        rm.waitForState(application.getApplicationId(), RMAppState.KILLING);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        rm.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_KILLED));
        rm.waitForState(application.getApplicationId(), RMAppState.KILLED);
        metrics = rm.getResourceScheduler().getRootQueueMetrics();
        Assert.assertEquals((int)(appsKilled + 1), (int)metrics.getAppsKilled());
        Assert.assertEquals((int)(appsSubmitted + 1), (int)metrics.getAppsSubmitted());
    }

    public static void main(String[] args) throws Exception {
        TestRM t = new TestRM();
        t.testGetNewAppId();
        t.testAppWithNoContainers();
        t.testAppOnMultiNode();
        t.testNMToken();
        t.testActivatingApplicationAfterAddingNM();
        t.testInvalidateAMHostPortWhenAMFailedOrKilled();
        t.testInvalidatedAMHostPortOnAMRestart();
        t.testApplicationKillAtAcceptedState();
    }
}

