/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.security.TestClientToAMTokens;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestClientToAMTokens {
    @Test
    public void testClientToAMTokens() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        ContainerManagementProtocol containerManager = (ContainerManagementProtocol)Mockito.mock(ContainerManagementProtocol.class);
        StartContainersResponse mockResponse = (StartContainersResponse)Mockito.mock(StartContainersResponse.class);
        Mockito.when((Object)containerManager.startContainers((StartContainersRequest)Matchers.any())).thenReturn((Object)mockResponse);
        DrainDispatcher dispatcher = new DrainDispatcher();
        1 rm = new /* Unavailable Anonymous Inner Class!! */;
        rm.start();
        RMApp app = rm.submitApp(1024);
        MockNM nm1 = rm.registerNode("localhost:1234", 3072);
        nm1.nodeHeartbeat(true);
        dispatcher.await();
        nm1.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttempt = app.getCurrentAppAttempt().getAppAttemptId();
        MockAM mockAM = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.getApplicationMasterService(), app.getCurrentAppAttempt().getAppAttemptId());
        UserGroupInformation appUgi = UserGroupInformation.createRemoteUser((String)appAttempt.toString());
        RegisterApplicationMasterResponse response = (RegisterApplicationMasterResponse)appUgi.doAs((PrivilegedAction)new /* Unavailable Anonymous Inner Class!! */);
        GetApplicationReportRequest request = (GetApplicationReportRequest)Records.newRecord(GetApplicationReportRequest.class);
        request.setApplicationId(app.getApplicationId());
        GetApplicationReportResponse reportResponse = rm.getClientRMService().getApplicationReport(request);
        ApplicationReport appReport = reportResponse.getApplicationReport();
        org.apache.hadoop.yarn.api.records.Token originalClientToAMToken = appReport.getClientToAMToken();
        junit.framework.Assert.assertNotNull((Object)response.getClientToAMTokenMasterKey());
        junit.framework.Assert.assertTrue((response.getClientToAMTokenMasterKey().array().length > 0 ? 1 : 0) != 0);
        ApplicationAttemptId appAttemptId = (ApplicationAttemptId)app.getAppAttempts().keySet().iterator().next();
        junit.framework.Assert.assertNotNull((Object)appAttemptId);
        CustomAM am = new CustomAM(appAttemptId, response.getClientToAMTokenMasterKey().array());
        am.init(conf);
        am.start();
        SecurityUtil.setSecurityInfoProviders((SecurityInfo[])new SecurityInfo[]{new CustomSecurityInfo(null)});
        try {
            CustomProtocol client = (CustomProtocol)RPC.getProxy(CustomProtocol.class, (long)1L, (InetSocketAddress)CustomAM.access$100((CustomAM)am), (Configuration)conf);
            client.ping();
            Assert.fail((String)"Access by unauthenticated user should fail!!");
        }
        catch (Exception e) {
            junit.framework.Assert.assertFalse((boolean)CustomAM.access$200((CustomAM)am));
        }
        Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)originalClientToAMToken, (InetSocketAddress)CustomAM.access$100((CustomAM)am));
        this.verifyTokenWithTamperedID(conf, am, token);
        this.verifyTokenWithTamperedUserName(conf, am, token);
        this.verifyValidToken(conf, am, token);
    }

    private void verifyTokenWithTamperedID(Configuration conf, CustomAM am, Token<ClientToAMTokenIdentifier> token) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"me");
        ClientToAMTokenIdentifier maliciousID = new ClientToAMTokenIdentifier(BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)CustomAM.access$300((CustomAM)am).getApplicationId().getClusterTimestamp(), (int)42), (int)43), UserGroupInformation.getCurrentUser().getShortUserName());
        this.verifyTamperedToken(conf, am, token, ugi, maliciousID);
    }

    private void verifyTokenWithTamperedUserName(Configuration conf, CustomAM am, Token<ClientToAMTokenIdentifier> token) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"me");
        ClientToAMTokenIdentifier maliciousID = new ClientToAMTokenIdentifier(CustomAM.access$300((CustomAM)am), "evilOrc");
        this.verifyTamperedToken(conf, am, token, ugi, maliciousID);
    }

    private void verifyTamperedToken(Configuration conf, CustomAM am, Token<ClientToAMTokenIdentifier> token, UserGroupInformation ugi, ClientToAMTokenIdentifier maliciousID) {
        Token maliciousToken = new Token(maliciousID.getBytes(), token.getPassword(), token.getKind(), token.getService());
        ugi.addToken(maliciousToken);
        try {
            ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e2) {
            junit.framework.Assert.assertEquals((String)RemoteException.class.getName(), (String)e2.getClass().getName());
            IOException e2 = ((RemoteException)e2).unwrapRemoteException();
            junit.framework.Assert.assertEquals((String)SaslException.class.getCanonicalName(), (String)e2.getClass().getCanonicalName());
            junit.framework.Assert.assertTrue((boolean)e2.getMessage().contains("DIGEST-MD5: digest response format violation. Mismatched response."));
            junit.framework.Assert.assertFalse((boolean)CustomAM.access$200((CustomAM)am));
        }
    }

    private void verifyValidToken(Configuration conf, CustomAM am, Token<ClientToAMTokenIdentifier> token) throws IOException, InterruptedException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"me");
        ugi.addToken(token);
        ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }
}

