/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.DiskBasedResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class FifoScheduler
extends AbstractYarnScheduler
implements Configurable {
    private static final Log LOG = LogFactory.getLog(FifoScheduler.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    Configuration conf;
    protected Map<NodeId, FiCaSchedulerNode> nodes = new ConcurrentHashMap();
    private boolean initialized;
    private Resource minimumAllocation;
    private Resource maximumAllocation;
    private boolean usePortForNodeName;
    private ActiveUsersManager activeUsersManager;
    private static final String DEFAULT_QUEUE_NAME = "default";
    private static final String DEFAULT_QUEUE_LABEL_TAG = "label";
    private static final String DEFAULT_QUEUE_LABEL_POLICY_TAG = "labelPolicy";
    private static final String DOT = ".";
    private QueueMetrics metrics;
    private final ResourceCalculator resourceCalculator = new DiskBasedResourceCalculator();
    private final Queue DEFAULT_QUEUE = new /* Unavailable Anonymous Inner Class!! */;
    private Resource clusterResource = (Resource)recordFactory.newRecordInstance(Resource.class);
    private Resource usedResource = (Resource)recordFactory.newRecordInstance(Resource.class);

    public synchronized void setConf(Configuration conf) {
        this.conf = conf;
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem <= 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min and max should be greater than 0" + ", max should be no smaller than min.");
        }
    }

    public synchronized Configuration getConf() {
        return this.conf;
    }

    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    public int getNumClusterNodes() {
        return this.nodes.size();
    }

    public Resource getMaximumResourceCapability() {
        return this.maximumAllocation;
    }

    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        this.setConf(conf);
        if (!this.initialized) {
            this.validateConf(conf);
            this.rmContext = rmContext;
            this.applications = new ConcurrentSkipListMap();
            this.minimumAllocation = Resources.createResource((int)conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024), (int)conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1), (double)conf.getDouble("yarn.scheduler.minimum-allocation-disks", 0.0));
            this.maximumAllocation = Resources.createResource((int)conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192), (int)conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4), (double)conf.getDouble("yarn.scheduler.maximum-allocation-disks", 4.0));
            this.usePortForNodeName = conf.getBoolean("yarn.scheduler.include-port-in-node-name", false);
            this.metrics = QueueMetrics.forQueue((String)DEFAULT_QUEUE_NAME, null, (boolean)false, (Configuration)conf);
            this.activeUsersManager = new ActiveUsersManager(this.metrics);
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        FiCaSchedulerApp application = this.getApplicationAttempt(applicationAttemptId);
        if (application == null) {
            LOG.error((Object)("Calling allocate on removed or non existant application " + applicationAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, (ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)this.minimumAllocation, (Resource)this.maximumAllocation);
        for (ContainerId releasedContainer : release) {
            RMContainer rmContainer = this.getRMContainer(releasedContainer);
            if (rmContainer == null) {
                RMAuditLogger.logFailure((String)application.getUser(), (String)"AM Released Container", (String)"Unauthorized access or invalid container", (String)"FifoScheduler", (String)"Trying to release container not owned by app or with invalid id", (ApplicationId)application.getApplicationId(), (ContainerId)releasedContainer);
            }
            this.containerCompleted(rmContainer, SchedulerUtils.createAbnormalContainerStatus((ContainerId)releasedContainer, (String)"Container released by application"), RMContainerEventType.RELEASED);
        }
        FiCaSchedulerApp fiCaSchedulerApp = application;
        synchronized (fiCaSchedulerApp) {
            if (application.isStopped()) {
                LOG.info((Object)("Calling allocate on a stopped application " + applicationAttemptId));
                return EMPTY_ALLOCATION;
            }
            if (!ask.isEmpty()) {
                LOG.debug((Object)("allocate: pre-update applicationId=" + applicationAttemptId + " application=" + application));
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)("allocate: post-update applicationId=" + applicationAttemptId + " application=" + application));
                application.showRequests();
                LOG.debug((Object)("allocate: applicationId=" + applicationAttemptId + " #ask=" + ask.size()));
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            SchedulerApplicationAttempt.ContainersAndNMTokensAllocation allocation = application.pullNewlyAllocatedContainersAndNMTokens();
            return new Allocation(allocation.getContainerList(), application.getHeadroom(), null, null, null, allocation.getNMTokenList());
        }
    }

    @VisibleForTesting
    FiCaSchedulerApp getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        SchedulerApplication app = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        if (app != null) {
            return (FiCaSchedulerApp)app.getCurrentAppAttempt();
        }
        return null;
    }

    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId applicationAttemptId) {
        FiCaSchedulerApp app = this.getApplicationAttempt(applicationAttemptId);
        return app == null ? null : new SchedulerAppReport((SchedulerApplicationAttempt)app);
    }

    public ApplicationResourceUsageReport getAppResourceUsageReport(ApplicationAttemptId applicationAttemptId) {
        FiCaSchedulerApp app = this.getApplicationAttempt(applicationAttemptId);
        return app == null ? null : app.getResourceUsageReport();
    }

    private FiCaSchedulerNode getNode(NodeId nodeId) {
        return (FiCaSchedulerNode)this.nodes.get(nodeId);
    }

    @VisibleForTesting
    public synchronized void addApplication(ApplicationId applicationId, String queue, String user) {
        SchedulerApplication application = new SchedulerApplication(this.DEFAULT_QUEUE, user);
        this.applications.put(applicationId, application);
        this.metrics.submitApp(user);
        LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", currently num of applications: " + this.applications.size()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
    }

    @VisibleForTesting
    public synchronized void addApplicationAttempt(ApplicationAttemptId appAttemptId, boolean transferStateFromPreviousAttempt) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(appAttemptId.getApplicationId());
        String user = application.getUser();
        FiCaSchedulerApp schedulerApp = new FiCaSchedulerApp(appAttemptId, user, this.DEFAULT_QUEUE, this.activeUsersManager, this.rmContext);
        if (transferStateFromPreviousAttempt) {
            schedulerApp.transferStateFromPreviousAttempt(application.getCurrentAppAttempt());
        }
        application.setCurrentAppAttempt((SchedulerApplicationAttempt)schedulerApp);
        this.metrics.submitAppAttempt(user);
        LOG.info((Object)("Added Application Attempt " + appAttemptId + " to scheduler from user " + application.getUser()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
    }

    private synchronized void doneApplication(ApplicationId applicationId, RMAppState finalState) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
        if (application == null) {
            LOG.warn((Object)("Couldn't find application " + applicationId));
            return;
        }
        this.activeUsersManager.deactivateApplication(application.getUser(), applicationId);
        application.stop(finalState);
        this.applications.remove(applicationId);
    }

    private synchronized void doneApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) throws IOException {
        FiCaSchedulerApp attempt = this.getApplicationAttempt(applicationAttemptId);
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        if (application == null || attempt == null) {
            throw new IOException("Unknown application " + applicationAttemptId + " has completed!");
        }
        for (RMContainer container : attempt.getLiveContainers()) {
            if (keepContainers && container.getState().equals((Object)RMContainerState.RUNNING)) {
                LOG.info((Object)("Skip killing " + container.getContainerId()));
                continue;
            }
            this.containerCompleted(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container of a completed application"), RMContainerEventType.KILL);
        }
        attempt.stop(rmAppAttemptFinalState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignContainers(FiCaSchedulerNode node) {
        LOG.debug((Object)("assignContainers: node=" + node.getRMNode().getNodeAddress() + " #applications=" + this.applications.size()));
        for (Map.Entry e : this.applications.entrySet()) {
            FiCaSchedulerApp application = (FiCaSchedulerApp)((SchedulerApplication)e.getValue()).getCurrentAppAttempt();
            if (application == null) continue;
            LOG.debug((Object)"pre-assignContainers");
            application.showRequests();
            FiCaSchedulerApp fiCaSchedulerApp = application;
            synchronized (fiCaSchedulerApp) {
                int assignedContainers;
                Priority priority;
                int maxContainers;
                if (SchedulerAppUtils.isBlacklisted((SchedulerApplicationAttempt)application, (SchedulerNode)node, (Log)LOG)) {
                    continue;
                }
                Iterator i$ = application.getPriorities().iterator();
                while (i$.hasNext() && ((maxContainers = this.getMaxAllocatableContainers(application, priority = (Priority)i$.next(), node, NodeType.OFF_SWITCH)) <= 0 || (assignedContainers = this.assignContainersOnNode(node, application, priority)) != 0)) {
                }
            }
            LOG.debug((Object)"post-assignContainers");
            application.showRequests();
            if (!Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)node.getAvailableResource(), (Resource)this.minimumAllocation)) continue;
            break;
        }
        for (SchedulerApplication application : this.applications.values()) {
            FiCaSchedulerApp attempt = (FiCaSchedulerApp)application.getCurrentAppAttempt();
            if (attempt == null) continue;
            attempt.setHeadroom(Resources.subtract((Resource)this.clusterResource, (Resource)this.usedResource));
        }
    }

    private int getMaxAllocatableContainers(FiCaSchedulerApp application, Priority priority, FiCaSchedulerNode node, NodeType type) {
        ResourceRequest nodeLocalRequest;
        int maxContainers = 0;
        ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
        if (offSwitchRequest != null) {
            maxContainers = offSwitchRequest.getNumContainers();
        }
        if (type == NodeType.OFF_SWITCH) {
            return maxContainers;
        }
        if (type == NodeType.RACK_LOCAL) {
            ResourceRequest rackLocalRequest = application.getResourceRequest(priority, node.getRMNode().getRackName());
            if (rackLocalRequest == null) {
                return maxContainers;
            }
            maxContainers = Math.min(maxContainers, rackLocalRequest.getNumContainers());
        }
        if (type == NodeType.NODE_LOCAL && (nodeLocalRequest = application.getResourceRequest(priority, node.getRMNode().getNodeAddress())) != null) {
            maxContainers = Math.min(maxContainers, nodeLocalRequest.getNumContainers());
        }
        return maxContainers;
    }

    private int assignContainersOnNode(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int nodeLocalContainers = this.assignNodeLocalContainers(node, application, priority);
        int rackLocalContainers = this.assignRackLocalContainers(node, application, priority);
        int offSwitchContainers = this.assignOffSwitchContainers(node, application, priority);
        LOG.debug((Object)("assignContainersOnNode: node=" + node.getRMNode().getNodeAddress() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " #assigned=" + (nodeLocalContainers + rackLocalContainers + offSwitchContainers)));
        return nodeLocalContainers + rackLocalContainers + offSwitchContainers;
    }

    private int assignNodeLocalContainers(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, node.getNodeName());
        if (request != null) {
            ResourceRequest rackRequest = application.getResourceRequest(priority, node.getRMNode().getRackName());
            if (rackRequest == null || rackRequest.getNumContainers() <= 0) {
                return 0;
            }
            int assignableContainers = Math.min(this.getMaxAllocatableContainers(application, priority, node, NodeType.NODE_LOCAL), request.getNumContainers());
            assignedContainers = this.assignContainer(node, application, priority, assignableContainers, request, NodeType.NODE_LOCAL);
        }
        return assignedContainers;
    }

    private int assignRackLocalContainers(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, node.getRMNode().getRackName());
        if (request != null) {
            ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
            if (offSwitchRequest.getNumContainers() <= 0) {
                return 0;
            }
            int assignableContainers = Math.min(this.getMaxAllocatableContainers(application, priority, node, NodeType.RACK_LOCAL), request.getNumContainers());
            assignedContainers = this.assignContainer(node, application, priority, assignableContainers, request, NodeType.RACK_LOCAL);
        }
        return assignedContainers;
    }

    private int assignOffSwitchContainers(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, "*");
        if (request != null) {
            assignedContainers = this.assignContainer(node, application, priority, request.getNumContainers(), request, NodeType.OFF_SWITCH);
        }
        return assignedContainers;
    }

    private int assignContainer(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, int assignableContainers, ResourceRequest request, NodeType type) {
        LOG.debug((Object)("assignContainers: node=" + node.getRMNode().getNodeAddress() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " assignableContainers=" + assignableContainers + " request=" + request + " type=" + type));
        Resource capability = request.getCapability();
        for (int i = 0; i < assignableContainers; ++i) {
            if (!Resources.fitsIn((Resource)capability, (Resource)node.getAvailableResource())) {
                return i;
            }
            NodeId nodeId = node.getRMNode().getNodeID();
            ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (int)application.getNewContainerId());
            Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, null);
            RMContainer rmContainer = application.allocate(type, node, priority, request, container);
            node.allocateContainer(application.getApplicationId(), rmContainer);
            Resources.addTo((Resource)this.usedResource, (Resource)capability);
        }
        return assignableContainers;
    }

    private synchronized void nodeUpdate(RMNode rmNode) {
        FiCaSchedulerNode node = this.getNode(rmNode.getNodeID());
        SchedulerUtils.updateResourceIfChanged((SchedulerNode)node, (RMNode)rmNode, (Resource)this.clusterResource, (Log)LOG);
        List containerInfoList = rmNode.pullContainerUpdates();
        ArrayList newlyLaunchedContainers = new ArrayList();
        ArrayList completedContainers = new ArrayList();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.containerCompleted(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        if (Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)node.getAvailableResource(), (Resource)this.minimumAllocation)) {
            LOG.debug((Object)("Node heartbeat " + rmNode.getNodeID() + " available resource = " + node.getAvailableResource()));
            this.assignContainers(node);
            LOG.debug((Object)("Node after allocation " + rmNode.getNodeID() + " resource = " + node.getAvailableResource()));
        }
        this.metrics.setAvailableResourcesToQueue(Resources.subtract((Resource)this.clusterResource, (Resource)this.usedResource));
    }

    public void handle(SchedulerEvent event) {
        switch (2.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$scheduler$event$SchedulerEventType[((SchedulerEventType)event.getType()).ordinal()]) {
            case 1: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                break;
            }
            case 2: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case 3: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case 4: {
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                this.addApplication(appAddedEvent.getApplicationId(), appAddedEvent.getQueue(), appAddedEvent.getUser());
                break;
            }
            case 5: {
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.doneApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case 6: {
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt());
                break;
            }
            case 7: {
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                try {
                    this.doneApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                }
                catch (IOException ie) {
                    LOG.error((Object)("Unable to remove application " + appAttemptRemovedEvent.getApplicationAttemptID()), (Throwable)ie);
                }
                break;
            }
            case 8: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerid = containerExpiredEvent.getContainerId();
                this.containerCompleted(this.getRMContainer(containerid), SchedulerUtils.createAbnormalContainerStatus((ContainerId)containerid, (String)"Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    private void containerLaunchedOnNode(ContainerId containerId, FiCaSchedulerNode node) {
        FiCaSchedulerApp application = this.getCurrentAttemptForContainer(containerId);
        if (application == null) {
            LOG.info((Object)("Unknown application " + containerId.getApplicationAttemptId().getApplicationId() + " launched container " + containerId + " on node: " + node));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
            return;
        }
        application.containerLaunchedOnNode(containerId, node.getNodeID());
    }

    @Lock(value={FifoScheduler.class})
    private synchronized void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        FiCaSchedulerApp application = this.getCurrentAttemptForContainer(container.getId());
        ApplicationId appId = container.getId().getApplicationAttemptId().getApplicationId();
        FiCaSchedulerNode node = this.getNode(container.getNodeId());
        if (application == null) {
            LOG.info((Object)("Unknown application: " + appId + " released container " + container.getId() + " on node: " + node + " with event: " + event));
            return;
        }
        application.containerCompleted(rmContainer, containerStatus, event);
        node.releaseContainer(container);
        Resources.subtractFrom((Resource)this.usedResource, (Resource)container.getResource());
        LOG.info((Object)("Application attempt " + application.getApplicationAttemptId() + " released container " + container.getId() + " on node: " + node + " with event: " + event));
    }

    private synchronized void removeNode(RMNode nodeInfo) {
        FiCaSchedulerNode node = this.getNode(nodeInfo.getNodeID());
        if (node == null) {
            return;
        }
        for (RMContainer container : node.getRunningContainers()) {
            this.containerCompleted(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(nodeInfo.getNodeID());
        Resources.subtractFrom((Resource)this.clusterResource, (Resource)node.getRMNode().getTotalCapability());
    }

    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) {
        return this.DEFAULT_QUEUE.getQueueInfo(false, false);
    }

    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        return this.DEFAULT_QUEUE.getQueueUserAclInfo(null);
    }

    private synchronized void addNode(RMNode nodeManager) {
        this.nodes.put(nodeManager.getNodeID(), new FiCaSchedulerNode(nodeManager, this.usePortForNodeName));
        Resources.addTo((Resource)this.clusterResource, (Resource)nodeManager.getTotalCapability());
    }

    public void recover(RMStateStore.RMState state) {
    }

    public synchronized SchedulerNodeReport getNodeReport(NodeId nodeId) {
        FiCaSchedulerNode node = this.getNode(nodeId);
        return node == null ? null : new SchedulerNodeReport((SchedulerNode)node);
    }

    public RMContainer getRMContainer(ContainerId containerId) {
        FiCaSchedulerApp attempt = this.getCurrentAttemptForContainer(containerId);
        return attempt == null ? null : attempt.getRMContainer(containerId);
    }

    private FiCaSchedulerApp getCurrentAttemptForContainer(ContainerId containerId) {
        SchedulerApplication app = (SchedulerApplication)this.applications.get(containerId.getApplicationAttemptId().getApplicationId());
        if (app != null) {
            return (FiCaSchedulerApp)app.getCurrentAppAttempt();
        }
        return null;
    }

    public QueueMetrics getRootQueueMetrics() {
        return this.DEFAULT_QUEUE.getMetrics();
    }

    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        return this.DEFAULT_QUEUE.hasAccess(acl, callerUGI);
    }

    public synchronized List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        if (queueName.equals(this.DEFAULT_QUEUE.getQueueName())) {
            ArrayList<ApplicationAttemptId> attempts = new ArrayList<ApplicationAttemptId>(this.applications.size());
            for (SchedulerApplication app : this.applications.values()) {
                attempts.add(app.getCurrentAppAttempt().getApplicationAttemptId());
            }
            return attempts;
        }
        return null;
    }

    static /* synthetic */ QueueMetrics access$000(FifoScheduler x0) {
        return x0.metrics;
    }

    static /* synthetic */ RecordFactory access$100() {
        return recordFactory;
    }

    static /* synthetic */ Queue access$200(FifoScheduler x0) {
        return x0.DEFAULT_QUEUE;
    }

    static /* synthetic */ Resource access$300(FifoScheduler x0) {
        return x0.clusterResource;
    }

    static /* synthetic */ Resource access$400(FifoScheduler x0) {
        return x0.usedResource;
    }

    static /* synthetic */ ActiveUsersManager access$500(FifoScheduler x0) {
        return x0.activeUsersManager;
    }

    static /* synthetic */ Log access$600() {
        return LOG;
    }
}

